/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jung;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.ToolTipFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.DefaultSettableVertexLocationFunction;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.contrib.KKLayout;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.colormap.ColorMap;
import org.ujmp.jung.JungGraphPanel;

public class ProjectionPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -6575744654019554947L;
    private final int xAxis = 0;
    private final int yAxis = 1;
    private Graph g = null;
    private VisualizationViewer vv = null;
    AbstractLayout layout = null;
    DefaultSettableVertexLocationFunction vertexLocations = new DefaultSettableVertexLocationFunction();

    public ProjectionPanel(Object iVariables) throws MatrixException {
        this.addMouseListener(this);
        this.g = new DirectedSparseGraph();
        this.layout = new KKLayout(this.g);
        PluggableRenderer pr = new PluggableRenderer();
        this.vv = new VisualizationViewer((Layout)this.layout, (Renderer)pr);
        this.vv.setPickSupport((PickSupport)new ShapePickSupport());
        pr.setEdgeShapeFunction((EdgeShapeFunction)new EdgeShape.QuadCurve());
        pr.setVertexStringer(new VertexStringer(){

            public String getLabel(ArchetypeVertex v) {
                return "" + v.getUserDatum((Object)JungGraphPanel.Data.Label);
            }
        });
        pr.setVertexPaintFunction(new VertexPaintFunction(){

            public Paint getFillPaint(Vertex v) {
                return ProjectionPanel.fromDouble((Double)v.getUserDatum((Object)JungGraphPanel.Data.Time));
            }

            public Paint getDrawPaint(Vertex v) {
                return Color.BLACK;
            }
        });
        this.vv.setToolTipFunction(new ToolTipFunction(){

            public String getToolTipText(Vertex v) {
                return ((MatrixGUIObject)v.getUserDatum((Object)JungGraphPanel.Data.Matrix)).getToolTipText();
            }

            public String getToolTipText(Edge e) {
                return "";
            }

            public String getToolTipText(MouseEvent event) {
                return "";
            }
        });
        this.setLayout(new BorderLayout());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.updateGraph();
        this.add((Component)this.vv, "Center");
    }

    public void updateGraph() throws MatrixException {
        this.vv.stop();
        this.g.removeAllEdges();
        this.g.removeAllVertices();
        this.vv.restart();
    }

    public void mouseClicked(MouseEvent e) {
        System.out.println("click");
        try {
            this.updateGraph();
        }
        catch (MatrixException e1) {
            e1.printStackTrace();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private static final Color fromDouble(double v) {
        if (v == Double.MIN_VALUE || Double.isNaN(v)) {
            return Color.MAGENTA;
        }
        if (Double.isInfinite(v)) {
            return Color.CYAN;
        }
        if (v > 1.0) {
            return ColorMap.colorGreenToYellow[(int)(255.0 * Math.tanh((v - 1.0) / 10.0))];
        }
        if (v > 0.0) {
            return ColorMap.colorBlackToGreen[(int)(255.0 * v)];
        }
        if (v > -1.0) {
            return ColorMap.colorRedToBlack[(int)(255.0 * (v + 1.0))];
        }
        return ColorMap.colorRedToMagenta[(int)(255.0 * Math.tanh((-v - 1.0) / 10.0))];
    }
}

