/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.colormap;

import java.awt.Color;
import org.ujmp.gui.colormap.ColorMap;

public class ColorMapper {
    private double min = 0.0;
    private double max = 10.0;
    private double a = 10.0;
    private double b = 0.0;
    private ColorMap colorMap = ColorMap.DEFAULT;
    private int colorCount = this.colorMap.size();

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
        this.colorCount = colorMap.size();
        this.a = (double)this.colorCount / (this.max - this.min);
        this.b = -this.min * this.a;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        if (this.max >= max) {
            return;
        }
        if (max == this.min) {
            this.min = max - 10.0;
        }
        this.max = max;
        this.a = (double)this.colorCount / (max - this.min);
        this.b = -this.min * this.a;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        if (this.min <= min) {
            return;
        }
        if (min == this.max) {
            this.max = min + 10.0;
        }
        this.min = min;
        this.a = (double)this.colorCount / (this.max - min);
        this.b = -min * this.a;
    }

    public ColorMapper() {
        this.setMax(1.0);
        this.setMin(0.0);
    }

    public ColorMapper(double minValue, double maxValue) {
        this();
        this.setMax(maxValue);
        this.setMin(minValue);
    }

    public Color fromDouble2(double v) {
        return this.colorMap.get(this.getIndex(v));
    }

    public static final Color fromDouble(double v) {
        if (v == Double.MIN_VALUE || Double.isNaN(v)) {
            return Color.MAGENTA;
        }
        if (Double.isInfinite(v)) {
            return Color.CYAN;
        }
        if (v > 1.0) {
            return ColorMap.colorGreenToYellow[(int)(255.0 * Math.tanh((v - 1.0) / 10.0))];
        }
        if (v > 0.0) {
            return ColorMap.colorBlackToGreen[(int)(255.0 * v)];
        }
        if (v > -1.0) {
            return ColorMap.colorRedToBlack[(int)(255.0 * (v + 1.0))];
        }
        return ColorMap.colorRedToMagenta[(int)(255.0 * Math.tanh((-v - 1.0) / 10.0))];
    }

    public Color fromString(String s) {
        if (s == null) {
            return Color.black;
        }
        int hc = Math.abs(ColorMapper.hash(s.hashCode()));
        int r = 192 + hc % 256 / 4;
        int g = 192 + (hc /= 256) % 256 / 4;
        int b = 192 + (hc /= 256) % 256 / 4;
        return new Color(r > 255 ? 255 : r, g > 255 ? 255 : g, b > 255 ? 255 : b);
    }

    private static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public Color fromObject(Object v) {
        if (v == null) {
            return Color.black;
        }
        if (v instanceof Double) {
            return ColorMapper.fromDouble((Double)v);
        }
        return this.fromString(v.toString());
    }

    private int getIndex(double v) {
        int index = (int)(v * this.a + this.b);
        return index;
    }
}

