/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static boolean deleteRecursive(File path) {
        if (path != null && path.exists()) {
            File[] files;
            File[] fileArray = files = path.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    FileUtil.deleteRecursive(f);
                } else {
                    f.delete();
                }
                ++n2;
            }
        }
        if (path != null) {
            return path.delete();
        }
        return false;
    }

    public static boolean equalsContent(File file1, File file2) throws Exception {
        int i1;
        if (file1.length() != file2.length()) {
            return false;
        }
        boolean areEqual = true;
        BufferedInputStream in1 = new BufferedInputStream(new FileInputStream(file1));
        BufferedInputStream in2 = new BufferedInputStream(new FileInputStream(file2));
        do {
            int i2;
            if ((i1 = in1.read()) == (i2 = in2.read())) continue;
            areEqual = false;
            break;
        } while (i1 != -1);
        in1.close();
        in2.close();
        return areEqual;
    }

    public static void move(File source, File target) {
    }

    public static String md5Sum(File file) throws Exception {
        return MathUtil.md5(file);
    }

    public static List<List<File>> findDuplicates(File path) throws Exception {
        return FileUtil.findDuplicates(path, new HashMap<String, List<File>>());
    }

    private static List<List<File>> findDuplicates(File path, Map<String, List<File>> md5Map) throws Exception {
        File[] files;
        ArrayList<List<File>> list = new ArrayList<List<File>>();
        File[] fileArray = files = path.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                List<List<File>> subDirList = FileUtil.findDuplicates(file);
                list.addAll(subDirList);
            } else {
                System.out.print(file);
                String md5 = FileUtil.md5Sum(file);
                System.out.println(" [" + md5 + "]");
                List<File> similarFiles = md5Map.get(md5);
                if (similarFiles == null) {
                    similarFiles = new LinkedList<File>();
                    md5Map.put(md5, similarFiles);
                }
                if (!similarFiles.isEmpty()) {
                    System.out.println("   " + similarFiles.size() + " files with same md5");
                    for (File similarFile : similarFiles) {
                        if (!FileUtil.equalsContent(file, similarFile)) continue;
                        System.out.println("   match found: " + similarFile);
                        LinkedList<File> set = new LinkedList<File>();
                        set.add(file);
                        set.add(similarFile);
                        list.add(set);
                    }
                }
                similarFiles.add(file);
            }
            ++n2;
        }
        return list;
    }

    public static int countFiles(File path) {
        int count = 0;
        File[] files = path.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                count = f.isDirectory() ? (count += FileUtil.countFiles(f)) : ++count;
                ++n2;
            }
        }
        return count;
    }
}

