/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.util.Iterator;
import org.ujmp.core.exceptions.MatrixException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinateIterator2D
implements Iterable<long[]> {
    private static final int ROW = 0;
    private static final int COLUMN = 1;
    private long[] size = null;

    public CoordinateIterator2D(long ... size) {
        this.size = size;
        if (size.length > 2) {
            new Exception("warning: using a 2d iterator on a matrix or calculation that has more than 2 dimensions, results may be wrong").printStackTrace();
        }
    }

    @Override
    public Iterator<long[]> iterator() {
        return new Iterator<long[]>(){
            long[] cursor;
            long columnCount;
            long rowCount;
            long rowMinus1;
            long columnMinus1;
            boolean isNotEmpty;
            {
                long[] lArray = new long[2];
                lArray[1] = -1L;
                this.cursor = lArray;
                this.columnCount = CoordinateIterator2D.this.size[1];
                this.rowCount = CoordinateIterator2D.this.size[0];
                this.rowMinus1 = this.rowCount - 1L;
                this.columnMinus1 = this.columnCount - 1L;
                this.isNotEmpty = this.columnCount != 0L && this.rowCount != 0L;
            }

            @Override
            public boolean hasNext() {
                return (this.cursor[0] != this.rowMinus1 || this.cursor[1] != this.columnMinus1) && this.isNotEmpty;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public long[] next() {
                long[] lArray;
                this.cursor[1] = this.cursor[1] + 1L;
                if (this.cursor[1] == this.columnCount) {
                    this.cursor[1] = 0L;
                    this.cursor[0] = this.cursor[0] + 1L;
                    if (0L == this.cursor[0]) {
                        lArray = this.cursor;
                        return lArray;
                    }
                }
                lArray = this.cursor;
                return lArray;
            }

            @Override
            public void remove() {
                throw new MatrixException("not implemented");
            }
        };
    }
}

