/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ujmp.core.collections.SoftHashMap;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.stringmatrix.stub.AbstractSparseStringMatrix2D;
import org.ujmp.core.util.io.IntelligentFileReader;
import org.ujmp.core.util.io.SeekableLineInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseCSVMatrix
extends AbstractSparseStringMatrix2D {
    private static final long serialVersionUID = 3021406834325366430L;
    private String fieldDelimiter = "\t";
    private long[] size = null;
    private SeekableLineInputStream sli = null;
    private final Map<Long, Object[]> data = new SoftHashMap<Long, Object[]>();
    private final Map<Long, List<Long>> rowToLine = new HashMap<Long, List<Long>>();

    public SparseCSVMatrix(String file, Object ... parameters) throws IOException {
        this(new File(file), parameters);
    }

    public SparseCSVMatrix(File file, Object ... parameters) throws IOException {
        if (parameters.length != 0 && parameters[0] instanceof String) {
            this.fieldDelimiter = (String)parameters[0];
        }
        long rows = 0L;
        long cols = 0L;
        long lastRow = -1L;
        IntelligentFileReader lr = new IntelligentFileReader(file);
        System.out.print("determining matrix size.");
        long i = 0L;
        String line = null;
        while ((line = lr.readLine()) != null) {
            if (i % 100000L == 0L) {
                System.out.print(".");
            }
            String[] fields = line.split(this.fieldDelimiter);
            long row = Long.parseLong(fields[0]);
            long col = Long.parseLong(fields[1]);
            if (row > rows) {
                rows = row;
            }
            if (col > cols) {
                cols = col;
            }
            if (lastRow != row) {
                lastRow = row;
                List<Long> list = this.rowToLine.get(row);
                if (list == null) {
                    list = new LinkedList<Long>();
                    this.rowToLine.put(row, list);
                }
                list.add(i);
            }
            ++i;
        }
        lr.close();
        this.size = new long[]{rows, cols};
        System.out.println("ok");
        this.sli = new SeekableLineInputStream(file);
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public String getString(long row, long column) throws MatrixException {
        List<Long> linesToCheck;
        block7: {
            linesToCheck = this.rowToLine.get(row);
            if (linesToCheck != null) break block7;
            return null;
        }
        try {
            Iterator<Long> iterator = linesToCheck.iterator();
            block3: while (iterator.hasNext()) {
                long startLine;
                long l = startLine = iterator.next().longValue();
                while (l < (long)this.sli.getLineCount()) {
                    Object[] objects = this.data.get(l);
                    if (objects == null) {
                        String line = this.sli.readLine((int)l);
                        String[] strings = line.split(this.fieldDelimiter);
                        long foundRow = Long.parseLong(strings[0]);
                        long foundColumn = Long.parseLong(strings[1]);
                        objects = new Object[]{foundRow, foundColumn, strings[2]};
                        this.data.put(l, objects);
                    }
                    if ((Long)objects[0] != row) continue block3;
                    if ((Long)objects[1] == column) {
                        return (String)objects[2];
                    }
                    ++l;
                }
            }
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
        return null;
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new Iterable<long[]>(){

            @Override
            public Iterator<long[]> iterator() {
                return new SparseCSVMatrixIterator();
            }
        };
    }

    @Override
    public void setString(String value, long row, long column) {
    }

    @Override
    public boolean contains(long ... coordinates) throws MatrixException {
        return this.getString(coordinates) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SparseCSVMatrixIterator
    implements Iterator<long[]> {
        long l = 0L;

        SparseCSVMatrixIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.l < (long)SparseCSVMatrix.this.sli.getLineCount();
        }

        @Override
        public long[] next() {
            try {
                Object[] objects = (Object[])SparseCSVMatrix.this.data.get(this.l);
                if (objects == null) {
                    String line = SparseCSVMatrix.this.sli.readLine((int)this.l);
                    String[] strings = line.split(SparseCSVMatrix.this.fieldDelimiter);
                    long row = Long.parseLong(strings[0]);
                    long col = Long.parseLong(strings[1]);
                    objects = new Object[]{row, col, strings[2]};
                    SparseCSVMatrix.this.data.put(this.l, objects);
                }
                long[] c = new long[]{(Long)objects[0], (Long)objects[1]};
                ++this.l;
                return c;
            }
            catch (Exception e) {
                throw new MatrixException(e);
            }
        }

        @Override
        public void remove() {
        }
    }
}

