/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.calculation;

import java.util.Collection;
import org.ujmp.core.Matrix;
import org.ujmp.core.annotation.Annotation;
import org.ujmp.core.annotation.DefaultAnnotation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.calculation.AbstractObjectCalculation;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selection
extends AbstractObjectCalculation {
    private static final long serialVersionUID = 4576183558391811345L;
    private long[][] selection = null;

    public Selection(Matrix m, String selectionString) {
        this(m, StringUtil.parseSelection(selectionString, m.getSize()));
    }

    public Selection(Matrix m, Collection<? extends Number> ... selection) {
        super(m);
        this.selection = new long[selection.length][];
        if (selection[0] != null) {
            this.selection[0] = MathUtil.collectionToLong(selection[0]);
        }
        if (selection[1] != null) {
            this.selection[1] = MathUtil.collectionToLong(selection[1]);
        }
        this.createAnnotation();
    }

    public Selection(Matrix m, long[] ... selection) {
        super(m);
        this.selection = selection;
        this.createAnnotation();
    }

    private void createAnnotation() {
        if (this.getSource().getDimensionCount() != 2) {
            throw new MatrixException("only supported for 2d matrices");
        }
        Annotation a = this.getSource().getAnnotation();
        if (a != null) {
            DefaultAnnotation anew = new DefaultAnnotation(this.getSize());
            anew.setMatrixAnnotation(a.getMatrixAnnotation());
            if (this.selection[0] == null) {
                long rowCount = this.getSource().getRowCount();
                int r = 0;
                while ((long)r < rowCount) {
                    anew.setAxisAnnotation(1, a.getAxisAnnotation(1, r, 0L), r, 0L);
                    ++r;
                }
            } else {
                int r = 0;
                while (r < this.selection[0].length) {
                    anew.setAxisAnnotation(1, a.getAxisAnnotation(1, this.selection[0][r], 0L), r, 0L);
                    ++r;
                }
            }
            if (this.selection[1] == null) {
                long colCount = this.getSource().getColumnCount();
                int c = 0;
                while ((long)c < colCount) {
                    anew.setAxisAnnotation(0, a.getAxisAnnotation(0, 0L, c), 0L, c);
                    ++c;
                }
            } else {
                int c = 0;
                while (c < this.selection[1].length) {
                    anew.setAxisAnnotation(0, a.getAxisAnnotation(0, 0L, this.selection[1][c]), 0L, c);
                    ++c;
                }
            }
            this.setAnnotation(anew);
        }
    }

    @Override
    public Object getObject(long ... coordinates) throws MatrixException {
        if (this.selection[0] != null && this.selection[1] != null) {
            return this.getSource().getAsObject(this.selection[0][(int)coordinates[0]], this.selection[1][(int)coordinates[1]]);
        }
        if (this.selection[0] == null) {
            return this.getSource().getAsObject(coordinates[0], this.selection[1][(int)coordinates[1]]);
        }
        return this.getSource().getAsObject(this.selection[0][(int)coordinates[0]], coordinates[1]);
    }

    @Override
    public long[] getSize() {
        if (this.selection[0] != null && this.selection[1] != null) {
            return new long[]{this.selection[0].length, this.selection[1].length};
        }
        if (this.selection[0] == null) {
            return new long[]{this.getSource().getRowCount(), this.selection[1].length};
        }
        return new long[]{this.selection[0].length, this.getSource().getColumnCount()};
    }

    @Override
    public void setObject(Object value, long ... coordinates) throws MatrixException {
        if (this.selection[0] != null && this.selection[1] != null) {
            this.getSource().setAsObject(value, this.selection[0][(int)coordinates[0]], this.selection[1][(int)coordinates[1]]);
        } else if (this.selection[0] == null) {
            this.getSource().setAsObject(value, coordinates[0], this.selection[1][(int)coordinates[1]]);
        } else {
            this.getSource().setAsObject(value, this.selection[0][(int)coordinates[0]], coordinates[1]);
        }
    }
}

