/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.stub;

import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.genericmatrix.stub.AbstractGenericMatrix;
import org.ujmp.core.intmatrix.IntMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntMatrix
extends AbstractGenericMatrix<Integer>
implements IntMatrix {
    private static final long serialVersionUID = -5153569448031492210L;

    @Override
    public final Integer getObject(long ... coordinates) throws MatrixException {
        return this.getInt(coordinates);
    }

    @Override
    public final void setObject(Integer o, long ... coordinates) throws MatrixException {
        this.setInt(o, coordinates);
    }

    @Override
    public final int getAsInt(long ... coordinates) throws MatrixException {
        return this.getInt(coordinates);
    }

    @Override
    public final void setAsInt(int value, long ... coordinates) throws MatrixException {
        this.setInt(value, coordinates);
    }

    @Override
    public final double getAsDouble(long ... coordinates) throws MatrixException {
        return this.getInt(coordinates);
    }

    @Override
    public final void setAsDouble(double value, long ... coordinates) throws MatrixException {
        VerifyUtil.assertTrue(!MathUtil.isNaNOrInfinite(value), "Nan, Inf and -Inf not allowed in this matrix");
        this.setInt((int)value, coordinates);
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.INT;
    }
}

