/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.intmatrix.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.AbstractCalculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.intmatrix.IntMatrix;
import org.ujmp.core.intmatrix.calculation.IntCalculation;
import org.ujmp.core.intmatrix.impl.IntCalculationMatrix;

public abstract class AbstractIntCalculation
extends AbstractCalculation
implements IntCalculation {
    private static final long serialVersionUID = 960721543868612950L;

    public AbstractIntCalculation(Matrix ... sources) {
        super(sources);
    }

    public AbstractIntCalculation(int dimension, Matrix ... sources) {
        super(dimension, sources);
    }

    public final IntMatrix calcLink() throws MatrixException {
        return new IntCalculationMatrix(this);
    }

    public final IntMatrix calcNew() throws MatrixException {
        IntMatrix result = (IntMatrix)MatrixFactory.zeros(ValueType.INT, this.getSize());
        for (long[] c : result.allCoordinates()) {
            result.setAsInt(this.getInt(c), c);
        }
        if (this.getAnnotation() != null) {
            result.setAnnotation(this.getAnnotation().clone());
        }
        return result;
    }

    public final Matrix calcOrig() throws MatrixException {
        if (!Coordinates.equals(this.getSource().getSize(), this.getSize())) {
            throw new MatrixException("Cannot change Matrix size. Use calc(Ret.NEW) or calc(Ret.LINK) instead.");
        }
        for (long[] c : this.getSource().allCoordinates()) {
            this.getSource().setAsInt(this.getInt(c), c);
        }
        this.getSource().notifyGUIObject();
        return this.getSource();
    }

    public void setInt(int value, long ... coordinates) throws MatrixException {
    }

    public final ValueType getValueType() {
        return ValueType.INT;
    }
}

