/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.genericmatrix.stub;

import org.ujmp.core.genericmatrix.GenericMatrix;
import org.ujmp.core.matrix.AbstractMatrix;
import org.ujmp.core.matrix.factory.MatrixFactoryRoot;
import org.ujmp.core.objectmatrix.factory.DefaultDenseObjectMatrix2DFactory;
import org.ujmp.core.objectmatrix.factory.ObjectMatrix2DFactory;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenericMatrix<A>
extends AbstractMatrix
implements GenericMatrix<A> {
    private static final long serialVersionUID = -7498575238134186845L;
    public static ObjectMatrix2DFactory factory = new DefaultDenseObjectMatrix2DFactory();

    @Override
    public final Object getAsObject(long ... coordinates) {
        return this.getObject(coordinates);
    }

    @Override
    public final void setAsObject(Object o, long ... coordinates) {
        switch (this.getValueType()) {
            case BOOLEAN: {
                this.setAsBoolean(MathUtil.getBoolean(o), coordinates);
                break;
            }
            case BIGINTEGER: {
                this.setAsBigInteger(MathUtil.getBigInteger(o), coordinates);
                break;
            }
            case BIGDECIMAL: {
                this.setAsBigDecimal(MathUtil.getBigDecimal(o), coordinates);
                break;
            }
            case BYTE: {
                this.setAsByte(MathUtil.getByte(o), coordinates);
                break;
            }
            case CHAR: {
                this.setAsChar(MathUtil.getChar(o), coordinates);
                break;
            }
            case DATE: {
                this.setAsDate(MathUtil.getDate(o), coordinates);
                break;
            }
            case DOUBLE: {
                this.setAsDouble(MathUtil.getDouble(o), coordinates);
                break;
            }
            case FLOAT: {
                this.setAsFloat(MathUtil.getFloat(o), coordinates);
                break;
            }
            case INT: {
                this.setAsInt(MathUtil.getInt(o), coordinates);
                break;
            }
            case LONG: {
                this.setAsLong(MathUtil.getLong(o), coordinates);
                break;
            }
            case OBJECT: {
                this.setObject(o, coordinates);
                break;
            }
            case SHORT: {
                this.setAsShort(MathUtil.getShort(o), coordinates);
                break;
            }
            case STRING: {
                this.setAsString(StringUtil.convert(o), coordinates);
            }
        }
    }

    @Override
    public MatrixFactoryRoot getFactory() {
        return factory;
    }
}

