/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.stub;

import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.DivideScalar;
import org.ujmp.core.calculation.MinusMatrix;
import org.ujmp.core.calculation.MinusScalar;
import org.ujmp.core.calculation.Mtimes;
import org.ujmp.core.calculation.PlusMatrix;
import org.ujmp.core.calculation.PlusScalar;
import org.ujmp.core.calculation.TimesMatrix;
import org.ujmp.core.calculation.TimesScalar;
import org.ujmp.core.calculation.Transpose;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.factory.DefaultDenseDoubleMatrix2DFactory;
import org.ujmp.core.doublematrix.factory.DenseDoubleMatrix2DFactory;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.CoordinateIterator2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix
implements DenseDoubleMatrix2D {
    public static DenseDoubleMatrix2DFactory factory = new DefaultDenseDoubleMatrix2DFactory();
    private static final long serialVersionUID = 4518790844453035022L;

    @Override
    public final Iterable<long[]> allCoordinates() {
        return new CoordinateIterator2D(this.getSize());
    }

    @Override
    public final double getDouble(long ... coordinates) {
        return this.getDouble(coordinates[0], coordinates[1]);
    }

    @Override
    public final void setDouble(double value, long ... coordinates) {
        this.setDouble(value, coordinates[0], coordinates[1]);
    }

    @Override
    public final Double getObject(long row, long column) throws MatrixException {
        return this.getDouble(row, column);
    }

    @Override
    public final void setObject(Double o, long row, long column) throws MatrixException {
        this.setDouble((double)o, row, column);
    }

    @Override
    public final Double getObject(int row, int column) throws MatrixException {
        return this.getDouble(row, column);
    }

    @Override
    public final void setObject(Double o, int row, int column) throws MatrixException {
        this.setDouble((double)o, row, column);
    }

    public double getAsDouble(long row, long column) {
        return this.getDouble(row, column);
    }

    public double getAsDouble(int row, int column) {
        return this.getDouble(row, column);
    }

    public void setAsDouble(double value, int row, int column) {
        this.setDouble(value, row, column);
    }

    public void setAsDouble(double value, long row, long column) {
        this.setDouble(value, row, column);
    }

    @Override
    public Matrix mtimes(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D result = factory.zeros(this.getRowCount(), m2.getColumnCount());
            Mtimes.DENSEDOUBLEMATRIX2D.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.mtimes(m2);
    }

    @Override
    public Matrix times(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D result = factory.zeros(this.getRowCount(), this.getColumnCount());
            TimesMatrix.DENSEDOUBLEMATRIX2D.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.times(m2);
    }

    @Override
    public Matrix divide(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D result = factory.zeros(this.getRowCount(), this.getColumnCount());
            DenseDoubleMatrix2D.divideMatrix.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.divide(m2);
    }

    @Override
    public Matrix plus(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D result = this.getFactory().zeros(this.getRowCount(), this.getColumnCount());
            PlusMatrix.DENSEDOUBLEMATRIX2D.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.plus(m2);
    }

    @Override
    public Matrix minus(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D result = this.getFactory().zeros(this.getRowCount(), this.getColumnCount());
            MinusMatrix.DENSEDOUBLEMATRIX2D.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.minus(m2);
    }

    @Override
    public Matrix minus(double v) {
        DenseDoubleMatrix2D result = this.getFactory().zeros(this.getRowCount(), this.getColumnCount());
        MinusScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)this, v, result);
        return result;
    }

    @Override
    public Matrix plus(double v) {
        DenseDoubleMatrix2D result = this.getFactory().zeros(this.getRowCount(), this.getColumnCount());
        PlusScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)this, v, result);
        return result;
    }

    @Override
    public Matrix times(double v) {
        DenseDoubleMatrix2D result = this.getFactory().zeros(this.getRowCount(), this.getColumnCount());
        TimesScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)this, v, result);
        return result;
    }

    @Override
    public Matrix divide(double v) {
        DenseDoubleMatrix2D result = this.getFactory().zeros(this.getRowCount(), this.getColumnCount());
        DivideScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)this, v, result);
        return result;
    }

    @Override
    public Matrix transpose() {
        DenseDoubleMatrix2D result = this.getFactory().zeros(this.getColumnCount(), this.getRowCount());
        Transpose.DENSEDOUBLEMATRIX2D.calc(this, result);
        return result;
    }

    @Override
    public DenseDoubleMatrix2DFactory getFactory() {
        return factory;
    }
}

