/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.intmatrix.stub.AbstractDenseIntMatrix2D;

public class ImageMatrix
extends AbstractDenseIntMatrix2D {
    private static final long serialVersionUID = -1354524587823816194L;
    private BufferedImage bufferedImage = null;

    public ImageMatrix(String filename, Object ... parameters) throws IOException {
        this(new File(filename), new Object[0]);
    }

    public ImageMatrix(BufferedImage image) throws IOException {
        this.bufferedImage = image;
    }

    public ImageMatrix(File file, Object ... parameters) throws IOException {
        this(ImageIO.read(file));
    }

    public ImageMatrix(InputStream stream, Object ... parameters) throws IOException {
        this(ImageIO.read(stream));
    }

    public int getInt(long row, long column) {
        return this.getInt((int)row, (int)column);
    }

    public void setInt(int value, long row, long column) {
        this.setInt(value, (int)row, (int)column);
    }

    public int getInt(int row, int column) throws MatrixException {
        return this.bufferedImage.getRGB(column, row);
    }

    public void setInt(int value, int row, int column) throws MatrixException {
        this.bufferedImage.setRGB(column, row, value);
    }

    public long[] getSize() {
        return new long[]{this.bufferedImage.getHeight(), this.bufferedImage.getWidth()};
    }
}

