/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.stub.AbstractSparseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.objectmatrix.impl.DefaultSparseObjectMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSparseRowDoubleMatrix2D
extends AbstractSparseDoubleMatrix2D
implements Wrapper<Map<Long, Matrix>> {
    private static final long serialVersionUID = -5291604525500706427L;
    private long[] size = new long[]{1L, 1L};
    private Map<Long, Matrix> rows = new HashMap<Long, Matrix>();

    public DefaultSparseRowDoubleMatrix2D(long ... size) {
        this.setSize(size);
    }

    public DefaultSparseRowDoubleMatrix2D(Matrix m) {
        this.setSize(m.getSize());
        for (long[] c : m.availableCoordinates()) {
            this.setDouble(m.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long row, long column) throws MatrixException {
        Matrix m = this.rows.get(row);
        return m == null ? null : Double.valueOf(m.getAsDouble(0L, column));
    }

    @Override
    public double getDouble(int row, int column) throws MatrixException {
        Matrix m = this.rows.get(row);
        return m == null ? null : Double.valueOf(m.getAsDouble(0L, column));
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        ArrayList<long[]> coordinates = new ArrayList<long[]>();
        for (Long r : this.rows.keySet()) {
            Matrix m = this.rows.get(r);
            for (long[] c : m.availableCoordinates()) {
                long[] lArray = new long[2];
                lArray[0] = r;
                coordinates.add(Coordinates.plus(c, lArray));
            }
        }
        return coordinates;
    }

    @Override
    public boolean contains(long ... coordinates) {
        if (Coordinates.isSmallerThan(coordinates, this.size)) {
            return this.getObject(coordinates) != null;
        }
        return false;
    }

    @Override
    public void setDouble(double o, long row, long column) throws MatrixException {
        Matrix m = this.rows.get(row);
        if (m == null) {
            m = new DefaultSparseObjectMatrix(1L, this.getColumnCount());
            this.rows.put(row, m);
        }
        m.setAsDouble(o, 0L, column);
    }

    @Override
    public void setDouble(double o, int row, int column) throws MatrixException {
        this.setDouble(o, (long)row, (long)column);
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public void setSize(long ... size) {
        if (this.size[1] != size[1]) {
            for (Matrix m : this.rows.values()) {
                m.setSize(1L, size[1]);
            }
        }
        this.size = size;
    }

    public Matrix getRow(long row) {
        return this.rows.get(row);
    }

    @Override
    public Matrix selectRows(Calculation.Ret returnType, long ... rows) throws MatrixException {
        if (returnType == Calculation.Ret.LINK && rows.length == 1) {
            return this.getRow(rows[0]);
        }
        return super.selectRows(returnType, rows);
    }

    @Override
    public Map<Long, Matrix> getWrappedObject() {
        return this.rows;
    }

    @Override
    public void setWrappedObject(Map<Long, Matrix> object) {
        this.rows = object;
    }
}

