/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.calculation.TransposeCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PFor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransposeDenseDoubleMatrix2D
implements TransposeCalculation<DenseDoubleMatrix2D, DenseDoubleMatrix2D> {
    TransposeDenseDoubleMatrix2D() {
    }

    @Override
    public final void calc(DenseDoubleMatrix2D source, DenseDoubleMatrix2D target) {
        if (source instanceof HasColumnMajorDoubleArray1D && target instanceof HasColumnMajorDoubleArray1D) {
            this.calc((int)source.getRowCount(), (int)source.getColumnCount(), ((HasColumnMajorDoubleArray1D)((Object)source)).getColumnMajorDoubleArray1D(), ((HasColumnMajorDoubleArray1D)((Object)target)).getColumnMajorDoubleArray1D());
        } else if (source instanceof HasRowMajorDoubleArray2D && target instanceof HasRowMajorDoubleArray2D) {
            this.calc(((HasRowMajorDoubleArray2D)((Object)source)).getRowMajorDoubleArray2D(), ((HasRowMajorDoubleArray2D)((Object)target)).getRowMajorDoubleArray2D());
        } else {
            VerifyUtil.assert2D(source);
            VerifyUtil.assert2D(target);
            VerifyUtil.assertEquals(source.getRowCount(), target.getColumnCount(), "matrices have wrong size");
            VerifyUtil.assertEquals(source.getColumnCount(), target.getRowCount(), "matrices have wrong size");
            int r = (int)source.getRowCount();
            while (--r != -1) {
                int c = (int)source.getColumnCount();
                while (--c != -1) {
                    target.setDouble(source.getDouble(r, c), c, r);
                }
            }
        }
    }

    @Override
    private final void calc(final double[][] source, final double[][] target) {
        VerifyUtil.assertNotNull(source, "source cannot be null");
        VerifyUtil.assertNotNull(target, "target cannot be null");
        VerifyUtil.assertNotNull(source[0], "source must be 2d");
        VerifyUtil.assertNotNull(target[0], "target must be 2d");
        VerifyUtil.assertEquals(source.length, target.length, "matrices have wrong size");
        VerifyUtil.assertEquals(source[0].length, target[0].length, "matrices have wrong size");
        final int retcols = source.length;
        int retrows = source[0].length;
        if (retcols * retrows > 10000) {
            new PFor(0, retrows - 1, new Object[0]){

                public void step(int i) {
                    int c = 0;
                    while (c < retcols) {
                        target[i][c] = source[c][i];
                        ++c;
                    }
                }
            };
        } else {
            int r = 0;
            while (r < retrows) {
                int c = 0;
                while (c < retcols) {
                    target[r][c] = source[c][r];
                    ++c;
                }
                ++r;
            }
        }
    }

    private final void calc(final int rows, final int cols, final double[] source, final double[] target) {
        VerifyUtil.assertNotNull(source, "source cannot be null");
        VerifyUtil.assertNotNull(target, "target cannot be null");
        VerifyUtil.assertEquals(source.length, target.length, "matrices have different sizes");
        if (source.length > 10000) {
            new PFor(0, rows - 1, new Object[0]){

                public void step(int i) {
                    int r = 0;
                    while (r < cols) {
                        target[i * cols + r] = source[r * rows + i];
                        ++r;
                    }
                }
            };
        } else {
            int c = 0;
            while (c < rows) {
                int r = 0;
                while (r < cols) {
                    target[c * cols + r] = source[r * rows + c];
                    ++r;
                }
                ++c;
            }
        }
    }
}

