/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.TimesScalarCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;
import org.ujmp.core.util.concurrent.PForEquidistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimesScalarDenseDoubleMatrix2D
implements TimesScalarCalculation<DenseDoubleMatrix2D, DenseDoubleMatrix2D> {
    TimesScalarDenseDoubleMatrix2D() {
    }

    @Override
    public final void calc(DenseDoubleMatrix2D source, BigDecimal factor, DenseDoubleMatrix2D target) {
        this.calc(source, factor.doubleValue(), target);
    }

    @Override
    public final void calc(DenseDoubleMatrix2D source, double factor, DenseDoubleMatrix2D target) {
        if (source instanceof HasColumnMajorDoubleArray1D && target instanceof HasColumnMajorDoubleArray1D) {
            this.calc(((HasColumnMajorDoubleArray1D)((Object)source)).getColumnMajorDoubleArray1D(), factor, ((HasColumnMajorDoubleArray1D)((Object)target)).getColumnMajorDoubleArray1D());
        } else if (source instanceof HasRowMajorDoubleArray2D && target instanceof HasRowMajorDoubleArray2D) {
            this.calc(((HasRowMajorDoubleArray2D)((Object)source)).getRowMajorDoubleArray2D(), factor, ((HasRowMajorDoubleArray2D)((Object)target)).getRowMajorDoubleArray2D());
        } else {
            VerifyUtil.assertSameSize((Matrix)source, (Matrix)target);
            int r = (int)source.getRowCount();
            while (--r != -1) {
                int c = (int)source.getColumnCount();
                while (--c != -1) {
                    target.setDouble(factor * source.getDouble(r, c), r, c);
                }
            }
        }
    }

    @Override
    private final void calc(final double[][] source, final double factor, final double[][] target) {
        VerifyUtil.assertSameSize(source, target);
        int rows = source.length;
        final int cols = source[0].length;
        if (UJMPSettings.getNumberOfThreads() > 1 && rows >= 100 && cols >= 100) {
            new PForEquidistant(0, rows - 1, new Object[0]){

                public void step(int i) {
                    double[] tsource = source[i];
                    double[] ttarget = target[i];
                    int c = 0;
                    while (c < cols) {
                        ttarget[c] = tsource[c] * factor;
                        ++c;
                    }
                }
            };
        } else {
            double[] tsource = null;
            double[] ttarget = null;
            int r = 0;
            while (r < rows) {
                tsource = source[r];
                ttarget = target[r];
                int c = 0;
                while (c < cols) {
                    ttarget[c] = tsource[c] * factor;
                    ++c;
                }
                ++r;
            }
        }
    }

    @Override
    private final void calc(double[] source, double factor, double[] target) {
        VerifyUtil.assertSameSize(source, target);
        int length = source.length;
        int i = 0;
        while (i < length) {
            target[i] = source[i] * factor;
            ++i;
        }
    }
}

