/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.PlusScalar;
import org.ujmp.core.calculation.PlusScalarCalculation;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlusScalarMatrix
implements PlusScalarCalculation<Matrix, Matrix> {
    PlusScalarMatrix() {
    }

    @Override
    public final void calc(Matrix source, BigDecimal value, Matrix target) {
        if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            PlusScalar.DENSEMATRIX.calc((DenseMatrix)source, value, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            PlusScalar.SPARSEMATRIX.calc((SparseMatrix)source, value, (SparseMatrix)target);
        } else {
            VerifyUtil.assertSameSize(source, target);
            for (long[] c : source.allCoordinates()) {
                BigDecimal svalue = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.plus(svalue, value);
                target.setAsBigDecimal(result, c);
            }
        }
    }

    @Override
    public final void calc(Matrix source, double value, Matrix target) {
        if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            PlusScalar.DENSEMATRIX.calc((DenseMatrix)source, value, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            PlusScalar.SPARSEMATRIX.calc((SparseMatrix)source, value, (SparseMatrix)target);
        } else {
            this.calc(source, new BigDecimal(value, MathUtil.getDefaultMathContext()), target);
        }
    }
}

