/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.benchmark;

import org.ujmp.core.Matrix;
import org.ujmp.core.benchmark.AbstractBenchmarkTask;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.BenchmarkResult;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.util.SerializationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvSPDBenchmarkTask
extends AbstractBenchmarkTask {
    public InvSPDBenchmarkTask(long benchmarkSeed, Class<? extends DoubleMatrix2D> matrixClass, BenchmarkConfig config) {
        super(benchmarkSeed, matrixClass, config.getInvSizes(), config);
    }

    @Override
    public BenchmarkResult task(Class<? extends Matrix> matrixClass, long benchmarkSeed, int run, long[] size) {
        try {
            DoubleMatrix2D m = BenchmarkUtil.createMatrix(matrixClass, size);
            if (!m.getClass().getName().startsWith("org.ujmp.core") && m.getClass().getDeclaredMethod("invSPD", new Class[0]) == null) {
                System.out.print("-");
                System.out.flush();
                return BenchmarkResult.NOTAVAILABLE;
            }
            BenchmarkUtil.rand(benchmarkSeed, run, 0, m);
            BenchmarkUtil.purgeMemory(this.getConfig());
            long m0 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            long t0 = System.nanoTime();
            Matrix r = m.inv();
            long t1 = System.nanoTime();
            long m1 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (r == null) {
                System.out.print("e");
                System.out.flush();
                return BenchmarkResult.ERROR;
            }
            Matrix result = m.mtimes(r);
            double diff = BenchmarkUtil.difference(result, DenseMatrix.factory.eye(m.getSize()));
            result = null;
            long mem = m1 - m0 - SerializationUtil.sizeOf(r);
            mem = mem > 0L ? mem : 0L;
            return new BenchmarkResult((double)(t1 - t0) / 1000000.0, diff, mem);
        }
        catch (Throwable e) {
            System.out.print("e");
            System.out.flush();
            return BenchmarkResult.ERROR;
        }
    }

    @Override
    public String getTaskName() {
        return "invSPD";
    }
}

