/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.util;

import com.seaglasslookandfeel.util.PlatformUtils;
import java.awt.Component;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WindowUtils {
    public static void makeWindowNonOpaque(Window window) {
        if (!PlatformUtils.isMac()) {
            WindowUtils.quietlyTryToMakeWindowNonOqaque(window);
        } else {
            window.setBackground(UIManager.getColor("seaGlassTransparent"));
        }
    }

    public static void setWindowShape(Window window, Shape s) {
        if (PlatformUtils.isJava6()) {
            WindowUtils.setWindowShapeJava6(window, s);
        } else {
            WindowUtils.setWindowShapeJava7(window, s);
        }
    }

    private static void setWindowShapeJava7(Window window, Shape s) {
        try {
            Class<?> clazz = window.getClass();
            Method method = clazz.getMethod("setShape", Shape.class);
            method.invoke((Object)window, s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setWindowShapeJava6(Window window, Shape s) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowShape", Window.class, Shape.class);
            method.invoke(clazz, window, s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void quietlyTryToMakeWindowNonOqaque(Window window) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            method.invoke(clazz, window, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static WindowFocusListener createAndInstallRepaintWindowFocusListener(Window window) {
        WindowFocusListener windowFocusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                e.getWindow().repaint();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                e.getWindow().repaint();
            }
        };
        window.addWindowFocusListener(windowFocusListener);
        return windowFocusListener;
    }

    public static boolean isParentWindowFocused(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        return window != null && window.isFocused();
    }

    public static void installWeakWindowFocusListener(JComponent component, WindowFocusListener focusListener) {
        WindowListener weakFocusListener = WindowUtils.createWeakWindowFocusListener(focusListener);
        AncestorListener ancestorListener = WindowUtils.createAncestorListener(component, weakFocusListener);
        component.addAncestorListener(ancestorListener);
    }

    private static WindowListener createWeakWindowFocusListener(WindowFocusListener windowFocusListener) {
        final WeakReference<WindowFocusListener> weakReference = new WeakReference<WindowFocusListener>(windowFocusListener);
        return new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (weakReference.get() != null) {
                    ((WindowFocusListener)weakReference.get()).windowGainedFocus(e);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (weakReference.get() != null) {
                    ((WindowFocusListener)weakReference.get()).windowLostFocus(e);
                }
            }
        };
    }

    public static void installJComponentRepainterOnWindowFocusChanged(JComponent component) {
        WindowListener windowListener = WindowUtils.createWeakWindowFocusListener(WindowUtils.createRepaintWindowListener(component));
        AncestorListener ancestorListener = WindowUtils.createAncestorListener(component, windowListener);
        component.addAncestorListener(ancestorListener);
    }

    private static AncestorListener createAncestorListener(JComponent component, final WindowListener windowListener) {
        final WeakReference<JComponent> weakReference = new WeakReference<JComponent>(component);
        return new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                Window window;
                Window window2 = window = weakReference.get() == null ? null : SwingUtilities.getWindowAncestor((Component)weakReference.get());
                if (window != null) {
                    window.removeWindowListener(windowListener);
                    window.addWindowListener(windowListener);
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                Window window;
                Window window2 = window = weakReference.get() == null ? null : SwingUtilities.getWindowAncestor((Component)weakReference.get());
                if (window != null) {
                    window.removeWindowListener(windowListener);
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        };
    }

    private static WindowFocusListener createRepaintWindowListener(final JComponent component) {
        return new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                component.repaint();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                component.repaint();
            }
        };
    }
}

