/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.util;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.SwingUtilities;

public class WindowDragger {
    private Window fWindow;
    private Component fComponent;
    private MouseListener mouseListener;
    private MouseMotionAdapter mouseMotionListener;
    private int dX;
    private int dY;

    public WindowDragger(Window window, Component component) {
        this.fWindow = window;
        this.fComponent = component;
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.fComponent.addMouseListener(this.mouseListener);
        this.fComponent.addMouseMotionListener(this.mouseMotionListener);
    }

    public void uninstallDragger() {
        this.fComponent.removeMouseListener(this.mouseListener);
        this.fComponent.removeMouseMotionListener(this.mouseMotionListener);
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point clickPoint = new Point(e.getPoint());
                SwingUtilities.convertPointToScreen(clickPoint, WindowDragger.this.fComponent);
                WindowDragger.this.dX = clickPoint.x - WindowDragger.this.fWindow.getX();
                WindowDragger.this.dY = clickPoint.y - WindowDragger.this.fWindow.getY();
            }
        };
    }

    private MouseMotionAdapter createMouseMotionListener() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point dragPoint = new Point(e.getPoint());
                SwingUtilities.convertPointToScreen(dragPoint, WindowDragger.this.fComponent);
                WindowDragger.this.fWindow.setLocation(dragPoint.x - WindowDragger.this.dX, dragPoint.y - WindowDragger.this.dY);
            }
        };
    }
}

