/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.util;

import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.component.SeaGlassIcon;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class SeaGlassGraphicsUtils
extends SynthGraphicsUtils {
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private Insets paintInsets = new Insets(0, 0, 0, 0);

    @Override
    public void paintText(SynthContext ss, Graphics g, String text, int x, int y, int mnemonicIndex) {
        if (text != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            JComponent c = ss.getComponent();
            FontMetrics fm = SwingUtilities2.getFontMetrics(c, g2d);
            SwingUtilities2.drawString(c, (Graphics)g2d, text, x, y += fm.getAscent());
            if (mnemonicIndex >= 0 && mnemonicIndex < text.length()) {
                int underlineX = x + SwingUtilities2.stringWidth(c, fm, text.substring(0, mnemonicIndex));
                int underlineY = y;
                int underlineWidth = fm.charWidth(text.charAt(mnemonicIndex));
                int underlineHeight = 1;
                g2d.fillRect(underlineX, underlineY + fm.getDescent() - 1, underlineWidth, underlineHeight);
            }
        }
    }

    public static Color disable(Color color) {
        int alpha = color.getAlpha();
        return new Color(color.getRGB() & 0xFFFFFF | (alpha /= 2) << 24, true);
    }

    @Override
    public void paintText(SynthContext ss, Graphics g, String text, Icon icon, int hAlign, int vAlign, int hTextPosition, int vTextPosition, int iconTextGap, int mnemonicIndex, int textOffset) {
        if (icon == null && text == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        JComponent c = ss.getComponent();
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g2d);
        Insets insets = SeaGlassLookAndFeel.getPaintingInsets(ss, this.paintInsets);
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = c.getWidth() - (insets.left + insets.right);
        this.paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        String clippedText = this.layoutText(ss, fm, text, icon, hAlign, vAlign, hTextPosition, vTextPosition, this.paintViewR, this.paintIconR, this.paintTextR, iconTextGap);
        if (icon != null) {
            Color color = g2d.getColor();
            this.paintIconR.x += textOffset;
            this.paintIconR.y += textOffset;
            SeaGlassIcon.paintIcon((Icon)icon, (SynthContext)ss, (Graphics)g2d, (int)this.paintIconR.x, (int)this.paintIconR.y, (int)this.paintIconR.width, (int)this.paintIconR.height);
            g2d.setColor(color);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2d, this.paintTextR);
            } else {
                this.paintTextR.x += textOffset;
                this.paintTextR.y += textOffset;
                this.paintText(ss, g2d, clippedText, this.paintTextR, mnemonicIndex);
            }
        }
    }

    public void drawEmphasizedText(Graphics g, Color foreground, Color emphasis, String s, int x, int y) {
        this.drawEmphasizedText(g, foreground, emphasis, s, -1, x, y);
    }

    public void drawEmphasizedText(Graphics g, Color foreground, Color emphasis, String s, int underlinedIndex, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(emphasis);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, s, underlinedIndex, x, y + 1);
        g2d.setColor(foreground);
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, s, underlinedIndex, x, y);
    }
}

