/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.util;

public class PlatformUtils {
    private static final String SEA_GLASS_OVERRIDE_OS_NAME = "SeaGlass.Override.os.name";

    private PlatformUtils() {
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static boolean isMac() {
        if (System.getProperty(SEA_GLASS_OVERRIDE_OS_NAME) != null) {
            return System.getProperty(SEA_GLASS_OVERRIDE_OS_NAME).startsWith("Mac OS");
        }
        return System.getProperty("os.name").startsWith("Mac OS");
    }

    public static boolean isJava6OnMac() {
        return PlatformUtils.isMac() && PlatformUtils.isJava6();
    }

    public static boolean is64BitJavaOnMac() {
        return PlatformUtils.isMac() && System.getProperty("os.arch").equals("x86_64");
    }

    public static boolean isLeopard() {
        return PlatformUtils.isMac() && PlatformUtils.getOsVersion().startsWith("10.5");
    }

    public static boolean isSnowLeopard() {
        return PlatformUtils.isMac() && PlatformUtils.getOsVersion().startsWith("10.6");
    }

    public static boolean isJava6() {
        return PlatformUtils.getJavaVersion().startsWith("1.6");
    }
}

