/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public enum ControlOrientation {
    HORIZONTAL{

        @Override
        public int getThickness(Dimension size) {
            return size.height;
        }

        @Override
        public int getThickness(Rectangle bounds) {
            return bounds.height;
        }

        @Override
        public int getLength(Dimension size) {
            return size.width;
        }

        @Override
        public int getLength(Rectangle bounds) {
            return bounds.width;
        }

        @Override
        public int getPosition(Point point) {
            return point.x;
        }

        @Override
        public int getPosition(Rectangle bounds) {
            return bounds.x;
        }

        @Override
        public int getPosition(int x, int y) {
            return x;
        }

        @Override
        public int getOrthogonalOffset(Point point) {
            return point.y;
        }

        @Override
        public int getOrthogonalOffset(Rectangle bounds) {
            return bounds.y;
        }

        @Override
        public int getOrthogonalOffset(int x, int y) {
            return y;
        }

        @Override
        public Rectangle updateBoundsPosition(Rectangle bounds, int newPosition) {
            bounds.setLocation(newPosition, bounds.y);
            return bounds;
        }

        @Override
        public Rectangle updateBoundsOrthogonalOffset(Rectangle bounds, int newOrthogonalOffset) {
            bounds.setLocation(bounds.x, newOrthogonalOffset);
            return bounds;
        }

        @Override
        public Rectangle updateBoundsLength(Rectangle bounds, int newLength) {
            bounds.setSize(newLength, bounds.height);
            return bounds;
        }

        @Override
        public Rectangle updateBoundsThickness(Rectangle bounds, int newThickness) {
            bounds.setSize(bounds.width, newThickness);
            return bounds;
        }

        @Override
        public Rectangle createBounds(Component container, int position, int length) {
            return new Rectangle(position, 0, length, container.getHeight());
        }

        @Override
        public Rectangle createCenteredBounds(Component container, int position, int length, int thickness) {
            int y = container.getHeight() / 2 - thickness / 2;
            return new Rectangle(position, y, length, thickness);
        }

        @Override
        public Rectangle createBounds(int position, int orthogonalOffset, int length, int thickness) {
            return new Rectangle(position, orthogonalOffset, length, thickness);
        }
    }
    ,
    VERTICAL{

        @Override
        public int getThickness(Dimension size) {
            return size.width;
        }

        @Override
        public int getThickness(Rectangle bounds) {
            return bounds.width;
        }

        @Override
        public int getLength(Dimension size) {
            return size.height;
        }

        @Override
        public int getLength(Rectangle bounds) {
            return bounds.height;
        }

        @Override
        public int getPosition(Point point) {
            return point.y;
        }

        @Override
        public int getPosition(Rectangle bounds) {
            return bounds.y;
        }

        @Override
        public int getPosition(int x, int y) {
            return y;
        }

        @Override
        public int getOrthogonalOffset(Point point) {
            return point.x;
        }

        @Override
        public int getOrthogonalOffset(Rectangle bounds) {
            return bounds.x;
        }

        @Override
        public int getOrthogonalOffset(int x, int y) {
            return x;
        }

        @Override
        public Rectangle updateBoundsPosition(Rectangle bounds, int newPosition) {
            bounds.setLocation(bounds.x, newPosition);
            return bounds;
        }

        @Override
        public Rectangle updateBoundsOrthogonalOffset(Rectangle bounds, int newOrthogonalOffset) {
            bounds.setLocation(newOrthogonalOffset, bounds.y);
            return bounds;
        }

        @Override
        public Rectangle updateBoundsLength(Rectangle bounds, int newLength) {
            bounds.setSize(bounds.width, newLength);
            return bounds;
        }

        @Override
        public Rectangle updateBoundsThickness(Rectangle bounds, int newThickness) {
            bounds.setSize(newThickness, bounds.height);
            return bounds;
        }

        @Override
        public Rectangle createBounds(Component container, int position, int length) {
            return new Rectangle(0, position, container.getWidth(), length);
        }

        @Override
        public Rectangle createCenteredBounds(Component container, int position, int length, int thickness) {
            int x = container.getWidth() / 2 - thickness / 2;
            return new Rectangle(x, position, thickness, length);
        }

        @Override
        public Rectangle createBounds(int position, int orthogonalOffset, int length, int thickness) {
            return new Rectangle(orthogonalOffset, position, thickness, length);
        }
    };


    public static ControlOrientation getOrientation(int swingScrollBarOrientation) {
        if (swingScrollBarOrientation != 0 && swingScrollBarOrientation != 1) {
            throw new IllegalArgumentException("The given value is not a valid orientation for ControlOrientation.");
        }
        return swingScrollBarOrientation == 0 ? HORIZONTAL : VERTICAL;
    }

    public abstract int getThickness(Dimension var1);

    public abstract int getThickness(Rectangle var1);

    public abstract int getLength(Dimension var1);

    public abstract int getLength(Rectangle var1);

    public abstract int getPosition(Point var1);

    public abstract int getPosition(Rectangle var1);

    public abstract int getPosition(int var1, int var2);

    public abstract int getOrthogonalOffset(Point var1);

    public abstract int getOrthogonalOffset(Rectangle var1);

    public abstract int getOrthogonalOffset(int var1, int var2);

    public abstract Rectangle updateBoundsPosition(Rectangle var1, int var2);

    public abstract Rectangle updateBoundsOrthogonalOffset(Rectangle var1, int var2);

    public abstract Rectangle updateBoundsLength(Rectangle var1, int var2);

    public abstract Rectangle updateBoundsThickness(Rectangle var1, int var2);

    public abstract Rectangle createBounds(Component var1, int var2, int var3);

    public abstract Rectangle createBounds(int var1, int var2, int var3, int var4);

    public abstract Rectangle createCenteredBounds(Component var1, int var2, int var3, int var4);
}

