/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.painter.ViewportPainter;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ViewportUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SeaGlassViewportUI
extends ViewportUI
implements PropertyChangeListener,
SeaglassUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent c) {
        return new SeaGlassViewportUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installDefaults(c);
        this.installListeners(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners(c);
        this.uninstallDefaults(c);
    }

    protected void installDefaults(JComponent c) {
        this.updateStyle(c);
    }

    private void updateStyle(JComponent c) {
        SynthStyle oldStyle;
        SeaGlassContext context = this.getContext(c, 1);
        SynthStyle newStyle = SynthLookAndFeel.getStyle(context.getComponent(), context.getRegion());
        if (newStyle != (oldStyle = context.getStyle())) {
            if (oldStyle != null) {
                oldStyle.uninstallDefaults(context);
            }
            context.setStyle(newStyle);
            newStyle.installDefaults(context);
        }
        this.style = newStyle;
        context.dispose();
    }

    protected void installListeners(JComponent c) {
        c.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(JComponent c) {
        c.removePropertyChangeListener(this);
    }

    protected void uninstallDefaults(JComponent c) {
        SeaGlassContext context = this.getContext(c, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, this.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintViewportBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
        JComponent c = context.getComponent();
        JViewport viewport = (JViewport)c;
        if (c.isOpaque()) {
            Object ui;
            Component view = viewport.getView();
            Object object = ui = view == null ? null : SeaGlassViewportUI.invokeGetter(view, "getUI", null);
            if (ui instanceof ViewportPainter) {
                ((ViewportPainter)ui).paintViewport(context, g, viewport);
            } else if (viewport.getView() != null) {
                g.setColor(viewport.getView().getBackground());
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
    }

    private static Object invokeGetter(Object obj, String methodName, Object defaultValue) {
        try {
            Method method = obj.getClass().getMethod(methodName, new Class[0]);
            Object result = method.invoke(obj, new Object[0]);
            return result;
        }
        catch (NoSuchMethodException e) {
            return defaultValue;
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (InvocationTargetException e) {
            return defaultValue;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JComponent)e.getSource());
        }
    }
}

