/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.SeaGlassRegion;
import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.SeaGlassSynthPainterImpl;
import com.seaglasslookandfeel.component.SeaGlassBorder;
import com.seaglasslookandfeel.state.SearchFieldHasPopupState;
import com.seaglasslookandfeel.state.State;
import com.seaglasslookandfeel.state.TextFieldIsSearchState;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class SeaGlassTextFieldUI
extends BasicTextFieldUI
implements SeaglassUI,
FocusListener {
    private static final State isSearchField = new TextFieldIsSearchState();
    private static final State hasPopupMenu = new SearchFieldHasPopupState();
    private TextFieldBorder textFieldBorder;
    private MouseAdapter mouseListener;
    private boolean isCancelArmed;
    private SynthStyle style;
    private SynthStyle findStyle;
    private SynthStyle cancelStyle;
    private String placeholderText;
    private Color placeholderColor;
    private ActionListener findAction;
    private JPopupMenu findPopup;
    private ActionListener cancelAction;
    private int searchIconWidth;
    private int popupIconWidth;
    private int cancelIconWidth;
    private int searchLeftInnerMargin;
    private int searchRightInnerMargin;

    public static ComponentUI createUI(JComponent c) {
        return new SeaGlassTextFieldUI();
    }

    private void updateStyle(JTextComponent c) {
        SeaGlassContext context = this.getContext((JComponent)c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        this.updateSearchStyle(c, context, this.getPropertyPrefix());
        if (this.style != oldStyle) {
            SeaGlassTextFieldUI.updateStyle(c, context, this.getPropertyPrefix());
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
        context = this.getContext(c, SeaGlassRegion.SEARCH_FIELD_FIND_BUTTON, 1);
        this.findStyle = SeaGlassLookAndFeel.updateStyle(context, this);
        context.dispose();
        context = this.getContext(c, SeaGlassRegion.SEARCH_FIELD_CANCEL_BUTTON, 1);
        this.cancelStyle = SeaGlassLookAndFeel.updateStyle(context, this);
        context.dispose();
    }

    private void updateSearchStyle(JTextComponent c, SeaGlassContext context, String prefix) {
        Border border;
        this.searchIconWidth = 0;
        Object o = this.style.get(context, prefix + ".searchIconWidth");
        if (o != null && o instanceof Integer) {
            this.searchIconWidth = (Integer)o;
        }
        this.popupIconWidth = 0;
        o = this.style.get(context, prefix + ".popupIconWidth");
        if (o != null && o instanceof Integer) {
            this.popupIconWidth = (Integer)o;
        }
        this.cancelIconWidth = 0;
        o = this.style.get(context, prefix + ".cancelIconWidth");
        if (o != null && o instanceof Integer) {
            this.cancelIconWidth = (Integer)o;
        }
        this.searchLeftInnerMargin = 0;
        o = this.style.get(context, prefix + ".searchLeftInnerMargin");
        if (o != null && o instanceof Integer) {
            this.searchLeftInnerMargin = (Integer)o;
        }
        this.searchRightInnerMargin = 0;
        o = this.style.get(context, prefix + ".searchRightInnerMargin");
        if (o != null && o instanceof Integer) {
            this.searchRightInnerMargin = (Integer)o;
        }
        this.placeholderColor = Color.GRAY;
        o = this.style.get(context, "placeholderTextColor");
        if (o != null && o instanceof Color) {
            this.placeholderColor = (Color)o;
        }
        if ((border = c.getBorder()) == null || border instanceof UIResource && !(border instanceof TextFieldBorder)) {
            c.setBorder(this.createTextFieldBorder(context));
        }
        if (isSearchField.isInState(c)) {
            o = c.getClientProperty("JTextField.Search.PlaceholderText");
            if (o != null && o instanceof String) {
                this.placeholderText = (String)o;
            } else if (this.placeholderText != null) {
                this.placeholderText = null;
            }
            o = c.getClientProperty("JTextField.Search.FindAction");
            if (o != null && o instanceof ActionListener && this.findAction == null) {
                this.findAction = (ActionListener)o;
            }
            if ((o = c.getClientProperty("JTextField.Search.FindPopup")) != null && o instanceof JPopupMenu && this.findPopup == null) {
                this.findPopup = (JPopupMenu)o;
            }
            if ((o = c.getClientProperty("JTextField.Search.CancelAction")) != null && o instanceof ActionListener && this.cancelAction == null) {
                this.cancelAction = (ActionListener)o;
            }
            this.installMouseListeners();
        } else {
            this.placeholderText = null;
            if (this.findAction != null) {
                this.findAction = null;
            }
            if (this.findPopup != null) {
                this.findPopup = null;
            }
            if (this.cancelAction != null) {
                this.cancelAction = null;
            }
            this.uninstallMouseListeners();
        }
    }

    static void updateStyle(JTextComponent c, SeaGlassContext context, String prefix) {
        Object o;
        Caret caret;
        Insets margin;
        Color sfg;
        Object ar;
        Color fg;
        SeaGlassStyle style = (SeaGlassStyle)context.getStyle();
        Color color = c.getCaretColor();
        if (color == null || color instanceof UIResource) {
            c.setCaretColor((Color)style.get(context, prefix + ".caretForeground"));
        }
        if (((fg = c.getForeground()) == null || fg instanceof UIResource) && (fg = style.getColorForState(context, ColorType.TEXT_FOREGROUND)) != null) {
            c.setForeground(fg);
        }
        if ((ar = style.get(context, prefix + ".caretAspectRatio")) instanceof Number) {
            c.putClientProperty("caretAspectRatio", ar);
        }
        context.setComponentState(768);
        Color s = c.getSelectionColor();
        if (s == null || s instanceof UIResource) {
            c.setSelectionColor(style.getColor(context, ColorType.TEXT_BACKGROUND));
        }
        if ((sfg = c.getSelectedTextColor()) == null || sfg instanceof UIResource) {
            c.setSelectedTextColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
        }
        context.setComponentState(8);
        Color dfg = c.getDisabledTextColor();
        if (dfg == null || dfg instanceof UIResource) {
            c.setDisabledTextColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
        }
        if ((margin = c.getMargin()) == null || margin instanceof UIResource) {
            margin = (Insets)style.get(context, prefix + ".margin");
            if (margin == null) {
                margin = SeaGlassLookAndFeel.EMPTY_UIRESOURCE_INSETS;
            }
            c.setMargin(margin);
        }
        if ((caret = c.getCaret()) instanceof UIResource && (o = style.get(context, prefix + ".caretBlinkRate")) != null && o instanceof Integer) {
            Integer rate = (Integer)o;
            caret.setBlinkRate(rate);
        }
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    private SeaGlassContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SeaGlassContext getContext(JComponent c, Region region, int state) {
        SynthStyle style = this.findStyle;
        if (region == SeaGlassRegion.SEARCH_FIELD_CANCEL_BUTTON) {
            style = this.cancelStyle;
        }
        return SeaGlassContext.getContext(SeaGlassContext.class, c, region, style, state);
    }

    private int getComponentState(JComponent c) {
        int state = SeaGlassLookAndFeel.getComponentState(c);
        return state;
    }

    private int getComponentState(JComponent c, Region region) {
        if (region == SeaGlassRegion.SEARCH_FIELD_CANCEL_BUTTON && c.isEnabled()) {
            if (((JTextComponent)c).getText().length() == 0) {
                return 8;
            }
            if (this.isCancelArmed) {
                return 4;
            }
            return 1;
        }
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        this.paintBackground(context, g, c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
        JTextComponent c = this.getComponent();
        super.paint(g, c);
    }

    void paintBackground(SeaGlassContext context, Graphics g, JComponent c) {
        context.getPainter().paintTextFieldBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        if (this.placeholderText != null && ((JTextComponent)c).getText().length() == 0 && !c.hasFocus()) {
            this.paintPlaceholderText(context, g, c);
        }
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintTextFieldBorder(context, g, x, y, w, h);
        JTextComponent c = this.getComponent();
        if (isSearchField.isInState(c)) {
            this.paintSearchButton(g, c, SeaGlassRegion.SEARCH_FIELD_FIND_BUTTON);
            this.paintSearchButton(g, c, SeaGlassRegion.SEARCH_FIELD_CANCEL_BUTTON);
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    protected void paintPlaceholderText(SeaGlassContext context, Graphics g, JComponent c) {
        g.setColor(this.placeholderColor);
        g.setFont(c.getFont());
        Rectangle innerArea = SwingUtilities.calculateInnerArea(c, null);
        Rectangle cancelBounds = this.getCancelButtonBounds();
        context.getStyle().getGraphicsUtils(context).paintText(context, g, this.getPlaceholderText(g, innerArea.width + cancelBounds.width), innerArea.x, innerArea.y, -1);
    }

    private String getPlaceholderText(Graphics g, int availTextWidth) {
        JTextComponent c = this.getComponent();
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)c, g);
        return SwingUtilities2.clipStringIfNecessary(c, fm, this.placeholderText, availTextWidth);
    }

    protected void paintSearchButton(Graphics g, JTextComponent c, Region region) {
        Rectangle bounds = region == SeaGlassRegion.SEARCH_FIELD_FIND_BUTTON ? this.getFindButtonBounds() : this.getCancelButtonBounds();
        SeaGlassContext subcontext = this.getContext((JComponent)c, region);
        SeaGlassLookAndFeel.updateSubregion(subcontext, g, bounds);
        SeaGlassSynthPainterImpl painter = (SeaGlassSynthPainterImpl)subcontext.getPainter();
        painter.paintSearchButtonForeground(subcontext, g, bounds.x, bounds.y, bounds.width, bounds.height);
        subcontext.dispose();
    }

    protected Rectangle getFindButtonBounds() {
        JTextComponent c = this.getComponent();
        int x = c.getHeight() / 2 - 6;
        int y = c.getHeight() / 2 - 6;
        return new Rectangle(x, y, 22, 17);
    }

    protected Rectangle getCancelButtonBounds() {
        JTextComponent c = this.getComponent();
        int x = c.getWidth() - c.getHeight() / 2 - 9;
        int y = c.getHeight() / 2 - 8;
        return new Rectangle(x, y, 17, 17);
    }

    @Override
    protected void propertyChange(PropertyChangeEvent evt) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JTextComponent)evt.getSource());
        }
        super.propertyChange(evt);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.getComponent().repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.getComponent().repaint();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        JTextComponent c = this.getComponent();
        this.updateStyle(c);
        c.addFocusListener(this);
    }

    @Override
    protected void uninstallDefaults() {
        JTextComponent c = this.getComponent();
        SeaGlassContext context = this.getContext((JComponent)c, 1);
        Border border = c.getBorder();
        if (border instanceof TextFieldBorder) {
            c.setBorder(null);
        }
        c.putClientProperty("caretAspectRatio", null);
        c.removeFocusListener(this);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.uninstallMouseListeners();
    }

    private void installMouseListeners() {
        if (this.mouseListener == null) {
            this.mouseListener = this.createMouseListener();
            this.getComponent().addMouseListener(this.mouseListener);
            this.getComponent().addMouseMotionListener(this.mouseListener);
        }
    }

    private void uninstallMouseListeners() {
        if (this.mouseListener != null) {
            this.getComponent().removeMouseListener(this.mouseListener);
            this.getComponent().removeMouseMotionListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    protected MouseAdapter createMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseButtonListener();
        }
        return this.mouseListener;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateStyle((JTextComponent)c);
    }

    protected TextFieldBorder createTextFieldBorder(SeaGlassContext context) {
        if (this.textFieldBorder == null) {
            this.textFieldBorder = new TextFieldBorder(this, context.getStyle().getInsets(context, null));
        }
        return this.textFieldBorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize(JComponent c) {
        Document doc = ((JTextComponent)c).getDocument();
        Insets i = c.getInsets();
        Dimension d = c.getSize();
        View rootView = this.getRootView((JTextComponent)c);
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
        }
        try {
            if (d.width > i.left + i.right && d.height > i.top + i.bottom) {
                rootView.setSize(d.width - i.left - i.right, d.height - i.top - i.bottom);
            } else if (d.width == 0 && d.height == 0) {
                rootView.setSize(2.1474836E9f, 2.1474836E9f);
            }
            d.width = (int)Math.min((long)rootView.getPreferredSpan(0) + (long)i.left + (long)i.right, Integer.MAX_VALUE);
            d.height = (int)Math.min((long)rootView.getPreferredSpan(1) + (long)i.top + (long)i.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        d.width += 2;
        if ((d.height & 1) == 0) {
            --d.height;
        }
        return d;
    }

    private void doFind() {
        if (this.findAction != null) {
            this.fireAction(this.findAction);
        }
        this.doPopup();
    }

    private void doCancel() {
        this.getComponent().setText("");
        if (this.cancelAction != null) {
            this.fireAction(this.cancelAction);
        }
    }

    private void doPopup() {
        if (this.findPopup != null) {
            JTextComponent c = this.getComponent();
            this.findPopup.pack();
            this.findPopup.show(c, 0, c.getHeight() - 1);
            c.requestFocusInWindow();
        }
    }

    protected void fireAction(ActionListener action) {
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        ActionEvent e = new ActionEvent(this.getComponent(), 1001, this.getComponent().getText(), EventQueue.getMostRecentEventTime(), modifiers);
        action.actionPerformed(e);
    }

    protected class MouseButtonListener
    extends MouseAdapter {
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        public MouseButtonListener() {
            SeaGlassTextFieldUI.this.isCancelArmed = false;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SeaGlassTextFieldUI.this.isCancelArmed) {
                SeaGlassTextFieldUI.this.isCancelArmed = false;
                if (this.isOverCancelButton()) {
                    SeaGlassTextFieldUI.this.doCancel();
                }
                SeaGlassTextFieldUI.this.getComponent().repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (SeaGlassTextFieldUI.this.isCancelArmed && !this.isOverCancelButton()) {
                SeaGlassTextFieldUI.this.isCancelArmed = false;
                SeaGlassTextFieldUI.this.getComponent().repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e) || !SeaGlassTextFieldUI.this.getComponent().isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (this.isOverFindButton()) {
                SeaGlassTextFieldUI.this.doFind();
            }
            if (this.isOverCancelButton()) {
                SeaGlassTextFieldUI.this.isCancelArmed = true;
                SeaGlassTextFieldUI.this.getComponent().repaint();
            } else if (SeaGlassTextFieldUI.this.isCancelArmed) {
                SeaGlassTextFieldUI.this.isCancelArmed = false;
                SeaGlassTextFieldUI.this.getComponent().repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JComponent c;
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            Cursor cursorToUse = Cursor.getPredefinedCursor(2);
            if (this.isOverCancelButton() || this.isOverFindButton()) {
                cursorToUse = Cursor.getDefaultCursor();
            }
            if (!cursorToUse.equals((c = (JComponent)e.getSource()).getCursor())) {
                c.setCursor(cursorToUse);
            }
            super.mouseMoved(e);
        }

        private boolean isOverFindButton() {
            return SeaGlassTextFieldUI.this.getFindButtonBounds().contains(this.currentMouseX, this.currentMouseY);
        }

        public boolean isOverCancelButton() {
            return SeaGlassTextFieldUI.this.getCancelButtonBounds().contains(this.currentMouseX, this.currentMouseY);
        }
    }

    protected class TextFieldBorder
    extends SeaGlassBorder {
        private static final long serialVersionUID = -3475926670707905862L;

        public TextFieldBorder(SeaglassUI ui, Insets insets) {
            super(ui, insets);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            super.getBorderInsets(c, insets);
            if (c instanceof JComponent && isSearchField.isInState((JComponent)c)) {
                insets.left += SeaGlassTextFieldUI.this.searchIconWidth + SeaGlassTextFieldUI.this.searchLeftInnerMargin;
                if (hasPopupMenu.isInState((JComponent)c)) {
                    insets.left += SeaGlassTextFieldUI.this.popupIconWidth;
                }
                insets.right += SeaGlassTextFieldUI.this.cancelIconWidth + SeaGlassTextFieldUI.this.searchRightInnerMargin;
            }
            return insets;
        }
    }
}

