/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.ui.SeaGlassTextFieldUI;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.text.JTextComponent;

public class SeaGlassTextAreaUI
extends BasicTextAreaUI
implements SeaglassUI,
FocusListener {
    private SeaGlassStyle style;

    public static ComponentUI createUI(JComponent ta) {
        return new SeaGlassTextAreaUI();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.getComponent().repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.getComponent().repaint();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this.getComponent());
        this.getComponent().addFocusListener(this);
    }

    @Override
    protected void uninstallDefaults() {
        SeaGlassContext context = this.getContext(this.getComponent(), 1);
        this.getComponent().putClientProperty("caretAspectRatio", null);
        this.getComponent().removeFocusListener(this);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        super.uninstallDefaults();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    private void updateStyle(JTextComponent comp) {
        SeaGlassContext context = this.getContext(comp, 1);
        SeaGlassStyle oldStyle = this.style;
        this.style = (SeaGlassStyle)SeaGlassLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            SeaGlassTextFieldUI.updateStyle(comp, context, this.getPropertyPrefix());
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintTextAreaBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
        super.paint(g, this.getComponent());
    }

    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        SeaGlassContext context = this.getContext(c);
        context.getPainter().paintTextAreaBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintTextAreaBorder(context, g, x, y, w, h);
    }

    @Override
    protected void propertyChange(PropertyChangeEvent evt) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JTextComponent)evt.getSource());
        }
        super.propertyChange(evt);
    }
}

