/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.component.SeaGlassBorder;
import com.seaglasslookandfeel.ui.SeaGlassLabelUI;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import sun.swing.DefaultLookup;

public class SeaGlassTableHeaderUI
extends BasicTableHeaderUI
implements PropertyChangeListener,
SeaglassUI {
    private TableCellRenderer prevRenderer = null;
    private SynthStyle style;

    public static ComponentUI createUI(JComponent h) {
        return new SeaGlassTableHeaderUI();
    }

    @Override
    protected void installDefaults() {
        this.prevRenderer = this.header.getDefaultRenderer();
        if (this.prevRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new HeaderRenderer());
        }
        this.updateStyle(this.header);
    }

    private void updateStyle(JTableHeader c) {
        SeaGlassContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle && oldStyle != null) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
        context.dispose();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.header.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallDefaults() {
        if (this.header.getDefaultRenderer() instanceof HeaderRenderer) {
            this.header.setDefaultRenderer(this.prevRenderer);
        }
        SeaGlassContext context = this.getContext(this.header, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    protected void uninstallListeners() {
        this.header.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintTableHeaderBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
        super.paint(g, context.getComponent());
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintTableHeaderBorder(context, g, x, y, w, h);
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JTableHeader)evt.getSource());
        }
    }

    @Override
    protected void rolloverColumnUpdated(int oldColumn, int newColumn) {
        this.header.repaint(this.header.getHeaderRect(oldColumn));
        this.header.repaint(this.header.getHeaderRect(newColumn));
    }

    public static class DefaultTableCellHeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private static final long serialVersionUID = -4466195868054511962L;
        private Icon sortArrow;
        private EmptyIcon emptyIcon = new EmptyIcon();

        public DefaultTableCellHeaderRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setHorizontalTextPosition(int textPosition) {
            super.setHorizontalTextPosition(textPosition);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Icon sortIcon = null;
            boolean isPaintingForPrint = false;
            if (table != null) {
                SortOrder sortOrder;
                JTableHeader header = table.getTableHeader();
                if (header != null) {
                    Color fgColor = null;
                    Color bgColor = null;
                    if (hasFocus) {
                        fgColor = DefaultLookup.getColor(this, this.ui, "TableHeader.focusCellForeground");
                        bgColor = DefaultLookup.getColor(this, this.ui, "TableHeader.focusCellBackground");
                    }
                    if (fgColor == null) {
                        fgColor = header.getForeground();
                    }
                    if (bgColor == null) {
                        bgColor = header.getBackground();
                    }
                    this.setForeground(fgColor);
                    this.setBackground(bgColor);
                    this.setFont(header.getFont());
                    isPaintingForPrint = header.isPaintingForPrint();
                }
                if (!isPaintingForPrint && table.getRowSorter() != null && (sortOrder = DefaultTableCellHeaderRenderer.getColumnSortOrder(table, column)) != null) {
                    switch (sortOrder) {
                        case ASCENDING: {
                            sortIcon = DefaultLookup.getIcon(this, this.ui, "Table.ascendingSortIcon");
                            break;
                        }
                        case DESCENDING: {
                            sortIcon = DefaultLookup.getIcon(this, this.ui, "Table.descendingSortIcon");
                            break;
                        }
                        case UNSORTED: {
                            sortIcon = DefaultLookup.getIcon(this, this.ui, "Table.naturalSortIcon");
                        }
                    }
                }
            }
            if (value instanceof Icon) {
                this.setText("");
                this.setIcon((Icon)value);
            } else if (value instanceof JLabel) {
                JLabel label = (JLabel)value;
                this.setText(label.getText());
                this.setIcon(label.getIcon());
                this.setHorizontalAlignment(label.getHorizontalAlignment());
                this.setHorizontalTextPosition(label.getHorizontalTextPosition());
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
            }
            this.sortArrow = sortIcon;
            Border border = null;
            if (hasFocus) {
                border = DefaultLookup.getBorder(this, this.ui, "TableHeader.focusCellBorder");
            }
            if (border == null) {
                border = DefaultLookup.getBorder(this, this.ui, "TableHeader.cellBorder");
            }
            this.setBorder(border);
            return this;
        }

        public static SortOrder getColumnSortOrder(JTable table, int column) {
            SortOrder rv = null;
            if (table == null || table.getRowSorter() == null) {
                return rv;
            }
            List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
            if (sortKeys.size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
                rv = sortKeys.get(0).getSortOrder();
            }
            return rv;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.sortArrow != null) {
                this.emptyIcon.width = this.sortArrow.getIconWidth();
                this.emptyIcon.height = this.sortArrow.getIconHeight();
                Point position = this.computeIconPosition(g);
                super.paintComponent(g);
                this.sortArrow.paintIcon(this, g, position.x, position.y);
            } else {
                super.paintComponent(g);
            }
        }

        private Point computeIconPosition(Graphics g) {
            FontMetrics fontMetrics = g.getFontMetrics();
            Rectangle viewR = new Rectangle();
            Rectangle textR = new Rectangle();
            Rectangle iconR = new Rectangle();
            Insets i = this.getInsets();
            viewR.x = i.left;
            viewR.y = i.top;
            viewR.width = this.getWidth() - (i.left + i.right);
            viewR.height = this.getHeight() - (i.top + i.bottom);
            SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), this.sortArrow, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewR, iconR, textR, this.getIconTextGap());
            int x = this.getComponentOrientation().isLeftToRight() ? this.getWidth() - i.right - this.sortArrow.getIconWidth() : i.left;
            int y = iconR.y;
            return new Point(x, y);
        }

        private class EmptyIcon
        implements Icon,
        Serializable {
            private static final long serialVersionUID = -821523476678771032L;
            int width = 0;
            int height = 0;

            private EmptyIcon() {
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }

            @Override
            public int getIconWidth() {
                return this.width;
            }

            @Override
            public int getIconHeight() {
                return this.height;
            }
        }
    }

    public static class HeaderRenderer
    extends DefaultTableCellHeaderRenderer {
        private static final long serialVersionUID = 3595483618538272322L;

        public HeaderRenderer() {
            this.setHorizontalAlignment(10);
            this.setName("TableHeader.renderer");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            block8: {
                block7: {
                    List<RowSorter.SortKey> sortKeys;
                    boolean hasRollover = false;
                    if (isSelected || hasRollover || hasFocus) {
                        SeaGlassLookAndFeel.setSelectedUI((SeaGlassLabelUI)SeaGlassLookAndFeel.getUIOfType(this.getUI(), SeaGlassLabelUI.class), isSelected, hasFocus, table.isEnabled(), hasRollover);
                    } else {
                        SeaGlassLookAndFeel.resetSelectedUI();
                    }
                    RowSorter<? extends TableModel> rs = table == null ? null : table.getRowSorter();
                    List<RowSorter.SortKey> list = sortKeys = rs == null ? null : rs.getSortKeys();
                    if (sortKeys == null || sortKeys.size() <= 0 || sortKeys.get(0).getColumn() != table.convertColumnIndexToModel(column)) break block7;
                    switch (sortKeys.get(0).getSortOrder()) {
                        case ASCENDING: {
                            this.putClientProperty("Table.sortOrder", "ASCENDING");
                            break block8;
                        }
                        case DESCENDING: {
                            this.putClientProperty("Table.sortOrder", "DESCENDING");
                            break block8;
                        }
                        case UNSORTED: {
                            this.putClientProperty("Table.sortOrder", "UNSORTED");
                            break block8;
                        }
                        default: {
                            throw new AssertionError((Object)"Cannot happen");
                        }
                    }
                }
                this.putClientProperty("Table.sortOrder", "UNSORTED");
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }

        @Override
        public void setBorder(Border border) {
            if (border instanceof SeaGlassBorder) {
                super.setBorder(border);
            }
        }
    }
}

