/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.SeaGlassRegion;
import com.seaglasslookandfeel.SeaGlassSynthPainterImpl;
import com.seaglasslookandfeel.component.SeaGlassArrowButton;
import com.seaglasslookandfeel.ui.SeaglassUI;
import com.seaglasslookandfeel.util.ControlOrientation;
import com.seaglasslookandfeel.util.SeaGlassTabCloseListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class SeaGlassTabbedPaneUI
extends BasicTabbedPaneUI
implements SeaglassUI,
PropertyChangeListener {
    private SeaGlassContext tabAreaContext;
    private SeaGlassContext tabContext;
    private SeaGlassContext tabCloseContext;
    private SeaGlassContext tabContentContext;
    private SynthStyle style;
    private SynthStyle tabStyle;
    private SynthStyle tabCloseStyle;
    private SynthStyle tabAreaStyle;
    private SynthStyle tabContentStyle;
    private Rectangle textRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle tabAreaRect = new Rectangle();
    private Rectangle contentRect = new Rectangle();
    private boolean selectedTabIsPressed = false;
    protected SeaGlassTabCloseListener tabCloseListener;
    protected SynthScrollableTabButton scrollForwardButton;
    protected SynthScrollableTabButton scrollBackwardButton;
    protected Insets closeButtonInsets;
    protected int closeButtonSize;
    protected int leadingTabIndex = 0;
    protected int trailingTabIndex = 0;
    protected int tabPlacement;
    protected ControlOrientation orientation;
    protected int tabCloseButtonPlacement;
    protected int closeButtonArmedIndex;
    protected int closeButtonHoverIndex;

    SeaGlassTabbedPaneUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SeaGlassTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.scrollBackwardButton = (SynthScrollableTabButton)this.createScrollButton(7);
        this.scrollForwardButton = (SynthScrollableTabButton)this.createScrollButton(3);
        this.tabPane.add(this.scrollBackwardButton);
        this.tabPane.add(this.scrollForwardButton);
        this.scrollBackwardButton.setVisible(false);
        this.scrollForwardButton.setVisible(false);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        if (this.scrollBackwardButton != null) {
            this.tabPane.remove(this.scrollBackwardButton);
            this.scrollBackwardButton = null;
        }
        if (this.scrollForwardButton != null) {
            this.tabPane.remove(this.scrollForwardButton);
            this.scrollForwardButton = null;
        }
    }

    @Override
    protected void installDefaults() {
        this.leadingTabIndex = 0;
        this.trailingTabIndex = 0;
        this.updateStyle(this.tabPane);
    }

    private void updateStyle(JTabbedPane c) {
        SeaGlassContext context = this.getContext((JComponent)c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        this.tabPlacement = this.tabPane.getTabPlacement();
        this.orientation = ControlOrientation.getOrientation(this.tabPlacement == 2 || this.tabPlacement == 4 ? 1 : 0);
        this.closeButtonArmedIndex = -1;
        Object o = c.getClientProperty("JTabbedPane.closeButton");
        this.tabCloseButtonPlacement = o != null && "left".equals(o) ? 2 : (o != null && "right".equals(o) ? 4 : 0);
        this.closeButtonSize = this.style.getInt(context, "closeButtonSize", 6);
        this.closeButtonInsets = (Insets)this.style.get(context, "closeButtonInsets");
        if (this.closeButtonInsets == null) {
            this.closeButtonInsets = new Insets(2, 2, 2, 2);
        }
        if ((o = c.getClientProperty("JTabbedPane.closeListener")) != null && o instanceof SeaGlassTabCloseListener && this.tabCloseListener == null) {
            this.tabCloseListener = (SeaGlassTabCloseListener)o;
        }
        if (this.style != oldStyle) {
            this.tabRunOverlay = 0;
            this.textIconGap = this.style.getInt(context, "TabbedPane.textIconGap", 0);
            this.selectedTabPadInsets = (Insets)this.style.get(context, "TabbedPane.selectedTabPadInsets");
            if (this.selectedTabPadInsets == null) {
                this.selectedTabPadInsets = new Insets(0, 0, 0, 0);
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
        if (this.tabContext != null) {
            this.tabContext.dispose();
        }
        this.tabContext = this.getContext(c, Region.TABBED_PANE_TAB, 1);
        this.tabStyle = SeaGlassLookAndFeel.updateStyle(this.tabContext, this);
        this.tabInsets = this.tabStyle.getInsets(this.tabContext, null);
        if (this.tabCloseContext != null) {
            this.tabCloseContext.dispose();
        }
        this.tabCloseContext = this.getContext(c, SeaGlassRegion.TABBED_PANE_TAB_CLOSE_BUTTON, 1);
        this.tabCloseStyle = SeaGlassLookAndFeel.updateStyle(this.tabCloseContext, this);
        if (this.tabAreaContext != null) {
            this.tabAreaContext.dispose();
        }
        this.tabAreaContext = this.getContext(c, Region.TABBED_PANE_TAB_AREA, 1);
        this.tabAreaStyle = SeaGlassLookAndFeel.updateStyle(this.tabAreaContext, this);
        this.tabAreaInsets = this.tabAreaStyle.getInsets(this.tabAreaContext, null);
        if (this.tabContentContext != null) {
            this.tabContentContext.dispose();
        }
        this.tabContentContext = this.getContext(c, Region.TABBED_PANE_CONTENT, 1);
        this.tabContentStyle = SeaGlassLookAndFeel.updateStyle(this.tabContentContext, this);
        this.contentBorderInsets = this.tabContentStyle.getInsets(this.tabContentContext, null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseMotionListener((MouseAdapter)this.mouseListener);
        this.tabPane.addPropertyChangeListener(this);
        this.scrollBackwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeaGlassTabbedPaneUI.this.scrollBackward();
            }
        });
        this.scrollForwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeaGlassTabbedPaneUI.this.scrollForward();
            }
        });
    }

    protected void scrollBackward() {
        int selectedIndex = this.tabPane.getSelectedIndex();
        if (--selectedIndex < 0) {
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() == 0 ? -1 : 0);
        } else {
            this.tabPane.setSelectedIndex(selectedIndex);
        }
        this.tabPane.repaint();
    }

    protected void scrollForward() {
        int selectedIndex = this.tabPane.getSelectedIndex();
        if (++selectedIndex >= this.tabPane.getTabCount()) {
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        } else {
            this.tabPane.setSelectedIndex(selectedIndex);
        }
        this.tabPane.repaint();
    }

    @Override
    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabPane.removeMouseMotionListener((MouseAdapter)this.mouseListener);
        }
        this.tabPane.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    protected void uninstallDefaults() {
        SeaGlassContext context = this.getContext((JComponent)this.tabPane, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        this.tabStyle.uninstallDefaults(this.tabContext);
        this.tabContext.dispose();
        this.tabContext = null;
        this.tabStyle = null;
        this.tabAreaStyle.uninstallDefaults(this.tabAreaContext);
        this.tabAreaContext.dispose();
        this.tabAreaContext = null;
        this.tabAreaStyle = null;
        this.tabContentStyle.uninstallDefaults(this.tabContentContext);
        this.tabContentContext.dispose();
        this.tabContentContext = null;
        this.tabContentStyle = null;
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    public SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    public SeaGlassContext getContext(JComponent c, Region subregion) {
        return this.getContext(c, subregion, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, Region subregion, int state) {
        SynthStyle style = null;
        Class<SeaGlassContext> klass = SeaGlassContext.class;
        if (subregion == Region.TABBED_PANE_TAB) {
            style = this.tabStyle;
        } else if (subregion == Region.TABBED_PANE_TAB_AREA) {
            style = this.tabAreaStyle;
        } else if (subregion == Region.TABBED_PANE_CONTENT) {
            style = this.tabContentStyle;
        } else if (subregion == SeaGlassRegion.TABBED_PANE_TAB_CLOSE_BUTTON) {
            style = this.tabCloseStyle;
        }
        return SeaGlassContext.getContext(klass, c, subregion, style, state);
    }

    private int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    public int getCloseButtonState(JComponent c, int tabIndex, boolean tabIsMousedOver) {
        if (!c.isEnabled()) {
            return 8;
        }
        if (tabIndex == this.closeButtonArmedIndex) {
            return 4;
        }
        if (tabIndex == this.closeButtonHoverIndex) {
            return 256;
        }
        if (tabIsMousedOver) {
            return 2;
        }
        return 1;
    }

    @Override
    protected JButton createScrollButton(int direction) {
        SynthScrollableTabButton b = new SynthScrollableTabButton(direction);
        b.setName("TabbedPaneTabArea.button" + direction);
        return b;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle(this.tabPane);
        } else if (e.getPropertyName() == "tabPlacement") {
            this.updateStyle(this.tabPane);
        }
    }

    @Override
    protected MouseListener createMouseListener() {
        return new SeaGlassTabbedPaneMouseHandler(super.createMouseListener());
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SeaGlassTabbedPaneLayout();
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintTabbedPaneBackground(context, g, this.tabAreaRect.x, this.tabAreaRect.y, this.tabAreaRect.width, this.tabAreaRect.height);
        this.paint(context, g);
        context.dispose();
    }

    @Override
    protected int getBaseline(int tab) {
        if (this.tabPane.getTabComponentAt(tab) != null || this.getTextViewForTab(tab) != null) {
            return super.getBaseline(tab);
        }
        String title = this.tabPane.getTitleAt(tab);
        Font font = this.tabContext.getStyle().getFont(this.tabContext);
        FontMetrics metrics = this.getFontMetrics(font);
        Icon icon = this.getIconForTab(tab);
        this.textRect.setBounds(0, 0, 0, 0);
        this.iconRect.setBounds(0, 0, 0, 0);
        this.calcRect.setBounds(0, 0, Short.MAX_VALUE, this.maxTabHeight);
        this.tabContext.getStyle().getGraphicsUtils(this.tabContext).layoutText(this.tabContext, metrics, title, icon, 0, 0, 10, 11, this.calcRect, this.iconRect, this.textRect, this.textIconGap);
        return this.textRect.y + metrics.getAscent() + this.getBaselineOffset();
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintTabbedPaneBorder(context, g, x, y, w, h);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        this.ensureCurrentLayout();
        this.paintContentBorder(this.tabContentContext, g, this.tabPlacement, selectedIndex);
        this.paintTabArea(g, this.tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        this.paintTabArea(this.tabAreaContext, g, tabPlacement, selectedIndex, this.tabAreaRect);
    }

    protected void paintTabArea(SeaGlassContext ss, Graphics g, int tabPlacement, int selectedIndex, Rectangle tabAreaBounds) {
        Rectangle clipRect = g.getClipBounds();
        ss.setComponentState(1);
        SeaGlassLookAndFeel.updateSubregion(ss, g, tabAreaBounds);
        ss.getPainter().paintTabbedPaneTabAreaBackground(ss, g, tabAreaBounds.x, tabAreaBounds.y, tabAreaBounds.width, tabAreaBounds.height, tabPlacement);
        ss.getPainter().paintTabbedPaneTabAreaBorder(ss, g, tabAreaBounds.x, tabAreaBounds.y, tabAreaBounds.width, tabAreaBounds.height, tabPlacement);
        this.iconRect.setBounds(0, 0, 0, 0);
        this.textRect.setBounds(0, 0, 0, 0);
        if (this.runCount == 0) {
            return;
        }
        if (this.scrollBackwardButton.isVisible()) {
            this.paintScrollButtonBackground(ss, g, this.scrollBackwardButton);
        }
        if (this.scrollForwardButton.isVisible()) {
            this.paintScrollButtonBackground(ss, g, this.scrollForwardButton);
        }
        for (int i = this.leadingTabIndex; i <= this.trailingTabIndex; ++i) {
            if (!this.rects[i].intersects(clipRect) || selectedIndex == i) continue;
            this.paintTab(this.tabContext, g, this.rects, i, this.iconRect, this.textRect);
        }
        if (selectedIndex >= 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(this.tabContext, g, this.rects, selectedIndex, this.iconRect, this.textRect);
        }
    }

    @Override
    protected void setRolloverTab(int index) {
        int oldRolloverTab = this.getRolloverTab();
        super.setRolloverTab(index);
        Rectangle r = null;
        if (oldRolloverTab >= 0 && oldRolloverTab < this.tabPane.getTabCount() && (r = this.getTabBounds(this.tabPane, oldRolloverTab)) != null) {
            this.tabPane.repaint(r);
        }
        if (index >= 0 && (r = this.getTabBounds(this.tabPane, index)) != null) {
            this.tabPane.repaint(r);
        }
    }

    protected void paintTab(SeaGlassContext ss, Graphics g, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        JComponent b = ss.getComponent();
        boolean flipSegments = this.orientation == ControlOrientation.HORIZONTAL && !this.tabPane.getComponentOrientation().isLeftToRight();
        String segmentPosition = "only";
        if (this.tabPane.getTabCount() > 1) {
            segmentPosition = tabIndex == 0 && tabIndex == this.leadingTabIndex ? (flipSegments ? "last" : "first") : (tabIndex == this.tabPane.getTabCount() - 1 && tabIndex == this.trailingTabIndex ? (flipSegments ? "first" : "last") : "middle");
        }
        b.putClientProperty("JTabbedPane.Tab.segmentPosition", segmentPosition);
        this.updateTabContext(tabIndex, isSelected, isSelected && this.selectedTabIsPressed, this.getRolloverTab() == tabIndex, this.getFocusIndex() == tabIndex);
        SeaGlassLookAndFeel.updateSubregion(ss, g, tabRect);
        int x = tabRect.x;
        int y = tabRect.y;
        int height = tabRect.height;
        int width = tabRect.width;
        this.tabContext.getPainter().paintTabbedPaneTabBackground(this.tabContext, g, x, y, width, height, tabIndex, this.tabPlacement);
        this.tabContext.getPainter().paintTabbedPaneTabBorder(this.tabContext, g, x, y, width, height, tabIndex, this.tabPlacement);
        if (this.tabCloseButtonPlacement != 0) {
            tabRect = this.paintCloseButton(g, this.tabContext, tabIndex);
        }
        if (this.tabPane.getTabComponentAt(tabIndex) == null) {
            String title = this.tabPane.getTitleAt(tabIndex);
            Font font = ss.getStyle().getFont(ss);
            FontMetrics metrics = SwingUtilities2.getFontMetrics(this.tabPane, g, font);
            Icon icon = this.getIconForTab(tabIndex);
            this.layoutLabel(ss, this.tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
            this.paintText(ss, g, this.tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            this.paintIcon(g, this.tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
    }

    protected Rectangle paintCloseButton(Graphics g, SynthContext tabContext, int tabIndex) {
        Rectangle tabRect = new Rectangle(this.rects[tabIndex]);
        Rectangle bounds = this.getCloseButtonBounds(tabIndex);
        int offset = bounds.width + this.textIconGap;
        boolean onLeft = this.isCloseButtonOnLeft();
        if (onLeft) {
            tabRect.x += offset;
            tabRect.width -= offset;
        } else {
            tabRect.width -= offset;
        }
        SeaGlassContext subcontext = this.getContext(this.tabPane, SeaGlassRegion.TABBED_PANE_TAB_CLOSE_BUTTON, this.getCloseButtonState(this.tabPane, tabIndex, (tabContext.getComponentState() & 2) != 0));
        SeaGlassLookAndFeel.updateSubregion(subcontext, g, bounds);
        SeaGlassSynthPainterImpl painter = (SeaGlassSynthPainterImpl)subcontext.getPainter();
        painter.paintSearchButtonForeground(subcontext, g, bounds.x, bounds.y, bounds.width, bounds.height);
        subcontext.dispose();
        return tabRect;
    }

    protected void paintScrollButtonBackground(SeaGlassContext ss, Graphics g, JButton scrollButton) {
        Rectangle tabRect = scrollButton.getBounds();
        int x = tabRect.x;
        int y = tabRect.y;
        int height = tabRect.height;
        int width = tabRect.width;
        boolean flipSegments = this.orientation == ControlOrientation.HORIZONTAL && !this.tabPane.getComponentOrientation().isLeftToRight();
        SeaGlassLookAndFeel.updateSubregion(ss, g, tabRect);
        this.tabPane.putClientProperty("JTabbedPane.Tab.segmentPosition", scrollButton == this.scrollBackwardButton ^ flipSegments ? "first" : "last");
        int oldState = this.tabContext.getComponentState();
        ButtonModel model = scrollButton.getModel();
        int isPressed = model.isPressed() && model.isArmed() ? 4 : 0;
        int buttonState = SeaGlassLookAndFeel.getComponentState(scrollButton) | isPressed;
        this.tabContext.setComponentState(buttonState);
        this.tabContext.getPainter().paintTabbedPaneTabBackground(this.tabContext, g, x, y, width, height, -1, this.tabPlacement);
        this.tabContext.getPainter().paintTabbedPaneTabBorder(this.tabContext, g, x, y, width, height, -1, this.tabPlacement);
        this.tabContext.setComponentState(oldState);
    }

    protected void layoutLabel(SeaGlassContext ss, int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        ss.getStyle().getGraphicsUtils(ss).layoutText(ss, metrics, title, icon, 0, 0, 10, 11, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    protected void paintText(SeaGlassContext ss, Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)this.tabPane, g);
            title = SwingUtilities2.clipStringIfNecessary(this.tabPane, fm, title, textRect.width);
            g.setColor(ss.getStyle().getColor(ss, ColorType.TEXT_FOREGROUND));
            ss.getStyle().getGraphicsUtils(ss).paintText(ss, g, title, textRect, mnemIndex);
        }
    }

    protected void paintContentBorder(SeaGlassContext ss, Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        SeaGlassLookAndFeel.updateSubregion(ss, g, new Rectangle(x, y, w, h));
        ss.getPainter().paintTabbedPaneContentBackground(ss, g, x, y, w, h);
        ss.getPainter().paintTabbedPaneContentBorder(ss, g, x, y, w, h);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    @Override
    public int calculateMaxTabHeight(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        int fontHeight = metrics.getHeight();
        for (int i = 0; i < tabCount; ++i) {
            result = Math.max(this.calculateTabHeight(tabPlacement, i, fontHeight), result);
        }
        return result;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Icon icon = this.getIconForTab(tabIndex);
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        int width = tabInsets.left + tabInsets.right + 3;
        Component tabComponent = this.tabPane.getTabComponentAt(tabIndex);
        if (tabComponent != null) {
            width += tabComponent.getPreferredSize().width;
            if (tabIndex < this.rects.length && this.tabCloseButtonPlacement != 0) {
                width += this.getCloseButtonBounds((int)tabIndex).width + this.textIconGap;
            }
        } else {
            View v;
            if (icon != null) {
                width += icon.getIconWidth() + this.textIconGap;
            }
            if (tabIndex < this.rects.length && this.tabCloseButtonPlacement != 0) {
                width += this.getCloseButtonBounds((int)tabIndex).width + this.textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                width += (int)v.getPreferredSpan(0);
            } else {
                String title = this.tabPane.getTitleAt(tabIndex);
                width += this.tabContext.getStyle().getGraphicsUtils(this.tabContext).computeStringWidth(this.tabContext, metrics.getFont(), metrics, title);
            }
        }
        return width;
    }

    @Override
    public int calculateMaxTabWidth(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        for (int i = 0; i < tabCount; ++i) {
            result = Math.max(this.calculateTabWidth(tabPlacement, i, metrics), result);
        }
        return result;
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        this.updateTabContext(tabIndex, false, false, false, this.getFocusIndex() == tabIndex);
        return this.tabInsets;
    }

    @Override
    protected FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
    }

    protected FontMetrics getFontMetrics(Font font) {
        return this.tabPane.getFontMetrics(font);
    }

    private void updateTabContext(int index, boolean selected, boolean isMouseDown, boolean isMouseOver, boolean hasFocus) {
        int state = 0;
        if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(index)) {
            state |= 8;
            if (selected) {
                state |= 0x200;
            }
        } else if (selected) {
            state |= 0x201;
            if (isMouseOver && UIManager.getBoolean("TabbedPane.isTabRollover")) {
                state |= 2;
            }
        } else if (isMouseOver) {
            state |= 3;
        } else {
            state = SeaGlassLookAndFeel.getComponentState(this.tabPane);
            state &= 0xFFFFFEFF;
        }
        if (hasFocus && this.tabPane.hasFocus()) {
            state |= 0x100;
        }
        if (isMouseDown) {
            state |= 4;
        }
        this.tabContext.setComponentState(state);
    }

    protected boolean isOverCloseButton(int x, int y) {
        if (this.tabCloseButtonPlacement != 0) {
            int tabCount = this.tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!this.getCloseButtonBounds(i).contains(x, y)) continue;
                this.closeButtonHoverIndex = i;
                return true;
            }
        }
        this.closeButtonHoverIndex = -1;
        return false;
    }

    protected Rectangle getCloseButtonBounds(int tabIndex) {
        Rectangle bounds = new Rectangle(this.rects[tabIndex]);
        bounds.width = this.closeButtonSize;
        bounds.height = this.closeButtonSize;
        bounds.y += (this.rects[tabIndex].height - this.closeButtonSize - this.closeButtonInsets.top - this.closeButtonInsets.bottom) / 2 + this.closeButtonInsets.top;
        boolean onLeft = this.isCloseButtonOnLeft();
        if (onLeft) {
            int offset = this.orientation == ControlOrientation.VERTICAL || tabIndex == 0 ? 6 : 3;
            bounds.x += offset;
        } else {
            int offset = this.orientation == ControlOrientation.VERTICAL || tabIndex == this.tabPane.getTabCount() - 1 ? 6 : 4;
            bounds.x += this.rects[tabIndex].width - bounds.width - offset;
        }
        return bounds;
    }

    private boolean isCloseButtonOnLeft() {
        return this.tabCloseButtonPlacement == 2 == this.tabPane.getComponentOrientation().isLeftToRight();
    }

    protected void doClose(int tabIndex) {
        if (this.tabCloseListener == null || this.tabCloseListener.tabAboutToBeClosed(tabIndex)) {
            String title = this.tabPane.getTitleAt(tabIndex);
            Component component = this.tabPane.getComponentAt(tabIndex);
            this.tabPane.removeTabAt(tabIndex);
            if (this.tabCloseListener != null) {
                this.tabCloseListener.tabClosed(title, component);
            }
        }
    }

    public class SeaGlassTabbedPaneMouseHandler
    extends MouseAdapter {
        protected transient int currentMouseX;
        protected transient int currentMouseY;
        private MouseListener delegate;
        private MouseMotionListener delegate2;

        public SeaGlassTabbedPaneMouseHandler(MouseListener originalMouseListener) {
            this.delegate = originalMouseListener;
            this.delegate2 = (MouseMotionListener)((Object)originalMouseListener);
            SeaGlassTabbedPaneUI.this.closeButtonHoverIndex = -1;
            SeaGlassTabbedPaneUI.this.closeButtonArmedIndex = -1;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.delegate.mouseClicked(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.delegate.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.delegate.mouseExited(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int oldHoverIndex = SeaGlassTabbedPaneUI.this.closeButtonHoverIndex;
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            SeaGlassTabbedPaneUI.this.isOverCloseButton(this.currentMouseX, this.currentMouseY);
            if (oldHoverIndex != SeaGlassTabbedPaneUI.this.closeButtonHoverIndex) {
                SeaGlassTabbedPaneUI.this.tabPane.repaint();
                return;
            }
            this.delegate2.mouseMoved(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (SeaGlassTabbedPaneUI.this.closeButtonArmedIndex != -1 && !SeaGlassTabbedPaneUI.this.isOverCloseButton(this.currentMouseX, this.currentMouseY)) {
                SeaGlassTabbedPaneUI.this.tabPane.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SeaGlassTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e) || !SeaGlassTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = SeaGlassTabbedPaneUI.this.tabForCoordinate(SeaGlassTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (SeaGlassTabbedPaneUI.this.isOverCloseButton(this.currentMouseX, this.currentMouseY)) {
                SeaGlassTabbedPaneUI.this.closeButtonArmedIndex = tabIndex;
                SeaGlassTabbedPaneUI.this.tabPane.repaint();
                return;
            }
            if (SeaGlassTabbedPaneUI.this.closeButtonArmedIndex != -1) {
                SeaGlassTabbedPaneUI.this.tabPane.repaint();
                return;
            }
            if (tabIndex >= 0 && SeaGlassTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex) && tabIndex == SeaGlassTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                SeaGlassTabbedPaneUI.this.selectedTabIsPressed = true;
                SeaGlassTabbedPaneUI.this.tabPane.repaint();
            }
            this.delegate.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SeaGlassTabbedPaneUI.this.closeButtonArmedIndex != -1) {
                if (SeaGlassTabbedPaneUI.this.isOverCloseButton(this.currentMouseX, this.currentMouseY)) {
                    SeaGlassTabbedPaneUI.this.doClose(SeaGlassTabbedPaneUI.this.closeButtonArmedIndex);
                }
                SeaGlassTabbedPaneUI.this.closeButtonArmedIndex = -1;
                SeaGlassTabbedPaneUI.this.tabPane.repaint();
            } else if (SeaGlassTabbedPaneUI.this.selectedTabIsPressed) {
                SeaGlassTabbedPaneUI.this.selectedTabIsPressed = false;
                SeaGlassTabbedPaneUI.this.tabPane.repaint();
            }
            this.delegate.mouseReleased(e);
            this.delegate2.mouseMoved(e);
        }
    }

    protected class SeaGlassTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected SeaGlassTabbedPaneLayout() {
            super(SeaGlassTabbedPaneUI.this);
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return SeaGlassTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return SeaGlassTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        @Override
        public void layoutContainer(Container parent) {
            SeaGlassTabbedPaneUI.this.setRolloverTab(-1);
            this.setScrollButtonDirections();
            this.calculateLayoutInfo();
            boolean shouldChangeFocus = this.verifyFocus(SeaGlassTabbedPaneUI.this.tabPane.getSelectedIndex());
            if (SeaGlassTabbedPaneUI.this.tabPane.getTabCount() <= 0) {
                return;
            }
            this.calcContentRect();
            for (int i = 0; i < SeaGlassTabbedPaneUI.this.tabPane.getComponentCount(); ++i) {
                Component child = SeaGlassTabbedPaneUI.this.tabPane.getComponent(i);
                if (child == SeaGlassTabbedPaneUI.this.scrollBackwardButton || child == SeaGlassTabbedPaneUI.this.scrollForwardButton) continue;
                child.setBounds(SeaGlassTabbedPaneUI.this.contentRect);
            }
            this.setTabContainerBounds();
            this.layoutTabComponents();
            if (shouldChangeFocus && !SwingUtilities2.tabbedPaneChangeFocusTo(SeaGlassTabbedPaneUI.this.getVisibleComponent())) {
                SeaGlassTabbedPaneUI.this.tabPane.requestFocus();
            }
        }

        private Component getTabContainer() {
            int tabCount = SeaGlassTabbedPaneUI.this.tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                Component tabComponent = SeaGlassTabbedPaneUI.this.tabPane.getTabComponentAt(i);
                if (tabComponent == null) continue;
                return tabComponent.getParent();
            }
            return null;
        }

        private void setTabContainerBounds() {
            Component tabContainer = this.getTabContainer();
            if (tabContainer != null) {
                int tabContainerX = SeaGlassTabbedPaneUI.this.tabPlacement == 4 ? ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).contentRect.width : 0;
                int tabContainerY = SeaGlassTabbedPaneUI.this.tabPlacement == 3 ? ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).contentRect.height : 0;
                int tabContainerWidth = SeaGlassTabbedPaneUI.this.tabPlacement == 2 || SeaGlassTabbedPaneUI.this.tabPlacement == 4 ? SeaGlassTabbedPaneUI.this.tabPane.getWidth() - ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).contentRect.width : ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).contentRect.width;
                int tabContainerHeight = SeaGlassTabbedPaneUI.this.tabPlacement == 1 || SeaGlassTabbedPaneUI.this.tabPlacement == 3 ? SeaGlassTabbedPaneUI.this.tabPane.getHeight() - ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).contentRect.height : ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).contentRect.height;
                tabContainer.setBounds(tabContainerX, tabContainerY, tabContainerWidth, tabContainerHeight);
            }
        }

        private void setScrollButtonDirections() {
            if (SeaGlassTabbedPaneUI.this.tabPlacement == 2 || SeaGlassTabbedPaneUI.this.tabPlacement == 4) {
                if (SeaGlassTabbedPaneUI.this.scrollForwardButton.getDirection() != 5) {
                    SeaGlassTabbedPaneUI.this.scrollForwardButton.setDirection(5);
                }
                if (SeaGlassTabbedPaneUI.this.scrollBackwardButton.getDirection() != 1) {
                    SeaGlassTabbedPaneUI.this.scrollBackwardButton.setDirection(1);
                }
            } else if (SeaGlassTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight()) {
                if (SeaGlassTabbedPaneUI.this.scrollForwardButton.getDirection() != 3) {
                    SeaGlassTabbedPaneUI.this.scrollForwardButton.setDirection(3);
                }
                if (SeaGlassTabbedPaneUI.this.scrollBackwardButton.getDirection() != 7) {
                    SeaGlassTabbedPaneUI.this.scrollBackwardButton.setDirection(7);
                }
            } else {
                if (SeaGlassTabbedPaneUI.this.scrollForwardButton.getDirection() != 7) {
                    SeaGlassTabbedPaneUI.this.scrollForwardButton.setDirection(7);
                }
                if (SeaGlassTabbedPaneUI.this.scrollBackwardButton.getDirection() != 3) {
                    SeaGlassTabbedPaneUI.this.scrollBackwardButton.setDirection(3);
                }
            }
        }

        private boolean verifyFocus(int selectedIndex) {
            Component visibleComponent = SeaGlassTabbedPaneUI.this.getVisibleComponent();
            Component selectedComponent = null;
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    SeaGlassTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                selectedComponent = SeaGlassTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
            }
            if (SeaGlassTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return false;
            }
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                if (selectedComponent != visibleComponent && visibleComponent != null && this.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                SeaGlassTabbedPaneUI.this.setVisibleComponent(selectedComponent);
            }
            return shouldChangeFocus;
        }

        private void calcContentRect() {
            int ch;
            int cw;
            int cy;
            int cx;
            Insets contentInsets = SeaGlassTabbedPaneUI.this.getContentBorderInsets(SeaGlassTabbedPaneUI.this.tabPlacement);
            Rectangle bounds = SeaGlassTabbedPaneUI.this.tabPane.getBounds();
            Insets insets = SeaGlassTabbedPaneUI.this.tabPane.getInsets();
            switch (SeaGlassTabbedPaneUI.this.tabPlacement) {
                case 2: {
                    cx = ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.x + ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.width + contentInsets.left;
                    cy = ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.y + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.width - contentInsets.left - contentInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    break;
                }
                case 4: {
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.width - contentInsets.left - contentInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                    break;
                }
                case 3: {
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.height - contentInsets.top - contentInsets.bottom;
                    break;
                }
                default: {
                    cx = ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.x + contentInsets.left;
                    cy = ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.y + ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.height + contentInsets.top;
                    cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    ch = bounds.height - insets.top - insets.bottom - ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.height - contentInsets.top - contentInsets.bottom;
                }
            }
            SeaGlassTabbedPaneUI.this.contentRect.setBounds(cx, cy, cw, ch);
        }

        private void layoutTabComponents() {
            Rectangle rect = new Rectangle();
            for (int i = 0; i < SeaGlassTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                Component c = SeaGlassTabbedPaneUI.this.tabPane.getTabComponentAt(i);
                if (c == null) continue;
                SeaGlassTabbedPaneUI.this.getTabBounds(i, rect);
                Dimension preferredSize = c.getPreferredSize();
                Insets insets = SeaGlassTabbedPaneUI.this.getTabInsets(SeaGlassTabbedPaneUI.this.tabPlacement, i);
                int outerX = rect.x - c.getParent().getX() + insets.left;
                int outerY = rect.y - c.getParent().getY() + insets.top;
                int outerWidth = rect.width - insets.left - insets.right;
                int outerHeight = rect.height - insets.top - insets.bottom;
                int x = outerX + (outerWidth - preferredSize.width) / 2;
                int y = outerY + (outerHeight - preferredSize.height) / 2;
                boolean isSelected = i == SeaGlassTabbedPaneUI.this.tabPane.getSelectedIndex();
                c.setBounds(x + SeaGlassTabbedPaneUI.this.getTabLabelShiftX(SeaGlassTabbedPaneUI.this.tabPlacement, i, isSelected), y + SeaGlassTabbedPaneUI.this.getTabLabelShiftY(SeaGlassTabbedPaneUI.this.tabPlacement, i, isSelected), preferredSize.width, preferredSize.height);
            }
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            if (SeaGlassTabbedPaneUI.this.orientation == ControlOrientation.HORIZONTAL) {
                SeaGlassTabbedPaneUI.this.maxTabHeight = SeaGlassTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            } else {
                SeaGlassTabbedPaneUI.this.maxTabWidth = SeaGlassTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
            }
            this.calcTabAreaRect();
            if (tabCount == 0) {
                SeaGlassTabbedPaneUI.this.scrollBackwardButton.setVisible(false);
                SeaGlassTabbedPaneUI.this.scrollForwardButton.setVisible(false);
                SeaGlassTabbedPaneUI.this.runCount = 0;
                SeaGlassTabbedPaneUI.this.selectedRun = -1;
                return;
            }
            SeaGlassTabbedPaneUI.this.selectedRun = 0;
            SeaGlassTabbedPaneUI.this.runCount = 1;
            int selectedIndex = SeaGlassTabbedPaneUI.this.tabPane.getSelectedIndex();
            if (SeaGlassTabbedPaneUI.this.leadingTabIndex > selectedIndex) {
                SeaGlassTabbedPaneUI.this.leadingTabIndex = selectedIndex;
            }
            Insets tabAreaInsets = SeaGlassTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Dimension size = new Dimension(((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.width - tabAreaInsets.left - tabAreaInsets.right, ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.height - tabAreaInsets.top - tabAreaInsets.bottom);
            int tabAreaLength = SeaGlassTabbedPaneUI.this.orientation.getLength(size);
            int buttonLength = SeaGlassTabbedPaneUI.this.orientation.getLength(SeaGlassTabbedPaneUI.this.scrollForwardButton.getPreferredSize());
            this.determineVisibleTabIndices(tabCount, selectedIndex, tabAreaLength, buttonLength);
            this.resetTabPositionsToLeadingTabIndex(tabCount);
            int totalLength = SeaGlassTabbedPaneUI.this.orientation.getPosition(((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[SeaGlassTabbedPaneUI.this.trailingTabIndex].x + ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[SeaGlassTabbedPaneUI.this.trailingTabIndex].width, ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[SeaGlassTabbedPaneUI.this.trailingTabIndex].y + ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[SeaGlassTabbedPaneUI.this.trailingTabIndex].height);
            if (SeaGlassTabbedPaneUI.this.leadingTabIndex > 0 || SeaGlassTabbedPaneUI.this.trailingTabIndex < tabCount - 1) {
                this.resizeTabs(tabCount, totalLength, buttonLength, tabAreaLength);
            } else {
                this.centerTabs(tabCount, totalLength, tabAreaLength);
            }
            this.setScrollButtonPositions(SeaGlassTabbedPaneUI.this.scrollBackwardButton, SeaGlassTabbedPaneUI.this.leadingTabIndex > 0, SeaGlassTabbedPaneUI.this.orientation.getPosition(SeaGlassTabbedPaneUI.this.rects[SeaGlassTabbedPaneUI.this.leadingTabIndex]) - buttonLength);
            this.setScrollButtonPositions(SeaGlassTabbedPaneUI.this.scrollForwardButton, SeaGlassTabbedPaneUI.this.trailingTabIndex < tabCount - 1, SeaGlassTabbedPaneUI.this.orientation.getPosition(SeaGlassTabbedPaneUI.this.rects[SeaGlassTabbedPaneUI.this.trailingTabIndex]) + SeaGlassTabbedPaneUI.this.orientation.getLength(SeaGlassTabbedPaneUI.this.rects[SeaGlassTabbedPaneUI.this.trailingTabIndex]));
            if (!SeaGlassTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight() && SeaGlassTabbedPaneUI.this.orientation == ControlOrientation.HORIZONTAL) {
                this.flipRightToLeft(tabCount, SeaGlassTabbedPaneUI.this.tabPane.getSize());
            }
        }

        private void calcTabAreaRect() {
            int offset;
            int thickness;
            int position;
            int length;
            Insets insets = SeaGlassTabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = SeaGlassTabbedPaneUI.this.getTabAreaInsets(SeaGlassTabbedPaneUI.this.tabPlacement);
            Rectangle bounds = SeaGlassTabbedPaneUI.this.tabPane.getBounds();
            if (SeaGlassTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                SeaGlassTabbedPaneUI.this.tabAreaRect.setBounds(0, 0, 0, 0);
                return;
            }
            if (SeaGlassTabbedPaneUI.this.orientation == ControlOrientation.HORIZONTAL) {
                length = bounds.width - insets.left - insets.right;
                position = insets.left;
                thickness = SeaGlassTabbedPaneUI.this.maxTabHeight + tabAreaInsets.top + tabAreaInsets.bottom;
                offset = SeaGlassTabbedPaneUI.this.tabPlacement == 3 ? bounds.height - insets.bottom - thickness : insets.top;
            } else {
                length = bounds.height - insets.top - insets.bottom;
                position = insets.top;
                thickness = SeaGlassTabbedPaneUI.this.maxTabWidth + tabAreaInsets.left + tabAreaInsets.right;
                offset = SeaGlassTabbedPaneUI.this.tabPlacement == 4 ? bounds.width - insets.right - thickness : insets.left;
            }
            SeaGlassTabbedPaneUI.this.tabAreaRect.setBounds(SeaGlassTabbedPaneUI.this.orientation.createBounds(position, offset, length, thickness));
        }

        private void determineVisibleTabIndices(int tabCount, int selectedIndex, int tabAreaLength, int buttonLength) {
            int desiredMaximumLength = this.calcDesiredMaximumLength(tabCount);
            int leadingTabOffset = SeaGlassTabbedPaneUI.this.orientation.getPosition(SeaGlassTabbedPaneUI.this.rects[SeaGlassTabbedPaneUI.this.leadingTabIndex]);
            int selectedTabEndOffset = SeaGlassTabbedPaneUI.this.orientation.getPosition(((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[selectedIndex].x + ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[selectedIndex].width, ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[selectedIndex].y + ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[selectedIndex].height);
            if (desiredMaximumLength <= tabAreaLength) {
                SeaGlassTabbedPaneUI.this.leadingTabIndex = 0;
                SeaGlassTabbedPaneUI.this.trailingTabIndex = tabCount - 1;
            } else if (desiredMaximumLength - leadingTabOffset + buttonLength <= tabAreaLength) {
                SeaGlassTabbedPaneUI.this.trailingTabIndex = tabCount - 1;
            } else if (SeaGlassTabbedPaneUI.this.leadingTabIndex == 0 && selectedTabEndOffset - leadingTabOffset + buttonLength <= tabAreaLength || selectedTabEndOffset - leadingTabOffset + 2 * buttonLength <= tabAreaLength) {
                SeaGlassTabbedPaneUI.this.trailingTabIndex = -1;
                for (int i = tabCount - 1; i > selectedIndex; --i) {
                    int end = SeaGlassTabbedPaneUI.this.orientation.getPosition(((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[i].x + ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[i].width, ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[i].y + ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[i].height);
                    if (end - leadingTabOffset + 2 * buttonLength > tabAreaLength) continue;
                    SeaGlassTabbedPaneUI.this.trailingTabIndex = i;
                    break;
                }
                if (SeaGlassTabbedPaneUI.this.trailingTabIndex == -1) {
                    SeaGlassTabbedPaneUI.this.trailingTabIndex = selectedIndex;
                }
            } else {
                SeaGlassTabbedPaneUI.this.trailingTabIndex = selectedIndex;
                SeaGlassTabbedPaneUI.this.leadingTabIndex = -1;
                for (int i = 0; i < selectedIndex; ++i) {
                    int start = SeaGlassTabbedPaneUI.this.orientation.getPosition(SeaGlassTabbedPaneUI.this.rects[i]);
                    if (selectedTabEndOffset - start + 2 * buttonLength > tabAreaLength) continue;
                    SeaGlassTabbedPaneUI.this.leadingTabIndex = i;
                    break;
                }
                if (SeaGlassTabbedPaneUI.this.leadingTabIndex == -1) {
                    SeaGlassTabbedPaneUI.this.leadingTabIndex = selectedIndex;
                }
            }
            ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabRuns[0] = SeaGlassTabbedPaneUI.this.leadingTabIndex;
        }

        private int calcDesiredMaximumLength(int tabCount) {
            FontMetrics metrics = SeaGlassTabbedPaneUI.this.getFontMetrics();
            int fontHeight = metrics.getHeight();
            Insets tabAreaInsets = SeaGlassTabbedPaneUI.this.getTabAreaInsets(fontHeight);
            Point corner = new Point(((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.x + tabAreaInsets.left, ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.y + tabAreaInsets.top);
            int offset = SeaGlassTabbedPaneUI.this.orientation.getOrthogonalOffset(corner);
            int thickness = SeaGlassTabbedPaneUI.this.orientation == ControlOrientation.HORIZONTAL ? SeaGlassTabbedPaneUI.this.maxTabWidth : SeaGlassTabbedPaneUI.this.maxTabHeight;
            int position = 0;
            int maxTabLength = 0;
            for (int i = 0; i < tabCount; ++i) {
                int length = SeaGlassTabbedPaneUI.this.orientation == ControlOrientation.HORIZONTAL ? SeaGlassTabbedPaneUI.this.calculateTabWidth(1, i, metrics) : SeaGlassTabbedPaneUI.this.calculateTabHeight(2, i, fontHeight);
                SeaGlassTabbedPaneUI.this.rects[i].setBounds(SeaGlassTabbedPaneUI.this.orientation.createBounds(position, offset, length, thickness));
                maxTabLength = Math.max(maxTabLength, length);
                position += length;
            }
            if (SeaGlassTabbedPaneUI.this.orientation == ControlOrientation.HORIZONTAL) {
                SeaGlassTabbedPaneUI.this.maxTabWidth = maxTabLength;
            } else {
                SeaGlassTabbedPaneUI.this.maxTabHeight = maxTabLength;
            }
            return position;
        }

        private void resetTabPositionsToLeadingTabIndex(int tabCount) {
            int leadingTabPosition = SeaGlassTabbedPaneUI.this.orientation.getPosition(SeaGlassTabbedPaneUI.this.rects[SeaGlassTabbedPaneUI.this.leadingTabIndex]);
            for (int i = 0; i < tabCount; ++i) {
                if (i < SeaGlassTabbedPaneUI.this.leadingTabIndex || i > SeaGlassTabbedPaneUI.this.trailingTabIndex) {
                    SeaGlassTabbedPaneUI.this.rects[i].setBounds(-1, -1, 0, 0);
                    continue;
                }
                SeaGlassTabbedPaneUI.this.orientation.updateBoundsPosition(SeaGlassTabbedPaneUI.this.rects[i], SeaGlassTabbedPaneUI.this.orientation.getPosition(SeaGlassTabbedPaneUI.this.rects[i]) - leadingTabPosition);
            }
        }

        private void centerTabs(int tabCount, int totalLength, int tabAreaLength) {
            Insets tabAreaInsets = SeaGlassTabbedPaneUI.this.getTabAreaInsets(SeaGlassTabbedPaneUI.this.tabPlacement);
            Point corner = new Point(((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.x + tabAreaInsets.left, ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.y + tabAreaInsets.top);
            int startPosition = SeaGlassTabbedPaneUI.this.orientation.getPosition(corner);
            int offset = SeaGlassTabbedPaneUI.this.orientation.getOrthogonalOffset(corner);
            int thickness = SeaGlassTabbedPaneUI.this.orientation == ControlOrientation.HORIZONTAL ? SeaGlassTabbedPaneUI.this.maxTabHeight : SeaGlassTabbedPaneUI.this.maxTabWidth;
            int delta = -(tabAreaLength - totalLength) / 2 - startPosition;
            for (int i = SeaGlassTabbedPaneUI.this.leadingTabIndex; i <= SeaGlassTabbedPaneUI.this.trailingTabIndex; ++i) {
                int position = SeaGlassTabbedPaneUI.this.orientation.getPosition(SeaGlassTabbedPaneUI.this.rects[i]) - delta;
                int length = SeaGlassTabbedPaneUI.this.orientation.getLength(SeaGlassTabbedPaneUI.this.rects[i]);
                SeaGlassTabbedPaneUI.this.rects[i].setBounds(SeaGlassTabbedPaneUI.this.orientation.createBounds(position, offset, length, thickness));
            }
        }

        private void resizeTabs(int tabCount, int totalLength, int buttonLength, int tabAreaLength) {
            if (SeaGlassTabbedPaneUI.this.leadingTabIndex > 0) {
                tabAreaLength -= buttonLength;
            }
            if (SeaGlassTabbedPaneUI.this.trailingTabIndex < tabCount - 1) {
                tabAreaLength -= buttonLength;
            }
            Insets tabAreaInsets = SeaGlassTabbedPaneUI.this.getTabAreaInsets(SeaGlassTabbedPaneUI.this.tabPlacement);
            Point corner = new Point(((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.x + tabAreaInsets.left, ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).tabAreaRect.y + tabAreaInsets.top);
            int startPosition = SeaGlassTabbedPaneUI.this.orientation.getPosition(corner);
            int offset = SeaGlassTabbedPaneUI.this.orientation.getOrthogonalOffset(corner);
            int thickness = SeaGlassTabbedPaneUI.this.orientation == ControlOrientation.HORIZONTAL ? SeaGlassTabbedPaneUI.this.maxTabHeight : SeaGlassTabbedPaneUI.this.maxTabWidth;
            float multiplier = (float)tabAreaLength / (float)totalLength;
            for (int i = SeaGlassTabbedPaneUI.this.leadingTabIndex; i <= SeaGlassTabbedPaneUI.this.trailingTabIndex; ++i) {
                int position = i == SeaGlassTabbedPaneUI.this.leadingTabIndex ? startPosition + (SeaGlassTabbedPaneUI.this.leadingTabIndex > 0 ? buttonLength : 0) : SeaGlassTabbedPaneUI.this.orientation.getPosition(SeaGlassTabbedPaneUI.this.rects[i - 1]) + SeaGlassTabbedPaneUI.this.orientation.getLength(SeaGlassTabbedPaneUI.this.rects[i - 1]);
                int length = (int)((float)SeaGlassTabbedPaneUI.this.orientation.getLength(SeaGlassTabbedPaneUI.this.rects[i]) * multiplier);
                SeaGlassTabbedPaneUI.this.rects[i].setBounds(SeaGlassTabbedPaneUI.this.orientation.createBounds(position, offset, length, thickness));
            }
        }

        private void setScrollButtonPositions(Component child, boolean visible, int position) {
            if (visible) {
                child.setBounds(SeaGlassTabbedPaneUI.this.orientation.createBounds(position, SeaGlassTabbedPaneUI.this.orientation.getOrthogonalOffset(SeaGlassTabbedPaneUI.this.rects[SeaGlassTabbedPaneUI.this.leadingTabIndex]), SeaGlassTabbedPaneUI.this.orientation.getLength(child.getPreferredSize()), SeaGlassTabbedPaneUI.this.orientation.getThickness(SeaGlassTabbedPaneUI.this.rects[SeaGlassTabbedPaneUI.this.leadingTabIndex])));
            }
            child.setEnabled(SeaGlassTabbedPaneUI.this.tabPane.isEnabled());
            child.setVisible(visible);
        }

        private void flipRightToLeft(int tabCount, Dimension size) {
            int rightMargin = size.width;
            for (int i = 0; i < tabCount; ++i) {
                ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[i].x = rightMargin - ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[i].x - ((SeaGlassTabbedPaneUI)SeaGlassTabbedPaneUI.this).rects[i].width;
            }
            if (SeaGlassTabbedPaneUI.this.scrollBackwardButton.isVisible()) {
                Rectangle b = SeaGlassTabbedPaneUI.this.scrollBackwardButton.getBounds();
                SeaGlassTabbedPaneUI.this.scrollBackwardButton.setLocation(rightMargin - b.x - b.width, b.y);
            }
            if (SeaGlassTabbedPaneUI.this.scrollForwardButton.isVisible()) {
                Rectangle b = SeaGlassTabbedPaneUI.this.scrollForwardButton.getBounds();
                SeaGlassTabbedPaneUI.this.scrollForwardButton.setLocation(rightMargin - b.x - b.width, b.y);
            }
        }

        private Component findFocusOwner(Component visibleComponent) {
            Component focusOwner;
            Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            while (temp != null) {
                if (temp == visibleComponent) {
                    return focusOwner;
                }
                temp = temp instanceof Window ? null : temp.getParent();
            }
            return null;
        }
    }

    private class SynthScrollableTabButton
    extends SeaGlassArrowButton
    implements UIResource {
        private static final long serialVersionUID = -3983149584304630486L;

        public SynthScrollableTabButton(int direction) {
            super(direction);
            this.putClientProperty("__arrow_scale__", 0.6);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(20, 20);
        }
    }
}

