/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.component.SeaGlassSplitPaneDivider;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class SeaGlassSplitPaneUI
extends BasicSplitPaneUI
implements PropertyChangeListener,
SeaglassUI {
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    private SynthStyle style;
    private SynthStyle dividerStyle;

    public static ComponentUI createUI(JComponent x) {
        return new SeaGlassSplitPaneUI();
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.splitPane);
        this.setOrientation(this.splitPane.getOrientation());
        this.setContinuousLayout(this.splitPane.isContinuousLayout());
        this.resetLayoutManager();
        if (this.nonContinuousLayoutDivider == null) {
            this.setNonContinuousLayoutDivider(this.createDefaultNonContinuousLayoutDivider(), true);
        } else {
            this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
        }
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new HashSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        }
        this.splitPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new HashSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        }
        this.splitPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
    }

    private void updateStyle(JSplitPane splitPane) {
        SeaGlassContext context = this.getContext(splitPane, Region.SPLIT_PANE_DIVIDER, 1);
        SynthStyle oldDividerStyle = this.dividerStyle;
        this.dividerStyle = SeaGlassLookAndFeel.updateStyle(context, this);
        context.dispose();
        context = this.getContext((JComponent)splitPane, 1);
        SynthStyle oldStyle = this.style;
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            Object value = this.style.get(context, "SplitPane.size");
            if (value == null) {
                value = new Integer(6);
            }
            LookAndFeel.installProperty(splitPane, "dividerSize", value);
            value = this.style.get(context, "SplitPane.oneTouchExpandable");
            if (value != null) {
                LookAndFeel.installProperty(splitPane, "oneTouchExpandable", value);
            }
            if (this.divider != null) {
                splitPane.remove(this.divider);
                this.divider.setDividerSize(splitPane.getDividerSize());
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        if (this.style != oldStyle || this.dividerStyle != oldDividerStyle) {
            if (this.divider != null) {
                splitPane.remove(this.divider);
            }
            this.divider = this.createDefaultDivider();
            this.divider.setBasicSplitPaneUI(this);
            splitPane.add((Component)this.divider, "divider");
        }
        context.dispose();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.splitPane.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallDefaults() {
        SeaGlassContext context = this.getContext((JComponent)this.splitPane, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        context = this.getContext(this.splitPane, Region.SPLIT_PANE_DIVIDER, 1);
        this.dividerStyle.uninstallDefaults(context);
        context.dispose();
        this.dividerStyle = null;
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.splitPane.removePropertyChangeListener(this);
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    public SeaGlassContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SeaGlassContext getContext(JComponent c, Region region, int state) {
        if (region == Region.SPLIT_PANE_DIVIDER) {
            return SeaGlassContext.getContext(SeaGlassContext.class, c, region, this.dividerStyle, state);
        }
        return SeaGlassContext.getContext(SeaGlassContext.class, c, region, this.style, state);
    }

    private int getComponentState(JComponent c, Region subregion) {
        int state = SeaGlassLookAndFeel.getComponentState(c);
        if (this.divider.isMouseOver()) {
            state |= 2;
        }
        return state;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JSplitPane)e.getSource());
        }
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        SeaGlassSplitPaneDivider divider = new SeaGlassSplitPaneDivider(this);
        divider.setDividerSize(this.splitPane.getDividerSize());
        return divider;
    }

    @Override
    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            @Override
            public void paint(Graphics g) {
                SeaGlassSplitPaneUI.this.paintDragDivider(g, 0, 0, this.getWidth(), this.getHeight());
            }
        };
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintSplitPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
        super.paint(g, this.splitPane);
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintSplitPaneBorder(context, g, x, y, w, h);
    }

    private void paintDragDivider(Graphics g, int x, int y, int w, int h) {
        SeaGlassContext context = this.getContext((JComponent)this.splitPane, Region.SPLIT_PANE_DIVIDER);
        context.setComponentState((context.getComponentState() | 2) ^ 2 | 4);
        Shape oldClip = g.getClip();
        g.clipRect(x, y, w, h);
        context.getPainter().paintSplitPaneDragDivider(context, g, x, y, w, h, this.splitPane.getOrientation());
        g.setClip(oldClip);
        context.dispose();
    }

    @Override
    public void finishedPaintingChildren(JSplitPane jc, Graphics g) {
        if (jc == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            if (jc.getOrientation() == 1) {
                this.paintDragDivider(g, this.getLastDragLocation(), 0, this.dividerSize - 1, this.splitPane.getHeight() - 1);
            } else {
                this.paintDragDivider(g, 0, this.getLastDragLocation(), this.splitPane.getWidth() - 1, this.dividerSize - 1);
            }
        }
    }
}

