/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.ui.SeaglassUI;
import com.seaglasslookandfeel.util.SeaGlassGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;

public class SeaGlassSliderUI
extends BasicSliderUI
implements PropertyChangeListener,
SeaglassUI {
    protected Dimension contentDim = new Dimension();
    protected Rectangle valueRect = new Rectangle();
    protected boolean paintValue;
    private Dimension lastSize = null;
    private int trackHeight;
    private int trackHeightHack;
    private int trackBorder;
    private int thumbWidth;
    private int thumbHeight;
    private SynthStyle style;
    private SynthStyle sliderTrackStyle;
    private SynthStyle sliderThumbStyle;
    private transient boolean thumbActive;
    private transient boolean thumbPressed;

    public static ComponentUI createUI(JComponent c) {
        return new SeaGlassSliderUI((JSlider)c);
    }

    public SeaGlassSliderUI(JSlider c) {
        super(c);
    }

    @Override
    protected void installDefaults(JSlider slider) {
        this.updateStyle(slider);
    }

    protected void uninstallDefaults() {
        SeaGlassContext context = this.getContext((JComponent)this.slider, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        context = this.getContext(this.slider, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle.uninstallDefaults(context);
        context.dispose();
        this.sliderTrackStyle = null;
        context = this.getContext(this.slider, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle.uninstallDefaults(context);
        context.dispose();
        this.sliderThumbStyle = null;
    }

    @Override
    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        slider.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        slider.removePropertyChangeListener(this);
        super.uninstallListeners(slider);
    }

    private void updateStyle(JSlider c) {
        SeaGlassContext context = this.getContext((JComponent)c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.thumbWidth = this.style.getInt(context, "Slider.thumbWidth", 30);
            this.thumbHeight = this.style.getInt(context, "Slider.thumbHeight", 14);
            this.trackHeightHack = this.style.getInt(context, "Slider.trackHeight", 5);
            String scaleKey = SeaGlassStyle.getSizeVariant(this.slider);
            if (scaleKey != null) {
                if ("large".equals(scaleKey)) {
                    this.thumbWidth = (int)((double)this.thumbWidth * 1.15);
                    this.thumbHeight = (int)((double)this.thumbHeight * 1.15);
                    this.trackHeightHack = 7;
                } else if ("small".equals(scaleKey)) {
                    this.thumbWidth = (int)((double)this.thumbWidth * 0.857);
                    this.thumbHeight = (int)((double)this.thumbHeight * 0.857);
                    this.trackHeightHack = 3;
                } else if ("mini".equals(scaleKey)) {
                    this.thumbWidth = (int)((double)this.thumbWidth * 0.784);
                    this.thumbHeight = (int)((double)this.thumbHeight * 0.784);
                    this.trackHeightHack = 3;
                }
            }
            this.trackBorder = this.style.getInt(context, "Slider.trackBorder", 1);
            this.trackHeight = this.thumbHeight + this.trackBorder * 2;
            this.paintValue = this.style.getBoolean(context, "Slider.paintValue", true);
            if (oldStyle != null) {
                this.uninstallKeyboardActions(c);
                this.installKeyboardActions(c);
            }
        }
        context.dispose();
        context = this.getContext(c, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle = SeaGlassLookAndFeel.updateStyle(context, this);
        context.dispose();
        context = this.getContext(c, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle = SeaGlassLookAndFeel.updateStyle(context, this);
        context.dispose();
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider s) {
        return new SynthTrackListener();
    }

    private void updateThumbState(int x, int y) {
        this.setThumbActive(this.thumbRect.contains(x, y));
    }

    private void updateThumbState(int x, int y, boolean pressed) {
        this.updateThumbState(x, y);
        this.setThumbPressed(pressed);
    }

    private void setThumbActive(boolean active) {
        if (this.thumbActive != active) {
            this.thumbActive = active;
            this.slider.repaint(this.thumbRect);
        }
    }

    private void setThumbPressed(boolean pressed) {
        if (this.thumbPressed != pressed) {
            this.thumbPressed = pressed;
            this.slider.repaint(this.thumbRect);
        }
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        if (c == null) {
            throw new NullPointerException("Component must be non-null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Width and height must be >= 0");
        }
        if (this.slider.getPaintLabels() && this.labelsHaveSameBaselines()) {
            Integer value;
            Insets trackInsets = new Insets(0, 0, 0, 0);
            SeaGlassContext trackContext = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
            this.style.getInsets(trackContext, trackInsets);
            trackContext.dispose();
            if (this.slider.getOrientation() == 0) {
                int valueHeight = 0;
                if (this.paintValue) {
                    SeaGlassContext context = this.getContext(this.slider);
                    valueHeight = context.getStyle().getGraphicsUtils(context).getMaximumCharHeight(context);
                    context.dispose();
                }
                int tickHeight = 0;
                if (this.slider.getPaintTicks()) {
                    tickHeight = this.getTickLength();
                }
                int labelHeight = this.getHeightOfTallestLabel();
                int contentHeight = valueHeight + this.trackHeight + trackInsets.top + trackInsets.bottom + tickHeight + labelHeight + 4;
                int centerY = height / 2 - contentHeight / 2;
                centerY += valueHeight + 2;
                centerY += this.trackHeight + trackInsets.top + trackInsets.bottom;
                Component label = (Component)this.slider.getLabelTable().elements().nextElement();
                Dimension pref = label.getPreferredSize();
                return (centerY += tickHeight + 2) + label.getBaseline(pref.width, pref.height);
            }
            Integer n = value = this.slider.getInverted() ? this.getLowestValue() : this.getHighestValue();
            if (value != null) {
                int valueY = this.insetCache.top;
                int valueHeight = 0;
                if (this.paintValue) {
                    SeaGlassContext context = this.getContext(this.slider);
                    valueHeight = context.getStyle().getGraphicsUtils(context).getMaximumCharHeight(context);
                    context.dispose();
                }
                int contentHeight = height - this.insetCache.top - this.insetCache.bottom;
                int trackY = valueY + valueHeight;
                int trackHeight = contentHeight - valueHeight;
                int yPosition = this.yPositionForValue(value, trackY, trackHeight);
                Component label = (Component)this.slider.getLabelTable().get(value);
                Dimension pref = label.getPreferredSize();
                return yPosition - pref.height / 2 + label.getBaseline(pref.width, pref.height);
            }
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        this.recalculateIfInsetsChanged();
        Dimension d = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            d.height = 200;
        } else {
            d.width = 200;
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        this.recalculateIfInsetsChanged();
        Dimension d = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            d.height = this.thumbRect.height + this.insetCache.top + this.insetCache.bottom;
        } else {
            d.width = this.thumbRect.width + this.insetCache.left + this.insetCache.right;
        }
        return d;
    }

    @Override
    protected void calculateGeometry() {
        this.layout();
        this.calculateThumbLocation();
    }

    protected void layout() {
        SeaGlassContext context = this.getContext(this.slider);
        SynthGraphicsUtils synthGraphics = this.style.getGraphicsUtils(context);
        Dimension size = this.getThumbSize();
        this.thumbRect.setSize(size.width, size.height);
        Insets trackInsets = new Insets(0, 0, 0, 0);
        SeaGlassContext trackContext = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
        this.style.getInsets(trackContext, trackInsets);
        trackContext.dispose();
        if (this.slider.getOrientation() == 0) {
            int centerY;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphics.getMaximumCharHeight(context);
            }
            this.trackRect.height = this.trackHeight;
            this.tickRect.height = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.height = this.getTickLength();
            }
            this.labelRect.height = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.height = this.getHeightOfTallestLabel();
            }
            this.contentDim.height = this.valueRect.height + this.trackRect.height + trackInsets.top + trackInsets.bottom + this.tickRect.height + this.labelRect.height + 4;
            this.contentDim.width = this.slider.getWidth() - this.insetCache.left - this.insetCache.right;
            int pad = 0;
            if (this.slider.getPaintLabels()) {
                this.trackRect.x = this.insetCache.left;
                this.trackRect.width = this.contentDim.width;
                Dictionary dictionary = this.slider.getLabelTable();
                if (dictionary != null) {
                    int minValue = this.slider.getMinimum();
                    int maxValue = this.slider.getMaximum();
                    int firstLblIdx = Integer.MAX_VALUE;
                    int lastLblIdx = Integer.MIN_VALUE;
                    Enumeration keys = dictionary.keys();
                    while (keys.hasMoreElements()) {
                        int keyInt = (Integer)keys.nextElement();
                        if (keyInt >= minValue && keyInt < firstLblIdx) {
                            firstLblIdx = keyInt;
                        }
                        if (keyInt > maxValue || keyInt <= lastLblIdx) continue;
                        lastLblIdx = keyInt;
                    }
                    pad = this.getPadForLabel(firstLblIdx);
                    pad = Math.max(pad, this.getPadForLabel(lastLblIdx));
                }
            }
            this.tickRect.x = this.labelRect.x = this.insetCache.left + pad;
            this.trackRect.x = this.labelRect.x;
            this.valueRect.x = this.labelRect.x;
            this.tickRect.width = this.labelRect.width = this.contentDim.width - pad * 2;
            this.trackRect.width = this.labelRect.width;
            this.valueRect.width = this.labelRect.width;
            this.valueRect.y = centerY = this.slider.getHeight() / 2 - this.contentDim.height / 2;
            this.trackRect.y = (centerY += this.valueRect.height + 2) + trackInsets.top;
            this.tickRect.y = centerY += this.trackRect.height + trackInsets.top + trackInsets.bottom;
            this.labelRect.y = centerY += this.tickRect.height + 2;
            centerY += this.labelRect.height;
        } else {
            this.trackRect.width = this.trackHeight;
            this.tickRect.width = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.width = this.getTickLength();
            }
            this.labelRect.width = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.width = this.getWidthOfWidestLabel();
            }
            this.valueRect.y = this.insetCache.top;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphics.getMaximumCharHeight(context);
            }
            FontMetrics fm = this.slider.getFontMetrics(this.slider.getFont());
            this.valueRect.width = Math.max(synthGraphics.computeStringWidth(context, this.slider.getFont(), fm, "" + this.slider.getMaximum()), synthGraphics.computeStringWidth(context, this.slider.getFont(), fm, "" + this.slider.getMinimum()));
            int l = this.valueRect.width / 2;
            int w1 = trackInsets.left + this.trackRect.width / 2;
            int w2 = this.trackRect.width / 2 + trackInsets.right + this.tickRect.width + this.labelRect.width;
            this.contentDim.width = Math.max(w1, l) + Math.max(w2, l) + 2 + this.insetCache.left + this.insetCache.right;
            this.contentDim.height = this.slider.getHeight() - this.insetCache.top - this.insetCache.bottom;
            this.tickRect.y = this.labelRect.y = this.valueRect.y + this.valueRect.height;
            this.trackRect.y = this.labelRect.y;
            this.tickRect.height = this.labelRect.height = this.contentDim.height - this.valueRect.height;
            this.trackRect.height = this.labelRect.height;
            int startX = this.slider.getWidth() / 2 - this.contentDim.width / 2;
            if (SeaGlassLookAndFeel.isLeftToRight(this.slider)) {
                if (l > w1) {
                    startX += l - w1;
                }
                this.trackRect.x = startX + trackInsets.left;
                this.tickRect.x = startX += trackInsets.left + this.trackRect.width + trackInsets.right;
                this.labelRect.x = startX + this.tickRect.width + 2;
            } else {
                if (l > w2) {
                    startX += l - w2;
                }
                this.labelRect.x = startX;
                this.tickRect.x = startX += this.labelRect.width + 2;
                this.trackRect.x = startX + this.tickRect.width + trackInsets.left;
            }
        }
        context.dispose();
        this.lastSize = this.slider.getSize();
    }

    private int getPadForLabel(int i) {
        Dictionary dictionary = this.slider.getLabelTable();
        int pad = 0;
        Object o = dictionary.get(i);
        if (o != null) {
            int cHalfWidth;
            Component c = (Component)o;
            int centerX = this.xPositionForValue(i);
            if (centerX - (cHalfWidth = c.getPreferredSize().width / 2) < this.insetCache.left) {
                pad = Math.max(pad, this.insetCache.left - (centerX - cHalfWidth));
            }
            if (centerX + cHalfWidth > this.slider.getWidth() - this.insetCache.right) {
                pad = Math.max(pad, centerX + cHalfWidth - (this.slider.getWidth() - this.insetCache.right));
            }
        }
        return pad;
    }

    @Override
    protected void calculateThumbLocation() {
        int valuePosition;
        if (this.slider.getSnapToTicks()) {
            int sliderValue;
            int snappedValue = sliderValue = this.slider.getValue();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((sliderValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(sliderValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != sliderValue) {
                    this.slider.setValue(snappedValue);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            valuePosition = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y + this.trackBorder;
        } else {
            valuePosition = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x + this.trackBorder;
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
        Point mousePosition = this.slider.getMousePosition();
        if (mousePosition != null) {
            this.updateThumbState(mousePosition.x, mousePosition.y);
        }
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height + 2 + this.getTickLength();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            if (SeaGlassLookAndFeel.isLeftToRight(this.slider)) {
                this.tickRect.x = this.trackRect.x + this.trackRect.width;
                this.tickRect.width = this.getTickLength();
            } else {
                this.tickRect.width = this.getTickLength();
                this.tickRect.x = this.trackRect.x - this.tickRect.width;
            }
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    @Override
    public void setThumbLocation(int x, int y) {
        super.setThumbLocation(x, y);
        this.slider.repaint(this.valueRect.x, this.valueRect.y, this.valueRect.width, this.valueRect.height);
        this.setThumbActive(false);
    }

    @Override
    protected int xPositionForValue(int value) {
        int xPosition;
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int trackLeft = this.trackRect.x + this.thumbRect.width / 2 + this.trackBorder;
        int trackRight = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - this.trackBorder;
        int trackLength = trackRight - trackLeft;
        double valueRange = (double)max - (double)min;
        double pixelsPerValue = (double)trackLength / valueRange;
        if (!this.drawInverted()) {
            xPosition = trackLeft;
            xPosition = (int)((long)xPosition + Math.round(pixelsPerValue * ((double)value - (double)min)));
        } else {
            xPosition = trackRight;
            xPosition = (int)((long)xPosition - Math.round(pixelsPerValue * ((double)value - (double)min)));
        }
        xPosition = Math.max(trackLeft, xPosition);
        xPosition = Math.min(trackRight, xPosition);
        return xPosition;
    }

    @Override
    protected int yPositionForValue(int value, int trackY, int trackHeight) {
        int yPosition;
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int trackTop = trackY + this.thumbRect.height / 2 + this.trackBorder;
        int trackBottom = trackY + trackHeight - this.thumbRect.height / 2 - this.trackBorder;
        int trackLength = trackBottom - trackTop;
        double valueRange = (double)max - (double)min;
        double pixelsPerValue = (double)trackLength / valueRange;
        if (!this.drawInverted()) {
            yPosition = trackTop;
            yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * ((double)max - (double)value)));
        } else {
            yPosition = trackTop;
            yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * ((double)value - (double)min)));
        }
        yPosition = Math.max(trackTop, yPosition);
        yPosition = Math.min(trackBottom, yPosition);
        return yPosition;
    }

    @Override
    public int valueForYPosition(int yPos) {
        int value;
        int minValue = this.slider.getMinimum();
        int maxValue = this.slider.getMaximum();
        int trackTop = this.trackRect.y + this.thumbRect.height / 2 + this.trackBorder;
        int trackBottom = this.trackRect.y + this.trackRect.height - this.thumbRect.height / 2 - this.trackBorder;
        int trackLength = trackBottom - trackTop;
        if (yPos <= trackTop) {
            value = this.drawInverted() ? minValue : maxValue;
        } else if (yPos >= trackBottom) {
            value = this.drawInverted() ? maxValue : minValue;
        } else {
            int distanceFromTrackTop = yPos - trackTop;
            double valueRange = (double)maxValue - (double)minValue;
            double valuePerPixel = valueRange / (double)trackLength;
            int valueFromTrackTop = (int)Math.round((double)distanceFromTrackTop * valuePerPixel);
            value = this.drawInverted() ? minValue + valueFromTrackTop : maxValue - valueFromTrackTop;
        }
        return value;
    }

    @Override
    public int valueForXPosition(int xPos) {
        int value;
        int minValue = this.slider.getMinimum();
        int maxValue = this.slider.getMaximum();
        int trackLeft = this.trackRect.x + this.thumbRect.width / 2 + this.trackBorder;
        int trackRight = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - this.trackBorder;
        int trackLength = trackRight - trackLeft;
        if (xPos <= trackLeft) {
            value = this.drawInverted() ? maxValue : minValue;
        } else if (xPos >= trackRight) {
            value = this.drawInverted() ? minValue : maxValue;
        } else {
            int distanceFromTrackLeft = xPos - trackLeft;
            double valueRange = (double)maxValue - (double)minValue;
            double valuePerPixel = valueRange / (double)trackLength;
            int valueFromTrackLeft = (int)Math.round((double)distanceFromTrackLeft * valuePerPixel);
            value = this.drawInverted() ? maxValue - valueFromTrackLeft : minValue + valueFromTrackLeft;
        }
        return value;
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = this.thumbHeight;
            size.height = this.thumbWidth;
        } else {
            size.width = this.thumbWidth;
            size.height = this.thumbHeight;
        }
        return size;
    }

    @Override
    protected void recalculateIfInsetsChanged() {
        SeaGlassContext context = this.getContext(this.slider);
        Insets newInsets = this.style.getInsets(context, null);
        if (!newInsets.equals(this.insetCache)) {
            this.insetCache = newInsets;
            this.calculateGeometry();
        }
        context.dispose();
    }

    public Region getRegion(JComponent c) {
        return SeaGlassLookAndFeel.getRegion(c);
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    public SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    public SeaGlassContext getContext(JComponent c, Region subregion) {
        return this.getContext(c, subregion, this.getComponentState(c, subregion));
    }

    private SeaGlassContext getContext(JComponent c, Region subregion, int state) {
        SynthStyle style = null;
        Class<SeaGlassContext> klass = SeaGlassContext.class;
        if (subregion == Region.SLIDER_TRACK) {
            style = this.sliderTrackStyle;
        } else if (subregion == Region.SLIDER_THUMB) {
            style = this.sliderThumbStyle;
        }
        return SeaGlassContext.getContext(klass, c, subregion, style, state);
    }

    public int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    private int getComponentState(JComponent c, Region region) {
        if (region == Region.SLIDER_THUMB && this.thumbActive && c.isEnabled()) {
            int state;
            int n = state = this.thumbPressed ? 4 : 2;
            if (c.isFocusOwner()) {
                state |= 0x100;
            }
            return state;
        }
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintSliderBackground(context, g, 0, 0, c.getWidth(), c.getHeight(), this.slider.getOrientation());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    public void paint(SeaGlassContext context, Graphics g) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle clip = g.getClipBounds();
        if (this.lastSize == null || !this.lastSize.equals(this.slider.getSize())) {
            this.calculateGeometry();
        }
        if (this.paintValue) {
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)this.slider, g);
            int labelWidth = context.getStyle().getGraphicsUtils(context).computeStringWidth(context, g.getFont(), fm, "" + this.slider.getValue());
            this.valueRect.x = this.thumbRect.x + (this.thumbRect.width - labelWidth) / 2;
            if (this.slider.getOrientation() == 0) {
                if (this.valueRect.x + labelWidth > this.contentDim.width) {
                    this.valueRect.x = this.contentDim.width - labelWidth;
                }
                this.valueRect.x = Math.max(this.valueRect.x, 0);
            }
            g.setColor(context.getStyle().getColor(context, ColorType.TEXT_FOREGROUND));
            context.getStyle().getGraphicsUtils(context).paintText(context, g, "" + this.slider.getValue(), this.valueRect.x, this.valueRect.y, -1);
        }
        SeaGlassContext subcontext = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
        this.paintTrack(subcontext, g, this.trackRect);
        subcontext.dispose();
        subcontext = this.getContext((JComponent)this.slider, Region.SLIDER_THUMB);
        this.paintThumb(subcontext, g, this.thumbRect);
        subcontext.dispose();
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        this.setTickColor(g);
        super.paintMajorTickForHorizSlider(g, tickBounds, x);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        this.setTickColor(g);
        super.paintMajorTickForVertSlider(g, tickBounds, y);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        this.setTickColor(g);
        super.paintMinorTickForHorizSlider(g, tickBounds, x);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        this.setTickColor(g);
        super.paintMinorTickForVertSlider(g, tickBounds, y);
    }

    private void setTickColor(Graphics g) {
        if (!this.slider.isEnabled()) {
            g.setColor(SeaGlassGraphicsUtils.disable(DefaultLookup.getColor(this.slider, this, "Slider.tickColor", Color.black)));
        }
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintSliderBorder(context, g, x, y, w, h, this.slider.getOrientation());
    }

    public void paintThumb(SeaGlassContext context, Graphics g, Rectangle thumbBounds) {
        int orientation = this.slider.getOrientation();
        SeaGlassLookAndFeel.updateSubregion(context, g, thumbBounds);
        context.getPainter().paintSliderThumbBackground(context, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, orientation);
        context.getPainter().paintSliderThumbBorder(context, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, orientation);
    }

    public void paintTrack(SeaGlassContext context, Graphics g, Rectangle trackBounds) {
        int orientation = this.slider.getOrientation();
        SeaGlassLookAndFeel.updateSubregion(context, g, trackBounds);
        int x = trackBounds.x;
        int y = trackBounds.y;
        int height = trackBounds.height;
        int width = trackBounds.width;
        if (orientation == 0) {
            height = Math.min(height, this.trackHeightHack);
            y += (trackBounds.height - height) / 2;
        } else {
            width = Math.min(width, this.trackHeightHack);
            x += (trackBounds.width - width) / 2;
        }
        context.getPainter().paintSliderTrackBackground(context, g, x, y, width, height, orientation);
        context.getPainter().paintSliderTrackBorder(context, g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, orientation);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JSlider)e.getSource());
        }
    }

    protected class SynthTrackListener
    extends BasicSliderUI.TrackListener {
        protected SynthTrackListener() {
            super(SeaGlassSliderUI.this);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SeaGlassSliderUI.this.setThumbActive(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            SeaGlassSliderUI.this.setThumbPressed(SeaGlassSliderUI.this.thumbRect.contains(e.getX(), e.getY()));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            SeaGlassSliderUI.this.updateThumbState(e.getX(), e.getY(), false);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int thumbMiddle = 0;
            if (!SeaGlassSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (!SeaGlassSliderUI.this.isDragging()) {
                return;
            }
            SeaGlassSliderUI.this.slider.setValueIsAdjusting(true);
            switch (SeaGlassSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((SeaGlassSliderUI)SeaGlassSliderUI.this).thumbRect.height / 2;
                    int thumbTop = e.getY() - this.offset;
                    int trackTop = ((SeaGlassSliderUI)SeaGlassSliderUI.this).trackRect.y;
                    int trackBottom = ((SeaGlassSliderUI)SeaGlassSliderUI.this).trackRect.y + ((SeaGlassSliderUI)SeaGlassSliderUI.this).trackRect.height - halfThumbHeight - SeaGlassSliderUI.this.trackBorder;
                    int vMax = SeaGlassSliderUI.this.yPositionForValue(SeaGlassSliderUI.this.slider.getMaximum() - SeaGlassSliderUI.this.slider.getExtent());
                    if (SeaGlassSliderUI.this.drawInverted()) {
                        trackBottom = vMax;
                        trackTop += halfThumbHeight;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    SeaGlassSliderUI.this.setThumbLocation(((SeaGlassSliderUI)SeaGlassSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    SeaGlassSliderUI.this.slider.setValue(SeaGlassSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((SeaGlassSliderUI)SeaGlassSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = e.getX() - this.offset;
                    int trackLeft = ((SeaGlassSliderUI)SeaGlassSliderUI.this).trackRect.x + halfThumbWidth + SeaGlassSliderUI.this.trackBorder;
                    int trackRight = ((SeaGlassSliderUI)SeaGlassSliderUI.this).trackRect.x + ((SeaGlassSliderUI)SeaGlassSliderUI.this).trackRect.width - halfThumbWidth - SeaGlassSliderUI.this.trackBorder;
                    int hMax = SeaGlassSliderUI.this.xPositionForValue(SeaGlassSliderUI.this.slider.getMaximum() - SeaGlassSliderUI.this.slider.getExtent());
                    if (SeaGlassSliderUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    SeaGlassSliderUI.this.setThumbLocation(thumbLeft, ((SeaGlassSliderUI)SeaGlassSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    SeaGlassSliderUI.this.slider.setValue(SeaGlassSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
                default: {
                    return;
                }
            }
            if (SeaGlassSliderUI.this.slider.getValueIsAdjusting()) {
                SeaGlassSliderUI.this.setThumbActive(true);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SeaGlassSliderUI.this.updateThumbState(e.getX(), e.getY());
        }
    }
}

