/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.painter.SeaGlassPainter;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.JTextComponent;

public class SeaGlassScrollPaneUI
extends BasicScrollPaneUI
implements PropertyChangeListener,
ScrollPaneConstants,
SeaglassUI {
    private MouseWheelListener mouseScrollListener;
    private SynthStyle style;
    private boolean viewportViewHasFocus = false;
    private ViewportViewFocusHandler viewportViewFocusHandler;
    private PropertyChangeListener vsbPropertyChangeListener;
    private PropertyChangeListener hsbPropertyChangeListener;
    private Handler handler;
    private SeaGlassPainter cornerPainter;
    private boolean setValueCalled = false;

    public static ComponentUI createUI(JComponent x) {
        return new SeaGlassScrollPaneUI();
    }

    @Override
    protected void installDefaults(JScrollPane scrollpane) {
        Object obj;
        LookAndFeel.installBorder(scrollpane, "ScrollPane.border");
        LookAndFeel.installColorsAndFont(scrollpane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        Border vpBorder = scrollpane.getViewportBorder();
        if (vpBorder == null || vpBorder instanceof UIResource) {
            vpBorder = UIManager.getBorder("ScrollPane.viewportBorder");
            scrollpane.setViewportBorder(vpBorder);
        }
        if ((obj = UIManager.get("ScrollPane.cornerPainter")) != null && obj instanceof SeaGlassPainter) {
            this.cornerPainter = (SeaGlassPainter)obj;
        }
        LookAndFeel.installProperty(scrollpane, "opaque", Boolean.TRUE);
        this.updateStyle(scrollpane);
    }

    @Override
    protected void uninstallDefaults(JScrollPane c) {
        SeaGlassContext context = this.getContext(c, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    private void updateStyle(JScrollPane c) {
        SeaGlassContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            Border vpBorder = this.scrollpane.getViewportBorder();
            if (vpBorder == null || vpBorder instanceof UIResource) {
                this.scrollpane.setViewportBorder(new ViewportBorder(context));
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions(c);
                this.installKeyboardActions(c);
            }
        }
        context.dispose();
    }

    @Override
    protected void installListeners(JScrollPane c) {
        this.vsbChangeListener = this.createVSBChangeListener();
        this.vsbPropertyChangeListener = this.createVSBPropertyChangeListener();
        this.hsbChangeListener = this.createHSBChangeListener();
        this.hsbPropertyChangeListener = this.createHSBPropertyChangeListener();
        this.viewportChangeListener = this.createViewportChangeListener();
        this.spPropertyChangeListener = this.createPropertyChangeListener();
        JViewport viewport = this.scrollpane.getViewport();
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        if (viewport != null) {
            viewport.addChangeListener(this.viewportChangeListener);
        }
        if (vsb != null) {
            vsb.getModel().addChangeListener(this.vsbChangeListener);
            vsb.addPropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (hsb != null) {
            hsb.getModel().addChangeListener(this.hsbChangeListener);
            hsb.addPropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.addPropertyChangeListener(this.spPropertyChangeListener);
        this.mouseScrollListener = this.createMouseWheelListener();
        this.scrollpane.addMouseWheelListener(this.mouseScrollListener);
        c.addPropertyChangeListener(this);
        if (UIManager.getBoolean("ScrollPane.useChildTextComponentFocus")) {
            this.viewportViewFocusHandler = new ViewportViewFocusHandler();
            c.getViewport().addContainerListener(this.viewportViewFocusHandler);
            Component view = c.getViewport().getView();
            if (view instanceof JTextComponent) {
                view.addFocusListener(this.viewportViewFocusHandler);
            }
        }
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        JViewport viewport = this.scrollpane.getViewport();
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        if (viewport != null) {
            viewport.removeChangeListener(this.viewportChangeListener);
        }
        if (vsb != null) {
            vsb.getModel().removeChangeListener(this.vsbChangeListener);
            vsb.removePropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (hsb != null) {
            hsb.getModel().removeChangeListener(this.hsbChangeListener);
            hsb.removePropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.removePropertyChangeListener(this.spPropertyChangeListener);
        if (this.mouseScrollListener != null) {
            this.scrollpane.removeMouseWheelListener(this.mouseScrollListener);
        }
        this.vsbChangeListener = null;
        this.hsbChangeListener = null;
        this.viewportChangeListener = null;
        this.spPropertyChangeListener = null;
        this.mouseScrollListener = null;
        this.handler = null;
        c.removePropertyChangeListener(this);
        if (this.viewportViewFocusHandler != null) {
            viewport.removeContainerListener(this.viewportViewFocusHandler);
            if (viewport.getView() != null) {
                viewport.getView().removeFocusListener(this.viewportViewFocusHandler);
            }
            this.viewportViewFocusHandler = null;
        }
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        int baseState = SeaGlassLookAndFeel.getComponentState(c);
        if (this.viewportViewFocusHandler != null && this.viewportViewHasFocus) {
            baseState |= 0x100;
        }
        return baseState;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle(this.scrollpane);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintScrollPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paintScrollPaneCorner(g, c);
        this.paint(context, g);
        context.dispose();
    }

    private void paintScrollPaneCorner(Graphics g, JComponent c) {
        if (this.scrollpane == null) {
            return;
        }
        if (this.scrollpane.getHorizontalScrollBar() == null || !this.scrollpane.getHorizontalScrollBar().isVisible()) {
            return;
        }
        if (this.scrollpane.getVerticalScrollBar() == null || !this.scrollpane.getVerticalScrollBar().isVisible()) {
            return;
        }
        int vBarWidth = this.scrollpane.getVerticalScrollBar().getWidth();
        int hBarHeight = this.scrollpane.getHorizontalScrollBar().getHeight();
        Insets insets = c.getInsets();
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.scrollpane.getComponentOrientation().isLeftToRight()) {
            g2.translate(c.getWidth() - insets.right - vBarWidth, c.getHeight() - insets.bottom - hBarHeight);
            g2.setClip(0, 0, vBarWidth, hBarHeight);
        } else {
            g2.translate(15 + insets.right, c.getHeight() - insets.bottom - hBarHeight);
            g2.scale(-1.0, 1.0);
            g2.setClip(0, 0, vBarWidth, hBarHeight);
        }
        this.cornerPainter.paint(g2, c, 15, 15);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        Border vpBorder = this.scrollpane.getViewportBorder();
        if (vpBorder != null) {
            Rectangle r = this.scrollpane.getViewportBorderBounds();
            vpBorder.paintBorder(this.scrollpane, g, r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintScrollPaneBorder(context, g, x, y, w, h);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    @Override
    protected void syncScrollPaneWithViewport() {
        JViewport viewport = this.scrollpane.getViewport();
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        JScrollBar hsb = this.scrollpane.getHorizontalScrollBar();
        JViewport rowHead = this.scrollpane.getRowHeader();
        JViewport colHead = this.scrollpane.getColumnHeader();
        boolean ltr = this.scrollpane.getComponentOrientation().isLeftToRight();
        if (viewport != null) {
            int value;
            int max;
            int extent;
            Dimension extentSize = viewport.getExtentSize();
            Dimension viewSize = viewport.getViewSize();
            Point viewPosition = viewport.getViewPosition();
            if (vsb != null) {
                extent = extentSize.height;
                max = viewSize.height;
                value = Math.max(0, Math.min(viewPosition.y, max - extent));
                vsb.setValues(value, extent, 0, max);
            }
            if (hsb != null) {
                extent = extentSize.width;
                max = viewSize.width;
                if (ltr) {
                    value = Math.max(0, Math.min(viewPosition.x, max - extent));
                } else {
                    int currentValue = hsb.getValue();
                    if (this.setValueCalled && max - currentValue == viewPosition.x) {
                        value = Math.max(0, Math.min(max - extent, currentValue));
                        if (extent != 0) {
                            this.setValueCalled = false;
                        }
                    } else if (extent > max) {
                        viewPosition.x = max - extent;
                        viewport.setViewPosition(viewPosition);
                        value = 0;
                    } else {
                        value = Math.max(0, Math.min(max - extent, max - extent - viewPosition.x));
                    }
                }
                hsb.setValues(value, extent, 0, max);
            }
            if (rowHead != null) {
                Point p = rowHead.getViewPosition();
                p.y = viewport.getViewPosition().y;
                p.x = 0;
                rowHead.setViewPosition(p);
            }
            if (colHead != null) {
                Point p = colHead.getViewPosition();
                p.x = ltr ? viewport.getViewPosition().x : Math.max(0, viewport.getViewPosition().x);
                p.y = 0;
                colHead.setViewPosition(p);
            }
        }
    }

    @Override
    protected ChangeListener createViewportChangeListener() {
        return this.getHandler();
    }

    private PropertyChangeListener createHSBPropertyChangeListener() {
        return this.getHandler();
    }

    @Override
    protected ChangeListener createHSBChangeListener() {
        return this.getHandler();
    }

    private PropertyChangeListener createVSBPropertyChangeListener() {
        return this.getHandler();
    }

    @Override
    protected ChangeListener createVSBChangeListener() {
        return this.getHandler();
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        return this.getHandler();
    }

    private void updateHorizontalScrollBar(PropertyChangeEvent pce) {
        this.updateScrollBar(pce, this.hsbChangeListener, this.hsbPropertyChangeListener);
    }

    private void updateVerticalScrollBar(PropertyChangeEvent pce) {
        this.updateScrollBar(pce, this.vsbChangeListener, this.vsbPropertyChangeListener);
    }

    private void updateScrollBar(PropertyChangeEvent pce, ChangeListener cl, PropertyChangeListener pcl) {
        JScrollBar sb = (JScrollBar)pce.getOldValue();
        if (sb != null) {
            if (cl != null) {
                sb.getModel().removeChangeListener(cl);
            }
            if (pcl != null) {
                sb.removePropertyChangeListener(pcl);
            }
        }
        if ((sb = (JScrollBar)pce.getNewValue()) != null) {
            if (cl != null) {
                sb.getModel().addChangeListener(cl);
            }
            if (pcl != null) {
                sb.addPropertyChangeListener(pcl);
            }
        }
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private class ViewportViewFocusHandler
    implements ContainerListener,
    FocusListener {
        private ViewportViewFocusHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JTextComponent) {
                e.getChild().addFocusListener(this);
                SeaGlassScrollPaneUI.this.viewportViewHasFocus = e.getChild().isFocusOwner();
                SeaGlassScrollPaneUI.this.scrollpane.repaint();
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            if (e.getChild() instanceof JTextComponent) {
                e.getChild().removeFocusListener(this);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            SeaGlassScrollPaneUI.this.viewportViewHasFocus = true;
            SeaGlassScrollPaneUI.this.scrollpane.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            SeaGlassScrollPaneUI.this.viewportViewHasFocus = false;
            SeaGlassScrollPaneUI.this.scrollpane.repaint();
        }
    }

    private class ViewportBorder
    extends AbstractBorder
    implements UIResource {
        private Insets insets;

        ViewportBorder(SeaGlassContext context) {
            this.insets = (Insets)context.getStyle().get(context, "ScrollPane.viewportBorderInsets");
            if (this.insets == null) {
                this.insets = SeaGlassLookAndFeel.EMPTY_UIRESOURCE_INSETS;
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JComponent jc = (JComponent)c;
            SeaGlassContext context = SeaGlassScrollPaneUI.this.getContext(jc);
            SynthStyle style = context.getStyle();
            if (style == null) {
                assert (false) : "SynthBorder is being used outside after the  UI has been uninstalled";
                return;
            }
            context.getPainter().paintViewportBorder(context, g, x, y, width, height);
            context.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            }
            insets.top = this.insets.top;
            insets.bottom = this.insets.bottom;
            insets.left = this.insets.left;
            insets.right = this.insets.left;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    class Handler
    implements ChangeListener,
    PropertyChangeListener,
    MouseWheelListener {
        Handler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (SeaGlassScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getWheelRotation() != 0) {
                boolean isHorizontal = (e.getModifiersEx() & 0x40) != 0;
                JScrollBar toScroll = SeaGlassScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int direction = e.getWheelRotation() < 0 ? -1 : 1;
                int orientation = 1;
                if (toScroll == null || !toScroll.isVisible() || isHorizontal) {
                    toScroll = SeaGlassScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (toScroll == null || !toScroll.isVisible()) {
                        return;
                    }
                    orientation = 0;
                }
                if (e.getScrollType() == 0) {
                    JViewport vp = SeaGlassScrollPaneUI.this.scrollpane.getViewport();
                    if (vp == null) {
                        return;
                    }
                    Component comp = vp.getView();
                    int units = Math.abs(e.getUnitsToScroll());
                    boolean limitScroll = Math.abs(e.getWheelRotation()) == 1;
                    Object fastWheelScroll = toScroll.getClientProperty("JScrollBar.fastWheelScrolling");
                    if (Boolean.TRUE == fastWheelScroll && comp instanceof Scrollable) {
                        Scrollable scrollComp = (Scrollable)((Object)comp);
                        Rectangle viewRect = vp.getViewRect();
                        int startingX = viewRect.x;
                        boolean leftToRight = comp.getComponentOrientation().isLeftToRight();
                        int scrollMin = toScroll.getMinimum();
                        int scrollMax = toScroll.getMaximum() - toScroll.getModel().getExtent();
                        if (limitScroll) {
                            int blockIncr = scrollComp.getScrollableBlockIncrement(viewRect, orientation, direction);
                            if (direction < 0) {
                                scrollMin = Math.max(scrollMin, toScroll.getValue() - blockIncr);
                            } else {
                                scrollMax = Math.min(scrollMax, toScroll.getValue() + blockIncr);
                            }
                        }
                        for (int i = 0; i < units; ++i) {
                            int unitIncr = scrollComp.getScrollableUnitIncrement(viewRect, orientation, direction);
                            if (orientation == 1) {
                                if (direction < 0) {
                                    viewRect.y -= unitIncr;
                                    if (viewRect.y > scrollMin) continue;
                                    viewRect.y = scrollMin;
                                    break;
                                }
                                viewRect.y += unitIncr;
                                if (viewRect.y < scrollMax) continue;
                                viewRect.y = scrollMax;
                                break;
                            }
                            if (leftToRight && direction < 0 || !leftToRight && direction > 0) {
                                viewRect.x -= unitIncr;
                                if (!leftToRight || viewRect.x >= scrollMin) continue;
                                viewRect.x = scrollMin;
                                break;
                            }
                            if (leftToRight && direction > 0 || !leftToRight && direction < 0) {
                                viewRect.x += unitIncr;
                                if (!leftToRight || viewRect.x <= scrollMax) continue;
                                viewRect.x = scrollMax;
                                break;
                            }
                            assert (false) : "Non-sensical ComponentOrientation / scroll direction";
                        }
                        if (orientation == 1) {
                            toScroll.setValue(viewRect.y);
                        } else if (leftToRight) {
                            toScroll.setValue(viewRect.x);
                        } else {
                            int newPos = toScroll.getValue() - (viewRect.x - startingX);
                            if (newPos < scrollMin) {
                                newPos = scrollMin;
                            } else if (newPos > scrollMax) {
                                newPos = scrollMax;
                            }
                            toScroll.setValue(newPos);
                        }
                    } else {
                        this.scrollByUnits(toScroll, direction, units, limitScroll);
                    }
                } else if (e.getScrollType() == 1) {
                    this.scrollByBlock(toScroll, direction);
                }
                e.consume();
            }
        }

        void scrollByBlock(JScrollBar scrollbar, int direction) {
            int oldValue = scrollbar.getValue();
            int blockIncrement = scrollbar.getBlockIncrement(direction);
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = scrollbar.getMinimum();
            }
            scrollbar.setValue(newValue);
        }

        void scrollByUnits(JScrollBar scrollbar, int direction, int units, boolean limitToBlock) {
            int limit = -1;
            if (limitToBlock) {
                limit = direction < 0 ? scrollbar.getValue() - scrollbar.getBlockIncrement(direction) : scrollbar.getValue() + scrollbar.getBlockIncrement(direction);
            }
            for (int i = 0; i < units; ++i) {
                int delta = direction > 0 ? scrollbar.getUnitIncrement(direction) : -scrollbar.getUnitIncrement(direction);
                int oldValue = scrollbar.getValue();
                int newValue = oldValue + delta;
                if (delta > 0 && newValue < oldValue) {
                    newValue = scrollbar.getMaximum();
                } else if (delta < 0 && newValue > oldValue) {
                    newValue = scrollbar.getMinimum();
                }
                if (oldValue == newValue) break;
                if (limitToBlock && i > 0) {
                    assert (limit != -1);
                    if (direction < 0 && newValue < limit || direction > 0 && newValue > limit) break;
                }
                scrollbar.setValue(newValue);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JViewport viewport = SeaGlassScrollPaneUI.this.scrollpane.getViewport();
            if (viewport != null) {
                if (e.getSource() == viewport) {
                    this.viewportStateChanged(e);
                } else {
                    JScrollBar hsb = SeaGlassScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (hsb != null && e.getSource() == hsb.getModel()) {
                        this.hsbStateChanged(viewport, e);
                    } else {
                        JScrollBar vsb = SeaGlassScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                        if (vsb != null && e.getSource() == vsb.getModel()) {
                            this.vsbStateChanged(viewport, e);
                        }
                    }
                }
            }
        }

        private void vsbStateChanged(JViewport viewport, ChangeEvent e) {
            BoundedRangeModel model = (BoundedRangeModel)e.getSource();
            Point p = viewport.getViewPosition();
            p.y = model.getValue();
            viewport.setViewPosition(p);
        }

        private void hsbStateChanged(JViewport viewport, ChangeEvent e) {
            BoundedRangeModel model = (BoundedRangeModel)e.getSource();
            Point p = viewport.getViewPosition();
            int value = model.getValue();
            if (SeaGlassScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight()) {
                p.x = value;
            } else {
                int max = viewport.getViewSize().width;
                int extent = viewport.getExtentSize().width;
                int oldX = p.x;
                p.x = max - extent - value;
                if (extent == 0 && value != 0 && oldX == max) {
                    SeaGlassScrollPaneUI.this.setValueCalled = true;
                } else if (extent != 0 && oldX < 0 && p.x == 0) {
                    p.x += value;
                }
            }
            viewport.setViewPosition(p);
        }

        private void viewportStateChanged(ChangeEvent e) {
            SeaGlassScrollPaneUI.this.syncScrollPaneWithViewport();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == SeaGlassScrollPaneUI.this.scrollpane) {
                this.scrollPanePropertyChange(e);
            } else {
                this.sbPropertyChange(e);
            }
        }

        private void scrollPanePropertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName == "verticalScrollBarDisplayPolicy") {
                SeaGlassScrollPaneUI.this.updateScrollBarDisplayPolicy(e);
            } else if (propertyName == "horizontalScrollBarDisplayPolicy") {
                SeaGlassScrollPaneUI.this.updateScrollBarDisplayPolicy(e);
            } else if (propertyName == "viewport") {
                SeaGlassScrollPaneUI.this.updateViewport(e);
            } else if (propertyName == "rowHeader") {
                SeaGlassScrollPaneUI.this.updateRowHeader(e);
            } else if (propertyName == "columnHeader") {
                SeaGlassScrollPaneUI.this.updateColumnHeader(e);
            } else if (propertyName == "verticalScrollBar") {
                SeaGlassScrollPaneUI.this.updateVerticalScrollBar(e);
            } else if (propertyName == "horizontalScrollBar") {
                SeaGlassScrollPaneUI.this.updateHorizontalScrollBar(e);
            } else if (propertyName == "componentOrientation") {
                SeaGlassScrollPaneUI.this.scrollpane.revalidate();
                SeaGlassScrollPaneUI.this.scrollpane.repaint();
            }
        }

        private void sbPropertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            Object source = e.getSource();
            if ("model" == propertyName) {
                JScrollBar sb = SeaGlassScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                BoundedRangeModel oldModel = (BoundedRangeModel)e.getOldValue();
                ChangeListener cl = null;
                if (source == sb) {
                    cl = SeaGlassScrollPaneUI.this.vsbChangeListener;
                } else if (source == SeaGlassScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                    sb = SeaGlassScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    cl = SeaGlassScrollPaneUI.this.hsbChangeListener;
                }
                if (cl != null) {
                    if (oldModel != null) {
                        oldModel.removeChangeListener(cl);
                    }
                    if (sb.getModel() != null) {
                        sb.getModel().addChangeListener(cl);
                    }
                }
            } else if ("componentOrientation" == propertyName && source == SeaGlassScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                JScrollBar hsb = SeaGlassScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                JViewport viewport = SeaGlassScrollPaneUI.this.scrollpane.getViewport();
                Point p = viewport.getViewPosition();
                p.x = SeaGlassScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight() ? hsb.getValue() : viewport.getViewSize().width - viewport.getExtentSize().width - hsb.getValue();
                viewport.setViewPosition(p);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            SeaGlassScrollPaneUI.this.getHandler().propertyChange(e);
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        protected MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            SeaGlassScrollPaneUI.this.getHandler().mouseWheelMoved(e);
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            SeaGlassScrollPaneUI.this.getHandler().stateChanged(e);
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            SeaGlassScrollPaneUI.this.getHandler().stateChanged(e);
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            SeaGlassScrollPaneUI.this.getHandler().stateChanged(e);
        }
    }
}

