/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.SeaGlassRegion;
import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.component.SeaGlassArrowButton;
import com.seaglasslookandfeel.state.ScrollBarButtonsTogetherState;
import com.seaglasslookandfeel.state.State;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.DefaultLookup;

public class SeaGlassScrollBarUI
extends BasicScrollBarUI
implements PropertyChangeListener,
SeaglassUI {
    private static final State buttonsTogether = new ScrollBarButtonsTogetherState();
    private SynthStyle style;
    private SynthStyle thumbStyle;
    private SynthStyle trackStyle;
    private SynthStyle capStyle;
    private MouseButtonListener mouseButtonListener;
    private boolean validMinimumThumbSize;
    private int scrollBarWidth;
    private int incrGap;
    private int decrGap;
    private int capSize;
    private boolean isMouseButtonDown = false;

    public static ComponentUI createUI(JComponent c) {
        return new SeaGlassScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.trackHighlight = 0;
        if (this.scrollbar.getLayout() == null || this.scrollbar.getLayout() instanceof UIResource) {
            this.scrollbar.setLayout(this);
        }
        this.updateStyle(this.scrollbar);
    }

    @Override
    protected void configureScrollBarColors() {
    }

    private void updateStyle(JScrollBar c) {
        SynthStyle oldStyle = this.style;
        SeaGlassContext context = this.getContext((JComponent)c, 1);
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.scrollBarWidth = this.style.getInt(context, "ScrollBar.thumbHeight", 14);
            this.minimumThumbSize = (Dimension)this.style.get(context, "ScrollBar.minimumThumbSize");
            if (this.minimumThumbSize == null) {
                this.minimumThumbSize = new Dimension();
                this.validMinimumThumbSize = false;
            } else {
                this.validMinimumThumbSize = true;
            }
            this.maximumThumbSize = (Dimension)this.style.get(context, "ScrollBar.maximumThumbSize");
            if (this.maximumThumbSize == null) {
                this.maximumThumbSize = new Dimension(4096, 4097);
            }
            this.incrGap = this.style.getInt(context, "ScrollBar.incrementButtonGap", 0);
            this.decrGap = this.style.getInt(context, "ScrollBar.decrementButtonGap", 0);
            this.capSize = this.style.getInt(context, "ScrollBar.capSize", 0);
            String scaleKey = SeaGlassStyle.getSizeVariant(this.scrollbar);
            if (scaleKey != null) {
                if ("large".equals(scaleKey)) {
                    this.scrollBarWidth = (int)((double)this.scrollBarWidth * 1.15);
                    this.incrGap = (int)((double)this.incrGap * 1.15);
                    this.decrGap = (int)((double)this.decrGap * 1.15);
                } else if ("small".equals(scaleKey)) {
                    this.scrollBarWidth = (int)((double)this.scrollBarWidth * 0.857);
                    this.incrGap = (int)((double)this.incrGap * 0.857);
                    this.decrGap = (int)((double)this.decrGap * 0.857);
                } else if ("mini".equals(scaleKey)) {
                    this.scrollBarWidth = (int)((double)this.scrollBarWidth * 0.714);
                    this.incrGap = (int)((double)this.incrGap * 0.714);
                    this.decrGap = (int)((double)this.decrGap * 0.714);
                }
            }
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
        context = this.getContext(c, Region.SCROLL_BAR_TRACK, 1);
        this.trackStyle = SeaGlassLookAndFeel.updateStyle(context, this);
        context.dispose();
        context = this.getContext(c, Region.SCROLL_BAR_THUMB, 1);
        this.thumbStyle = SeaGlassLookAndFeel.updateStyle(context, this);
        context.dispose();
        context = this.getContext(c, SeaGlassRegion.SCROLL_BAR_CAP, 1);
        this.capStyle = SeaGlassLookAndFeel.updateStyle(context, this);
        context.dispose();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.scrollbar.addPropertyChangeListener(this);
        this.mouseButtonListener = new MouseButtonListener();
        this.scrollbar.addMouseListener(this.mouseButtonListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removePropertyChangeListener(this);
        this.scrollbar.removeMouseListener(this.mouseButtonListener);
    }

    @Override
    protected void uninstallDefaults() {
        SeaGlassContext context = this.getContext((JComponent)this.scrollbar, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        context = this.getContext(this.scrollbar, Region.SCROLL_BAR_TRACK, 1);
        this.trackStyle.uninstallDefaults(context);
        context.dispose();
        this.trackStyle = null;
        context = this.getContext(this.scrollbar, Region.SCROLL_BAR_THUMB, 1);
        this.thumbStyle.uninstallDefaults(context);
        context.dispose();
        this.thumbStyle = null;
        context = this.getContext(this.scrollbar, SeaGlassRegion.SCROLL_BAR_CAP, 1);
        this.capStyle.uninstallDefaults(context);
        context.dispose();
        this.capStyle = null;
        super.uninstallDefaults();
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    private SeaGlassContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SeaGlassContext getContext(JComponent c, Region region, int state) {
        SynthStyle style = this.trackStyle;
        if (region == Region.SCROLL_BAR_THUMB) {
            style = this.thumbStyle;
        } else if (region == SeaGlassRegion.SCROLL_BAR_CAP) {
            style = this.capStyle;
        }
        return SeaGlassContext.getContext(SeaGlassContext.class, c, region, style, state);
    }

    public JButton getDecreaseButton() {
        return this.decrButton;
    }

    public JButton getIncreaseButton() {
        return this.incrButton;
    }

    public boolean isMouseButtonDown() {
        return this.isMouseButtonDown;
    }

    private int getComponentState(JComponent c, Region region) {
        if (region == Region.SCROLL_BAR_THUMB && this.isThumbRollover() && c.isEnabled()) {
            if (this.isMouseButtonDown) {
                return 4;
            }
            return 2;
        }
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    @Override
    public boolean getSupportsAbsolutePositioning() {
        SeaGlassContext context = this.getContext(this.scrollbar);
        boolean value = this.style.getBoolean(context, "ScrollBar.allowsAbsolutePositioning", false);
        context.dispose();
        return value;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintScrollBarBackground(context, g, 0, 0, c.getWidth(), c.getHeight(), this.scrollbar.getOrientation());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
        SeaGlassContext subcontext = this.getContext((JComponent)this.scrollbar, Region.SCROLL_BAR_TRACK);
        this.paintTrack(subcontext, g, this.getTrackBounds());
        subcontext.dispose();
        if (buttonsTogether.isInState(context.getComponent())) {
            subcontext = this.getContext((JComponent)this.scrollbar, SeaGlassRegion.SCROLL_BAR_CAP);
            this.paintCap(subcontext, g, this.getCapBounds());
            subcontext.dispose();
        }
        subcontext = this.getContext((JComponent)this.scrollbar, Region.SCROLL_BAR_THUMB);
        this.paintThumb(subcontext, g, this.getThumbBounds());
        subcontext.dispose();
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintScrollBarBorder(context, g, x, y, w, h, this.scrollbar.getOrientation());
    }

    protected void paintTrack(SeaGlassContext ss, Graphics g, Rectangle trackBounds) {
        SeaGlassLookAndFeel.updateSubregion(ss, g, trackBounds);
        ss.getPainter().paintScrollBarTrackBackground(ss, g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, this.scrollbar.getOrientation());
        ss.getPainter().paintScrollBarTrackBorder(ss, g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, this.scrollbar.getOrientation());
    }

    protected void paintThumb(SeaGlassContext ss, Graphics g, Rectangle thumbBounds) {
        SeaGlassLookAndFeel.updateSubregion(ss, g, thumbBounds);
        int orientation = this.scrollbar.getOrientation();
        ss.getPainter().paintScrollBarThumbBackground(ss, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, orientation);
        ss.getPainter().paintScrollBarThumbBorder(ss, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, orientation);
    }

    protected void paintCap(SeaGlassContext ss, Graphics g, Rectangle capBounds) {
        SeaGlassLookAndFeel.updateSubregion(ss, g, capBounds);
        int orientation = this.scrollbar.getOrientation();
        ss.getPainter().paintScrollBarThumbBackground(ss, g, capBounds.x, capBounds.y, capBounds.width, capBounds.height, orientation);
    }

    protected Rectangle getCapBounds() {
        if (this.scrollbar.getOrientation() == 1) {
            return new Rectangle(0, 0, this.scrollBarWidth, this.capSize);
        }
        if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(0, 0, this.capSize, this.scrollBarWidth);
        }
        return new Rectangle(this.scrollbar.getWidth() - this.capSize, 0, this.capSize, this.scrollBarWidth);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Insets insets = c.getInsets();
        return this.scrollbar.getOrientation() == 1 ? new Dimension(this.scrollBarWidth + insets.left + insets.right, 48) : new Dimension(48, this.scrollBarWidth + insets.top + insets.bottom);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        if (!this.validMinimumThumbSize) {
            if (this.scrollbar.getOrientation() == 1) {
                this.minimumThumbSize.width = this.scrollBarWidth;
                this.minimumThumbSize.height = 7;
            } else {
                this.minimumThumbSize.width = 7;
                this.minimumThumbSize.height = this.scrollBarWidth;
            }
        }
        return this.minimumThumbSize;
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        SeaGlassArrowButton synthArrowButton = new SeaGlassArrowButton(orientation){

            @Override
            public boolean contains(int x, int y) {
                if (SeaGlassScrollBarUI.this.decrGap < 0) {
                    if (buttonsTogether.isInState(SeaGlassScrollBarUI.this.scrollbar)) {
                        int minX = 0;
                        int minY = 0;
                        if (SeaGlassScrollBarUI.this.scrollbar.getOrientation() == 1) {
                            minY -= SeaGlassScrollBarUI.this.decrGap;
                        } else {
                            minX -= SeaGlassScrollBarUI.this.decrGap;
                        }
                        return x >= minX && x < this.getWidth() && y >= minY && y < this.getHeight();
                    }
                    int width = this.getWidth();
                    int height = this.getHeight();
                    if (SeaGlassScrollBarUI.this.scrollbar.getOrientation() == 1) {
                        height += SeaGlassScrollBarUI.this.decrGap;
                    } else {
                        width += SeaGlassScrollBarUI.this.decrGap;
                    }
                    return x >= 0 && x < width && y >= 0 && y < height;
                }
                return super.contains(x, y);
            }
        };
        synthArrowButton.setName("ScrollBar.button");
        return synthArrowButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        SeaGlassArrowButton synthArrowButton = new SeaGlassArrowButton(orientation){

            @Override
            public boolean contains(int x, int y) {
                if (SeaGlassScrollBarUI.this.incrGap < 0 && !buttonsTogether.isInState(SeaGlassScrollBarUI.this.scrollbar)) {
                    int width = this.getWidth();
                    int height = this.getHeight();
                    if (SeaGlassScrollBarUI.this.scrollbar.getOrientation() == 1) {
                        height += SeaGlassScrollBarUI.this.incrGap;
                        y += SeaGlassScrollBarUI.this.incrGap;
                    } else {
                        width += SeaGlassScrollBarUI.this.incrGap;
                        x += SeaGlassScrollBarUI.this.incrGap;
                    }
                    return x >= 0 && x < width && y >= 0 && y < height;
                }
                return super.contains(x, y);
            }
        };
        synthArrowButton.setName("ScrollBar.button");
        return synthArrowButton;
    }

    @Override
    protected void setThumbRollover(boolean active) {
        if (this.isThumbRollover() != active) {
            this.scrollbar.repaint(this.getThumbBounds());
            super.setThumbRollover(active);
        }
    }

    private void updateButtonDirections() {
        int orient = this.scrollbar.getOrientation();
        if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
            ((SeaGlassArrowButton)this.incrButton).setDirection(orient == 0 ? 3 : 5);
            ((SeaGlassArrowButton)this.decrButton).setDirection(orient == 0 ? 7 : 1);
        } else {
            ((SeaGlassArrowButton)this.incrButton).setDirection(orient == 0 ? 7 : 5);
            ((SeaGlassArrowButton)this.decrButton).setDirection(orient == 0 ? 3 : 1);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (SeaGlassLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JScrollBar)e.getSource());
        }
        if ("orientation" == propertyName) {
            this.updateButtonDirections();
        } else if ("componentOrientation" == propertyName) {
            this.updateButtonDirections();
        }
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        if (!buttonsTogether.isInState(sb)) {
            super.layoutVScrollbar(sb);
        } else {
            this.layoutVScrollbarTogether(sb);
        }
    }

    @Override
    protected void layoutHScrollbar(JScrollBar sb) {
        if (!buttonsTogether.isInState(sb)) {
            super.layoutHScrollbar(sb);
        } else if (sb.getComponentOrientation().isLeftToRight()) {
            this.layoutHScrollbarTogetherLeftToRight(sb);
        } else {
            this.layoutHScrollbarTogetherRightToLeft(sb);
        }
    }

    private void layoutVScrollbarTogether(JScrollBar sb) {
        ScrollbarLayoutValues lv = new ScrollbarLayoutValues();
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        this.layoutScrollbarTogether(sb, lv, sbSize.height, sbSize.width, sbInsets.top, sbInsets.bottom, sbInsets.left, sbInsets.right, this.decrButton.getPreferredSize().height, this.getMinimumThumbSize().height, this.getMaximumThumbSize().height);
        this.trackRect.setBounds(lv.itemEdge, lv.trackPosition, lv.itemThickness, lv.trackLength);
        this.decrButton.setBounds(lv.itemEdge, lv.decrButtonPosition, lv.itemThickness, lv.decrButtonLength);
        this.incrButton.setBounds(lv.itemEdge, lv.incrButtonPosition, lv.itemThickness, lv.incrButtonLength);
        if (lv.thumbLength > 0) {
            this.setThumbBounds(lv.itemEdge, lv.thumbPosition, lv.itemThickness, lv.thumbLength);
        } else {
            this.setThumbBounds(0, 0, 0, 0);
        }
    }

    private void layoutHScrollbarTogetherLeftToRight(JScrollBar sb) {
        ScrollbarLayoutValues lv = new ScrollbarLayoutValues();
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        this.layoutScrollbarTogether(sb, lv, sbSize.width, sbSize.height, sbInsets.left, sbInsets.right, sbInsets.top, sbInsets.bottom, this.decrButton.getPreferredSize().width, this.getMinimumThumbSize().width, this.getMaximumThumbSize().width);
        this.trackRect.setBounds(lv.trackPosition, lv.itemEdge, lv.trackLength, lv.itemThickness);
        this.decrButton.setBounds(lv.decrButtonPosition, lv.itemEdge, lv.decrButtonLength, lv.itemThickness);
        this.incrButton.setBounds(lv.incrButtonPosition, lv.itemEdge, lv.incrButtonLength, lv.itemThickness);
        if (lv.thumbLength > 0) {
            this.setThumbBounds(lv.thumbPosition, lv.itemEdge, lv.thumbLength, lv.itemThickness);
        } else {
            this.setThumbBounds(0, 0, 0, 0);
        }
    }

    private void layoutHScrollbarTogetherRightToLeft(JScrollBar sb) {
        ScrollbarLayoutValues lv = new ScrollbarLayoutValues();
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        this.layoutScrollbarTogether(sb, lv, sbSize.width, sbSize.height, sbInsets.left, sbInsets.right, sbInsets.top, sbInsets.bottom, this.decrButton.getPreferredSize().width, this.getMinimumThumbSize().width, this.getMaximumThumbSize().width);
        lv.incrButtonPosition = sbInsets.left;
        lv.decrButtonPosition = lv.incrButtonPosition + lv.incrButtonLength;
        lv.thumbPosition = lv.trackPosition + lv.trackLength - lv.thumbPosition - lv.thumbLength;
        lv.trackPosition = lv.decrButtonPosition + lv.decrButtonLength + this.incrGap;
        lv.thumbPosition += lv.trackPosition;
        this.trackRect.setBounds(lv.trackPosition, lv.itemEdge, lv.trackLength, lv.itemThickness);
        this.decrButton.setBounds(lv.decrButtonPosition, lv.itemEdge, lv.decrButtonLength, lv.itemThickness);
        this.incrButton.setBounds(lv.incrButtonPosition, lv.itemEdge, lv.incrButtonLength, lv.itemThickness);
        if (lv.thumbLength > 0) {
            this.setThumbBounds(lv.thumbPosition, lv.itemEdge, lv.thumbLength, lv.itemThickness);
        } else {
            this.setThumbBounds(0, 0, 0, 0);
        }
    }

    private void layoutScrollbarTogether(JScrollBar sb, ScrollbarLayoutValues lv, int sbLength, int sbThickness, int insetLengthStart, int insetLengthEnd, int insetThicknessStart, int insetThicknessEnd, int decrPreferredLength, int minThumbLength, int maxThumbLength) {
        int maxThumbPosition;
        lv.itemThickness = sbThickness - (insetThicknessStart + insetThicknessEnd);
        lv.itemEdge = insetThicknessStart;
        boolean squareButtons = DefaultLookup.getBoolean(this.scrollbar, this, "ScrollBar.squareButtons", false);
        lv.incrButtonLength = lv.itemThickness + 1;
        lv.incrButtonPosition = sbLength - insetLengthEnd - lv.incrButtonLength;
        lv.decrButtonLength = squareButtons ? lv.itemThickness : decrPreferredLength;
        lv.decrButtonPosition = lv.incrButtonPosition - lv.decrButtonLength;
        int sbInsetsSpace = insetLengthStart + insetLengthEnd;
        int sbAvailButtonSpace = sbLength - sbInsetsSpace;
        int sbButtonsSpace = lv.decrButtonLength + lv.incrButtonLength;
        if (sbAvailButtonSpace < sbButtonsSpace) {
            lv.incrButtonLength = lv.decrButtonLength = sbAvailButtonSpace / 2;
            lv.incrButtonPosition = sbLength - insetLengthEnd - lv.incrButtonLength;
            lv.decrButtonPosition = insetLengthStart;
        }
        lv.trackPosition = insetLengthStart + this.capSize + this.decrGap;
        lv.trackLength = lv.decrButtonPosition - this.incrGap - lv.trackPosition;
        int gaps = this.decrGap + this.incrGap;
        float trackLength = sbLength - sbInsetsSpace - sbButtonsSpace - gaps - this.capSize;
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        lv.thumbLength = range <= 0.0f ? maxThumbLength : (int)(trackLength * (extent / range));
        lv.thumbLength = Math.min(Math.max(lv.thumbLength, minThumbLength), maxThumbLength);
        lv.thumbPosition = maxThumbPosition = lv.trackPosition + lv.trackLength - lv.thumbLength;
        if (value < max - extent) {
            float thumbRange = lv.trackLength - lv.thumbLength;
            lv.thumbPosition = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            lv.thumbPosition += lv.trackPosition;
        }
        if (lv.thumbLength >= (int)trackLength) {
            lv.thumbLength = 0;
        } else {
            if (lv.thumbPosition > maxThumbPosition) {
                lv.thumbPosition = maxThumbPosition;
            }
            if (lv.thumbPosition < lv.trackPosition) {
                lv.thumbPosition = lv.trackPosition;
            }
        }
    }

    protected class ArrowButtonListener
    extends MouseAdapter {
        boolean handledEvent;

        protected ArrowButtonListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SeaGlassScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int direction = e.getSource() == SeaGlassScrollBarUI.this.incrButton ? 1 : -1;
            SeaGlassScrollBarUI.this.scrollByUnit(direction);
            SeaGlassScrollBarUI.this.scrollTimer.stop();
            SeaGlassScrollBarUI.this.scrollListener.setDirection(direction);
            SeaGlassScrollBarUI.this.scrollListener.setScrollByBlock(false);
            SeaGlassScrollBarUI.this.scrollTimer.start();
            this.handledEvent = true;
            if (!SeaGlassScrollBarUI.this.scrollbar.hasFocus() && SeaGlassScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                SeaGlassScrollBarUI.this.scrollbar.requestFocus();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SeaGlassScrollBarUI.this.scrollTimer.stop();
            this.handledEvent = false;
            SeaGlassScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }
    }

    protected class MouseButtonListener
    extends MouseAdapter
    implements MouseListener {
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        protected MouseButtonListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SeaGlassScrollBarUI.this.isMouseButtonDown) {
                SeaGlassScrollBarUI.this.isMouseButtonDown = false;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || !SeaGlassScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!SeaGlassScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            SeaGlassScrollBarUI.this.isMouseButtonDown = false;
            if (SeaGlassScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                SeaGlassScrollBarUI.this.isMouseButtonDown = true;
                SeaGlassScrollBarUI.this.scrollbar.repaint();
            }
        }
    }

    private class ScrollbarLayoutValues {
        int itemEdge;
        int itemThickness;
        int trackPosition;
        int trackLength;
        int incrButtonPosition;
        int incrButtonLength;
        int decrButtonPosition;
        int decrButtonLength;
        int thumbPosition;
        int thumbLength;

        private ScrollbarLayoutValues() {
        }
    }
}

