/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;

public class SeaGlassProgressBarUI
extends BasicProgressBarUI
implements SeaglassUI,
PropertyChangeListener {
    private SynthStyle style;
    private int progressPadding;
    private boolean rotateText;
    private boolean paintOutsideClip;
    private int trackThickness;
    private boolean tileWhenIndeterminate;
    private int tileWidth;
    private Color bgFillColor;
    private Rectangle boundsRect = new Rectangle();
    private Rectangle savedRect = new Rectangle();
    private ShapeGenerator shapeGenerator = new ShapeGenerator();

    public static ComponentUI createUI(JComponent x) {
        return new SeaGlassProgressBarUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.progressBar.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this);
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.progressBar);
    }

    private void updateStyle(JProgressBar c) {
        String scaleKey;
        SeaGlassContext context = this.getContext(c, 1);
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        this.setCellLength(this.style.getInt(context, "ProgressBar.cellLength", 1));
        this.setCellSpacing(this.style.getInt(context, "ProgressBar.cellSpacing", 0));
        this.progressPadding = this.style.getInt(context, "ProgressBar.progressPadding", 0);
        this.paintOutsideClip = this.style.getBoolean(context, "ProgressBar.paintOutsideClip", false);
        this.rotateText = this.style.getBoolean(context, "ProgressBar.rotateText", false);
        this.tileWhenIndeterminate = this.style.getBoolean(context, "ProgressBar.tileWhenIndeterminate", false);
        this.trackThickness = this.style.getInt(context, "ProgressBar.trackThickness", 19);
        this.tileWidth = this.style.getInt(context, "ProgressBar.tileWidth", 15);
        this.bgFillColor = (Color)this.style.get(context, "ProgressBar.backgroundFillColor");
        if (this.bgFillColor == null) {
            this.bgFillColor = Color.white;
        }
        if ((scaleKey = SeaGlassStyle.getSizeVariant(this.progressBar)) != null) {
            if ("large".equals(scaleKey)) {
                this.trackThickness = 24;
                this.tileWidth = (int)((double)this.tileWidth * 1.15);
            } else if ("small".equals(scaleKey)) {
                this.trackThickness = 17;
                this.tileWidth = (int)((double)this.tileWidth * 0.857);
            } else if ("mini".equals(scaleKey)) {
                this.trackThickness = 15;
                this.tileWidth = (int)((double)this.tileWidth * 0.784);
            }
        }
        context.dispose();
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        Dimension vertDim = (Dimension)DefaultLookup.get(this.progressBar, this, "ProgressBar.vertictalSize");
        if (vertDim == null) {
            vertDim = new Dimension(19, 150);
        }
        return vertDim;
    }

    @Override
    protected void uninstallDefaults() {
        SeaGlassContext context = this.getContext(this.progressBar, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        super.getBaseline(c, width, height);
        if (this.progressBar.isStringPainted() && this.progressBar.getOrientation() == 0) {
            SeaGlassContext context = this.getContext(c);
            Font font = context.getStyle().getFont(context);
            FontMetrics metrics = this.progressBar.getFontMetrics(font);
            context.dispose();
            return (height - metrics.getAscent() - metrics.getDescent()) / 2 + metrics.getAscent();
        }
        return -1;
    }

    @Override
    protected Rectangle getBox(Rectangle r) {
        if (this.tileWhenIndeterminate) {
            return SwingUtilities.calculateInnerArea(this.progressBar, r);
        }
        return super.getBox(r);
    }

    @Override
    protected void setAnimationIndex(int newValue) {
        if (this.paintOutsideClip) {
            if (this.getAnimationIndex() == newValue) {
                return;
            }
            super.setAnimationIndex(newValue);
            this.progressBar.repaint();
        } else {
            super.setAnimationIndex(newValue);
        }
    }

    private Rectangle calcBounds(JProgressBar pBar) {
        this.boundsRect.x = 0;
        this.boundsRect.y = 0;
        this.boundsRect.width = pBar.getWidth();
        this.boundsRect.height = pBar.getHeight();
        if (pBar.getOrientation() == 0) {
            this.boundsRect.y = (this.boundsRect.height - this.trackThickness) / 2;
            this.boundsRect.height = Math.min(this.boundsRect.height, this.trackThickness);
        } else {
            this.boundsRect.x = (this.boundsRect.width - this.trackThickness) / 2;
            this.boundsRect.width = Math.min(this.boundsRect.width, this.trackThickness);
        }
        return this.boundsRect;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        JProgressBar pBar = (JProgressBar)c;
        Rectangle bounds = this.calcBounds(pBar);
        context.getPainter().paintProgressBarBackground(context, g, bounds.x, bounds.y, bounds.width, bounds.height, pBar.getOrientation());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
        JProgressBar pBar = (JProgressBar)context.getComponent();
        Insets pBarInsets = pBar.getInsets();
        Rectangle bounds = this.calcBounds(pBar);
        this.savedRect.setBounds(bounds);
        bounds.x += pBarInsets.left + this.progressPadding;
        bounds.y += pBarInsets.top + this.progressPadding;
        bounds.width -= pBarInsets.left + pBarInsets.right + this.progressPadding + this.progressPadding;
        bounds.height -= pBarInsets.top + pBarInsets.bottom + this.progressPadding + this.progressPadding;
        int size = 0;
        boolean isFinished = false;
        if (!pBar.isIndeterminate()) {
            double percentComplete = pBar.getPercentComplete();
            if (percentComplete == 1.0) {
                isFinished = true;
            } else if (percentComplete > 0.0) {
                size = pBar.getOrientation() == 0 ? (int)(percentComplete * (double)bounds.width) : (int)(percentComplete * (double)bounds.height);
            }
        }
        GraphicsConfiguration gc = ((Graphics2D)g).getDeviceConfiguration();
        BufferedImage img = gc.createCompatibleImage(bounds.width, bounds.height, 3);
        Graphics2D g2d = img.createGraphics();
        g2d.setComposite(AlphaComposite.Clear);
        g2d.fillRect(0, 0, bounds.width, bounds.height);
        g2d.setComposite(AlphaComposite.Src);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.bgFillColor);
        ShapeGenerator.CornerSize cornerSize = pBar.getOrientation() == 0 ? ShapeGenerator.CornerSize.ROUND_HEIGHT : ShapeGenerator.CornerSize.ROUND_WIDTH;
        g2d.fill(this.shapeGenerator.createRoundRectangle(0, 0, bounds.width, bounds.height, cornerSize));
        g2d.setComposite(AlphaComposite.SrcAtop);
        context.getPainter().paintProgressBarBackground(context, g2d, this.savedRect.x - bounds.x, this.savedRect.y - bounds.y, this.savedRect.width, this.savedRect.height, pBar.getOrientation());
        this.paintProgressIndicator(context, g2d, bounds.width, bounds.height, size, isFinished);
        g2d.dispose();
        g.drawImage(img, bounds.x, bounds.y, null);
        if (pBar.isStringPainted()) {
            this.paintText(context, g, pBar.getString());
        }
    }

    private void paintProgressIndicator(SeaGlassContext context, Graphics2D g2d, int width, int height, int size, boolean isFinished) {
        JProgressBar pBar = (JProgressBar)context.getComponent();
        if (this.tileWhenIndeterminate && pBar.isIndeterminate()) {
            double offsetFraction = (double)this.getAnimationIndex() / (double)this.getFrameCount();
            int offset = (int)(offsetFraction * (double)this.tileWidth);
            if (pBar.getOrientation() == 0) {
                if (!SeaGlassLookAndFeel.isLeftToRight(pBar)) {
                    offset = this.tileWidth - offset;
                }
                for (int i = -this.tileWidth + offset; i <= width; i += this.tileWidth) {
                    context.getPainter().paintProgressBarForeground(context, g2d, i, 0, this.tileWidth, height, pBar.getOrientation());
                }
            } else {
                for (int i = -offset; i < height + this.tileWidth; i += this.tileWidth) {
                    context.getPainter().paintProgressBarForeground(context, g2d, 0, i, width, this.tileWidth, pBar.getOrientation());
                }
            }
        } else if (pBar.getOrientation() == 0) {
            int start = 0;
            if (isFinished) {
                size = width;
            } else if (!SeaGlassLookAndFeel.isLeftToRight(pBar)) {
                start = width - size;
            }
            context.getPainter().paintProgressBarForeground(context, g2d, start, 0, size, height, pBar.getOrientation());
        } else {
            int start = height;
            if (isFinished) {
                size = height;
            }
            context.getPainter().paintProgressBarForeground(context, g2d, 0, start, width, size, pBar.getOrientation());
        }
    }

    protected void paintText(SeaGlassContext context, Graphics g, String title) {
        if (this.progressBar.isStringPainted()) {
            SynthStyle style = context.getStyle();
            Font font = style.getFont(context);
            FontMetrics fm = SwingUtilities2.getFontMetrics(this.progressBar, g, font);
            int strLength = style.getGraphicsUtils(context).computeStringWidth(context, font, fm, title);
            Rectangle bounds = this.progressBar.getBounds();
            if (this.rotateText && this.progressBar.getOrientation() == 1) {
                Point textPos;
                AffineTransform rotation;
                Graphics2D g2 = (Graphics2D)g;
                if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                    rotation = AffineTransform.getRotateInstance(-1.5707963267948966);
                    textPos = new Point((bounds.width + fm.getAscent() - fm.getDescent()) / 2, (bounds.height + strLength) / 2);
                } else {
                    rotation = AffineTransform.getRotateInstance(1.5707963267948966);
                    textPos = new Point((bounds.width - fm.getAscent() + fm.getDescent()) / 2, (bounds.height - strLength) / 2);
                }
                if (textPos.x < 0) {
                    return;
                }
                font = font.deriveFont(rotation);
                g2.setFont(font);
                g2.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
                style.getGraphicsUtils(context).paintText(context, g, title, textPos.x, textPos.y, -1);
            } else {
                Rectangle textRect = new Rectangle(bounds.width / 2 - strLength / 2, (bounds.height - (fm.getAscent() + fm.getDescent())) / 2 + 1, 0, 0);
                if (textRect.y < 0) {
                    return;
                }
                g.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
                g.setFont(font);
                style.getGraphicsUtils(context).paintText(context, g, title, textRect.x, textRect.y, -1);
            }
        }
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintProgressBarBorder(context, g, x, y, w, h, this.progressBar.getOrientation());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(e) || "indeterminate".equals(e.getPropertyName())) {
            this.updateStyle((JProgressBar)e.getSource());
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String scaleKey;
        int stringWidth;
        Dimension size = null;
        Insets border = this.progressBar.getInsets();
        FontMetrics fontSizer = this.progressBar.getFontMetrics(this.progressBar.getFont());
        String progString = this.progressBar.getString();
        int stringHeight = fontSizer.getHeight() + fontSizer.getDescent();
        if (this.progressBar.getOrientation() == 0) {
            size = new Dimension(this.getPreferredInnerHorizontal());
            if (this.progressBar.isStringPainted()) {
                if (stringHeight > size.height) {
                    size.height = stringHeight;
                }
                if ((stringWidth = SwingUtilities2.stringWidth(this.progressBar, fontSizer, progString)) > size.width) {
                    size.width = stringWidth;
                }
            }
        } else {
            size = new Dimension(this.getPreferredInnerVertical());
            if (this.progressBar.isStringPainted()) {
                if (stringHeight > size.width) {
                    size.width = stringHeight;
                }
                if ((stringWidth = SwingUtilities2.stringWidth(this.progressBar, fontSizer, progString)) > size.height) {
                    size.height = stringWidth;
                }
            }
        }
        if ((scaleKey = SeaGlassStyle.getSizeVariant(this.progressBar)) != null) {
            if ("large".equals(scaleKey)) {
                size.width = (int)((float)size.width * 1.15f);
                size.height = (int)((float)size.height * 1.15f);
            } else if ("small".equals(scaleKey)) {
                size.width = (int)((float)size.width * 0.9f);
                size.height = (int)((float)size.height * 0.9f);
            } else if ("mini".equals(scaleKey)) {
                size.width = (int)((float)size.width * 0.784f);
                size.height = (int)((float)size.height * 0.784f);
            }
        }
        size.width += border.left + border.right;
        size.height += border.top + border.bottom;
        return size;
    }
}

