/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.ui.SeaglassUI;
import com.seaglasslookandfeel.util.PlatformUtils;
import com.seaglasslookandfeel.util.WindowUtils;
import java.awt.Graphics;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.DefaultMenuLayout;
import javax.swing.plaf.synth.SynthContext;

public class SeaGlassPopupMenuUI
extends BasicPopupMenuUI
implements PropertyChangeListener,
SeaglassUI {
    private int maxTextWidth;
    private int maxAcceleratorWidth;
    private int maxTextOffset;
    private int maxIconOffset;
    private SeaGlassStyle style;

    public static ComponentUI createUI(JComponent x) {
        return new SeaGlassPopupMenuUI();
    }

    @Override
    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
            this.popupMenu.setOpaque(false);
        }
        this.updateStyle(this.popupMenu);
    }

    private void updateStyle(JComponent c) {
        SeaGlassContext context = this.getContext(c, 1);
        Window window = SwingUtilities.getWindowAncestor(this.popupMenu);
        if (PlatformUtils.isMac() && window != null) {
            WindowUtils.makeWindowNonOpaque(window);
        }
        SeaGlassStyle oldStyle = this.style;
        this.style = (SeaGlassStyle)SeaGlassLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle && oldStyle != null) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
        context.dispose();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.popupMenu.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallDefaults() {
        SeaGlassContext context = this.getContext(this.popupMenu, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        if (this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(null);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removePropertyChangeListener(this);
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    void resetAlignmentHints() {
        this.maxIconOffset = 0;
        this.maxTextOffset = 0;
        this.maxAcceleratorWidth = 0;
        this.maxTextWidth = 0;
    }

    int adjustTextWidth(int width) {
        this.maxTextWidth = Math.max(this.maxTextWidth, width);
        return this.maxTextWidth;
    }

    int adjustAcceleratorWidth(int width) {
        this.maxAcceleratorWidth = Math.max(this.maxAcceleratorWidth, width);
        return this.maxAcceleratorWidth;
    }

    int getMaxTextWidth() {
        return this.maxTextWidth;
    }

    int getMaxAcceleratorWidth() {
        return this.maxAcceleratorWidth;
    }

    int adjustTextOffset(int offset) {
        this.maxTextOffset = Math.max(this.maxTextOffset, offset);
        return this.maxTextOffset;
    }

    int adjustIconOffset(int offset) {
        this.maxIconOffset = Math.max(this.maxIconOffset, offset);
        return this.maxIconOffset;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintPopupMenuBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintPopupMenuBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle(this.popupMenu);
        }
    }
}

