/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPanelUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class SeaGlassPanelUI
extends BasicPanelUI
implements PropertyChangeListener,
SeaglassUI {
    private SynthStyle style;
    private boolean originalOpacity;

    public static ComponentUI createUI(JComponent c) {
        return new SeaGlassPanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        JPanel p = (JPanel)c;
        super.installUI(c);
        this.installListeners(p);
    }

    @Override
    public void uninstallUI(JComponent c) {
        JPanel p = (JPanel)c;
        this.uninstallListeners(p);
        super.uninstallUI(c);
    }

    protected void installListeners(JPanel p) {
        p.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(JPanel p) {
        p.removePropertyChangeListener(this);
    }

    @Override
    protected void installDefaults(JPanel p) {
        this.originalOpacity = p.isOpaque();
        this.updateStyle(p);
    }

    @Override
    protected void uninstallDefaults(JPanel p) {
        SeaGlassContext context = this.getContext(p, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        LookAndFeel.installProperty(p, "opaque", this.originalOpacity);
    }

    private void updateStyle(JPanel c) {
        SeaGlassContext context = this.getContext(c, 1);
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        context.dispose();
        LookAndFeel.installProperty(c, "opaque", !(c.getBackground() instanceof UIResource));
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintPanelBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintPanelBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(pce)) {
            this.updateStyle((JPanel)pce.getSource());
        } else if (pce.getPropertyName() == "background") {
            this.updateStyle((JPanel)pce.getSource());
        }
    }
}

