/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.component.SeaGlassIcon;
import com.seaglasslookandfeel.ui.SeaGlassPopupMenuUI;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class SeaGlassMenuItemUI
extends BasicMenuItemUI
implements PropertyChangeListener,
SeaglassUI {
    private SynthStyle style;
    private SynthStyle accStyle;
    private String acceleratorDelimiter;
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new SeaGlassMenuItemUI();
    }

    static Dimension getPreferredMenuItemSize(SeaGlassContext context, SeaGlassContext accContext, boolean useCheckAndArrow, JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap, String acceleratorDelimiter) {
        JMenuItem b = (JMenuItem)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Font font = context.getStyle().getFont(context);
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(accContext.getStyle().getFont(accContext));
        SeaGlassMenuItemUI.resetRects();
        SeaGlassMenuItemUI.layoutMenuItem(context, fm, accContext, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap, useCheckAndArrow);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(SeaGlassMenuItemUI.iconRect.x, SeaGlassMenuItemUI.iconRect.y, SeaGlassMenuItemUI.iconRect.width, SeaGlassMenuItemUI.iconRect.height, r);
        Container parent = b.getParent();
        if (parent instanceof JPopupMenu) {
            SeaGlassPopupMenuUI popupUI = (SeaGlassPopupMenuUI)SeaGlassLookAndFeel.getUIOfType(((JPopupMenu)parent).getUI(), SeaGlassPopupMenuUI.class);
            if (popupUI != null) {
                SeaGlassMenuItemUI.r.width = popupUI.adjustTextWidth(SeaGlassMenuItemUI.r.width);
                popupUI.adjustAcceleratorWidth(SeaGlassMenuItemUI.acceleratorRect.width);
                SeaGlassMenuItemUI.r.width += popupUI.getMaxAcceleratorWidth();
            }
        } else if (!(parent == null || b instanceof JMenu && ((JMenu)b).isTopLevelMenu())) {
            SeaGlassMenuItemUI.r.width += SeaGlassMenuItemUI.acceleratorRect.width;
        }
        if (useCheckAndArrow) {
            SeaGlassMenuItemUI.r.width += SeaGlassMenuItemUI.checkIconRect.width;
            SeaGlassMenuItemUI.r.width += defaultTextIconGap;
            SeaGlassMenuItemUI.r.width += defaultTextIconGap;
            SeaGlassMenuItemUI.r.width += SeaGlassMenuItemUI.arrowIconRect.width;
        }
        SeaGlassMenuItemUI.r.width += 2 * defaultTextIconGap;
        Insets insets = b.getInsets();
        if (insets != null) {
            SeaGlassMenuItemUI.r.width += insets.left + insets.right;
            SeaGlassMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (SeaGlassMenuItemUI.r.width % 2 == 0) {
            ++SeaGlassMenuItemUI.r.width;
        }
        if (SeaGlassMenuItemUI.r.height % 2 == 0) {
            ++SeaGlassMenuItemUI.r.height;
        }
        return r.getSize();
    }

    static void paint(SeaGlassContext context, SeaGlassContext accContext, Graphics g, Icon checkIcon, Icon arrowIcon, boolean useCheckAndArrow, String acceleratorDelimiter, int defaultTextIconGap) {
        JComponent c = context.getComponent();
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        Insets i = b.getInsets();
        SeaGlassMenuItemUI.resetRects();
        viewRect.setBounds(0, 0, b.getWidth(), b.getHeight());
        SeaGlassMenuItemUI.viewRect.x += i.left;
        SeaGlassMenuItemUI.viewRect.y += i.top;
        SeaGlassMenuItemUI.viewRect.width -= i.right + SeaGlassMenuItemUI.viewRect.x;
        SeaGlassMenuItemUI.viewRect.height -= i.bottom + SeaGlassMenuItemUI.viewRect.y;
        SynthStyle style = context.getStyle();
        Font f = style.getFont(context);
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        FontMetrics accFM = SwingUtilities2.getFontMetrics(c, g, accContext.getStyle().getFont(accContext));
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text = SeaGlassMenuItemUI.layoutMenuItem(context, fm, accContext, b.getText(), accFM, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap, useCheckAndArrow);
        if (checkIcon != null && useCheckAndArrow) {
            SeaGlassIcon.paintIcon((Icon)checkIcon, (SynthContext)context, (Graphics)g, (int)SeaGlassMenuItemUI.checkIconRect.x, (int)SeaGlassMenuItemUI.checkIconRect.y, (int)SeaGlassMenuItemUI.checkIconRect.width, (int)SeaGlassMenuItemUI.checkIconRect.height);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                SeaGlassIcon.paintIcon((Icon)icon, (SynthContext)context, (Graphics)g, (int)SeaGlassMenuItemUI.iconRect.x, (int)SeaGlassMenuItemUI.iconRect.y, (int)SeaGlassMenuItemUI.iconRect.width, (int)SeaGlassMenuItemUI.iconRect.height);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                g.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
                g.setFont(style.getFont(context));
                style.getGraphicsUtils(context).paintText(context, g, text, SeaGlassMenuItemUI.textRect.x, SeaGlassMenuItemUI.textRect.y, b.getDisplayedMnemonicIndex());
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int max;
            SeaGlassPopupMenuUI popupUI;
            int accOffset = 0;
            Container parent = b.getParent();
            if (parent != null && parent instanceof JPopupMenu && (popupUI = (SeaGlassPopupMenuUI)((JPopupMenu)parent).getUI()) != null && (max = popupUI.getMaxAcceleratorWidth()) > 0) {
                accOffset = max - SeaGlassMenuItemUI.acceleratorRect.width;
            }
            SynthStyle accStyle = accContext.getStyle();
            g.setColor(accStyle.getColor(accContext, ColorType.TEXT_FOREGROUND));
            g.setFont(accStyle.getFont(accContext));
            accStyle.getGraphicsUtils(accContext).paintText(accContext, g, acceleratorText, SeaGlassMenuItemUI.acceleratorRect.x - accOffset, SeaGlassMenuItemUI.acceleratorRect.y, -1);
        }
        if (arrowIcon != null && useCheckAndArrow) {
            SeaGlassIcon.paintIcon((Icon)arrowIcon, (SynthContext)context, (Graphics)g, (int)SeaGlassMenuItemUI.arrowIconRect.x, (int)SeaGlassMenuItemUI.arrowIconRect.y, (int)SeaGlassMenuItemUI.arrowIconRect.width, (int)SeaGlassMenuItemUI.arrowIconRect.height);
        }
    }

    private static String layoutMenuItem(SeaGlassContext context, FontMetrics fm, SeaGlassContext accContext, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap, boolean useCheckAndArrow) {
        SeaGlassPopupMenuUI popupUI = null;
        JComponent b = context.getComponent();
        Container parent = b.getParent();
        if (parent instanceof JPopupMenu) {
            popupUI = (SeaGlassPopupMenuUI)SeaGlassLookAndFeel.getUIOfType(((JPopupMenu)parent).getUI(), SeaGlassPopupMenuUI.class);
        }
        context.getStyle().getGraphicsUtils(context).layoutText(context, fm, text, icon, horizontalAlignment, verticalAlignment, horizontalTextPosition, verticalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            SynthStyle style = accContext.getStyle();
            acceleratorRect.width = style.getGraphicsUtils(accContext).computeStringWidth(accContext, fmAccel.getFont(), fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (useCheckAndArrow) {
            if (checkIcon != null) {
                checkIconRect.width = SeaGlassIcon.getIconWidth((Icon)checkIcon, (SynthContext)context);
                checkIconRect.height = SeaGlassIcon.getIconHeight((Icon)checkIcon, (SynthContext)context);
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = SeaGlassIcon.getIconWidth((Icon)arrowIcon, (SynthContext)context);
                arrowIconRect.height = SeaGlassIcon.getIconHeight((Icon)arrowIcon, (SynthContext)context);
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (SeaGlassLookAndFeel.isLeftToRight(context.getComponent())) {
            textRect.x += menuItemGap;
            iconRect.x += menuItemGap;
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
            if (useCheckAndArrow) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
            if (popupUI != null) {
                int thisTextOffset = popupUI.adjustTextOffset(textRect.x - viewRect.x);
                textRect.x = thisTextOffset + viewRect.x;
                if (icon != null) {
                    if (horizontalTextPosition == 11 || horizontalTextPosition == 4) {
                        int thisIconOffset = popupUI.adjustIconOffset(iconRect.x - viewRect.x);
                        iconRect.x = thisIconOffset + viewRect.x;
                    } else if (horizontalTextPosition == 10 || horizontalTextPosition == 2) {
                        iconRect.x = textRect.x + textRect.width + menuItemGap;
                    } else {
                        int maxIconValue = popupUI.adjustIconOffset(0);
                        iconRect.x = Math.max(textRect.x + textRect.width / 2 - iconRect.width / 2, maxIconValue + viewRect.x);
                    }
                }
            }
        } else {
            textRect.x -= menuItemGap;
            iconRect.x -= menuItemGap;
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;
            if (useCheckAndArrow) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
            if (popupUI != null) {
                int thisTextOffset = viewRect.x + viewRect.width - textRect.x - textRect.width;
                thisTextOffset = popupUI.adjustTextOffset(thisTextOffset);
                textRect.x = viewRect.x + viewRect.width - thisTextOffset - textRect.width;
                if (icon != null) {
                    if (horizontalTextPosition == 11 || horizontalTextPosition == 2) {
                        int thisIconOffset = viewRect.x + viewRect.width - iconRect.x - iconRect.width;
                        thisIconOffset = popupUI.adjustIconOffset(thisIconOffset);
                        iconRect.x = viewRect.x + viewRect.width - thisIconOffset - iconRect.width;
                    } else if (horizontalTextPosition == 10 || horizontalTextPosition == 4) {
                        iconRect.x = textRect.x - menuItemGap - iconRect.width;
                    } else {
                        int maxIconValue = popupUI.adjustIconOffset(0);
                        iconRect.x = textRect.x + textRect.width / 2 - iconRect.width / 2;
                        if (iconRect.x + iconRect.width > viewRect.x + viewRect.width - maxIconValue) {
                            iconRect.x = iconRect.x = viewRect.x + viewRect.width - maxIconValue - iconRect.width;
                        }
                    }
                }
            }
        }
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (useCheckAndArrow) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        return text;
    }

    private static void resetRects() {
        iconRect.setBounds(0, 0, 0, 0);
        textRect.setBounds(0, 0, 0, 0);
        acceleratorRect.setBounds(0, 0, 0, 0);
        checkIconRect.setBounds(0, 0, 0, 0);
        arrowIconRect.setBounds(0, 0, 0, 0);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(0, 0, 0, 0);
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem mi) {
        SeaGlassContext context = this.getContext((JComponent)mi, 1);
        SynthStyle oldStyle = this.style;
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        if (oldStyle != this.style) {
            String prefix = this.getPropertyPrefix();
            Object value = this.style.get(context, prefix + ".textIconGap");
            if (value != null) {
                LookAndFeel.installProperty(mi, "iconTextGap", value);
            }
            this.defaultTextIconGap = mi.getIconTextGap();
            if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
                Insets insets = (Insets)this.style.get(context, prefix + ".margin");
                if (insets == null) {
                    insets = SeaGlassLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                this.menuItem.setMargin(insets);
            }
            this.acceleratorDelimiter = this.style.getString(context, prefix + ".acceleratorDelimiter", "+");
            this.arrowIcon = this.style.getIcon(context, prefix + ".arrowIcon");
            this.checkIcon = this.style.getIcon(context, prefix + ".checkIcon");
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        context.dispose();
        SeaGlassContext accContext = this.getContext(mi, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle = SeaGlassLookAndFeel.updateStyle(accContext, this);
        accContext.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SeaGlassContext context = this.getContext((JComponent)this.menuItem, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        SeaGlassContext accContext = this.getContext(this.menuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle.uninstallDefaults(accContext);
        accContext.dispose();
        this.accStyle = null;
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    public SeaGlassContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SeaGlassContext getContext(JComponent c, Region region, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, region, this.accStyle, state);
    }

    private int getComponentState(JComponent c) {
        int state = !c.isEnabled() ? 8 : (this.menuItem.isArmed() ? 2 : SeaGlassLookAndFeel.getComponentState(c));
        if (this.menuItem.isSelected()) {
            state |= 0x200;
        }
        return state;
    }

    private int getComponentState(JComponent c, Region region) {
        return this.getComponentState(c);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassContext accContext = this.getContext(c, Region.MENU_ITEM_ACCELERATOR);
        Dimension value = SeaGlassMenuItemUI.getPreferredMenuItemSize(context, accContext, true, c, checkIcon, arrowIcon, defaultTextIconGap, this.acceleratorDelimiter);
        context.dispose();
        accContext.dispose();
        return value;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        this.paintBackground(context, g, c);
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
        SeaGlassContext accContext = this.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        String prefix = this.getPropertyPrefix();
        Icon arIcon = this.style.getIcon(this.getContext(context.getComponent()), prefix + ".arrowIcon");
        SeaGlassMenuItemUI.paint(context, accContext, g, this.style.getIcon(this.getContext(context.getComponent()), prefix + ".checkIcon"), arIcon, true, this.acceleratorDelimiter, this.defaultTextIconGap);
        accContext.dispose();
    }

    void paintBackground(SeaGlassContext context, Graphics g, JComponent c) {
        context.getPainter().paintMenuItemBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintMenuItemBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JMenuItem)e.getSource());
        }
    }
}

