/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.component.SeaGlassInternalFrameTitlePane;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class SeaGlassDesktopIconUI
extends BasicDesktopIconUI
implements SeaglassUI,
ActionListener,
PropertyChangeListener {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent c) {
        return new SeaGlassDesktopIconUI();
    }

    @Override
    protected void installComponents() {
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            this.iconPane = new JToggleButton(this.frame.getTitle(), this.frame.getFrameIcon()){

                @Override
                public String getToolTipText() {
                    return this.getText();
                }

                @Override
                public JPopupMenu getComponentPopupMenu() {
                    return SeaGlassDesktopIconUI.this.frame.getComponentPopupMenu();
                }
            };
            ToolTipManager.sharedInstance().registerComponent(this.iconPane);
            this.iconPane.setFont(this.desktopIcon.getFont());
            this.iconPane.setBackground(this.desktopIcon.getBackground());
            this.iconPane.setForeground(this.desktopIcon.getForeground());
        } else {
            this.iconPane = new SeaGlassInternalFrameTitlePane(this.frame);
            this.iconPane.setName("InternalFrame.northPane");
        }
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.desktopIcon.addPropertyChangeListener(this);
        if (this.iconPane instanceof JToggleButton) {
            this.frame.addPropertyChangeListener(this);
            ((JToggleButton)this.iconPane).addActionListener(this);
        }
    }

    @Override
    protected void uninstallListeners() {
        if (this.iconPane instanceof JToggleButton) {
            this.frame.removePropertyChangeListener(this);
        }
        this.desktopIcon.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.desktopIcon);
    }

    private void updateStyle(JComponent c) {
        SeaGlassContext context = this.getContext(c, 1);
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        context.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SeaGlassContext context = this.getContext(this.desktopIcon, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        Region region = this.getRegion(c);
        return SeaGlassContext.getContext(SeaGlassContext.class, c, region, this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    Region getRegion(JComponent c) {
        return SeaGlassLookAndFeel.getRegion(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintDesktopIconBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintDesktopIconBorder(context, g, x, y, w, h);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JToggleButton) {
            JToggleButton button = (JToggleButton)evt.getSource();
            try {
                boolean selected = button.isSelected();
                if (!selected && !this.frame.isIconifiable()) {
                    button.setSelected(true);
                } else {
                    this.frame.setIcon(!selected);
                    if (selected) {
                        this.frame.setSelected(true);
                    }
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof JInternalFrame.JDesktopIcon) {
            if (SeaGlassLookAndFeel.shouldUpdateStyle(evt)) {
                this.updateStyle((JInternalFrame.JDesktopIcon)evt.getSource());
            }
        } else if (evt.getSource() instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)evt.getSource();
            if (this.iconPane instanceof JToggleButton) {
                JToggleButton button = (JToggleButton)this.iconPane;
                String prop = evt.getPropertyName();
                if (prop == "title") {
                    button.setText((String)evt.getNewValue());
                } else if (prop == "frameIcon") {
                    button.setIcon((Icon)evt.getNewValue());
                } else if (prop == "icon" || prop == "selected") {
                    button.setSelected(!frame.isIcon() && frame.isSelected());
                }
            }
        }
    }
}

