/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.ui;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.component.SeaGlassArrowButton;
import com.seaglasslookandfeel.component.SeaGlassComboPopup;
import com.seaglasslookandfeel.ui.SeaGlassLabelUI;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.synth.SynthContext;

public class SeaGlassComboBoxUI
extends BasicComboBoxUI
implements PropertyChangeListener,
SeaglassUI {
    private SeaGlassStyle style;
    private boolean useListColors;
    Insets popupInsets;
    private boolean buttonWhenNotEditable;
    private boolean pressedWhenPopupVisible;
    private ButtonHandler buttonHandler;
    private EditorFocusHandler editorFocusHandler;
    private boolean forceOpaque = false;
    private Insets padding;

    public static ComponentUI createUI(JComponent c) {
        return new SeaGlassComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.buttonHandler = new ButtonHandler();
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        String scaleKey;
        super.installDefaults();
        this.padding = UIManager.getInsets("ComboBox.padding");
        if (this.padding != null && (scaleKey = SeaGlassStyle.getSizeVariant(this.comboBox)) != null) {
            if ("large".equals(scaleKey)) {
                this.padding.left = (int)((double)this.padding.left * 1.15);
                this.padding.right = (int)((double)this.padding.right * 1.15);
                this.padding.bottom = (int)((double)this.padding.bottom * 1.15);
                this.padding.top = (int)((double)this.padding.top * 1.15);
            } else if ("small".equals(scaleKey)) {
                this.padding.left = (int)((double)this.padding.left * 0.857);
                this.padding.right = (int)((double)this.padding.right * 0.857);
                this.padding.bottom = (int)((double)this.padding.bottom * 0.857);
                this.padding.top = (int)((double)this.padding.top * 0.857);
            } else if ("mini".equals(scaleKey)) {
                this.padding.left = (int)((double)this.padding.left * 0.784);
                this.padding.right = (int)((double)this.padding.right * 0.784);
                this.padding.bottom = (int)((double)this.padding.bottom * 0.784);
                this.padding.top = (int)((double)this.padding.top * 0.784);
            }
        }
        this.updateStyle(this.comboBox);
    }

    private void updateStyle(JComboBox comboBox) {
        SeaGlassStyle oldStyle = this.style;
        SeaGlassContext context = this.getContext(comboBox, 1);
        this.style = (SeaGlassStyle)SeaGlassLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.popupInsets = (Insets)this.style.get(context, "ComboBox.popupInsets");
            this.useListColors = this.style.getBoolean(context, "ComboBox.rendererUseListColors", true);
            this.buttonWhenNotEditable = this.style.getBoolean(context, "ComboBox.buttonWhenNotEditable", false);
            this.pressedWhenPopupVisible = this.style.getBoolean(context, "ComboBox.pressedWhenPopupVisible", false);
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
            this.forceOpaque = this.style.getBoolean(context, "ComboBox.forceOpaque", false);
        }
        context.dispose();
    }

    @Override
    protected void installListeners() {
        this.comboBox.addPropertyChangeListener(this);
        this.comboBox.addMouseListener(this.buttonHandler);
        this.editorFocusHandler = new EditorFocusHandler(this.comboBox);
        super.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this.popup instanceof SeaGlassComboPopup) {
            ((SeaGlassComboPopup)this.popup).removePopupMenuListener(this.buttonHandler);
        }
        super.uninstallUI(c);
        this.buttonHandler = null;
    }

    @Override
    protected void uninstallDefaults() {
        SeaGlassContext context = this.getContext(this.comboBox, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    protected void uninstallListeners() {
        this.editorFocusHandler.unregister();
        this.comboBox.removePropertyChangeListener(this);
        this.comboBox.removeMouseListener(this.buttonHandler);
        this.buttonHandler.pressed = false;
        this.buttonHandler.over = false;
        super.uninstallListeners();
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        if (!(c instanceof JComboBox)) {
            return SeaGlassLookAndFeel.getComponentState(c);
        }
        JComboBox box = (JComboBox)c;
        if (this.shouldActLikeButton()) {
            int state = 1;
            if (!c.isEnabled()) {
                state = 8;
            }
            if (this.buttonHandler.isPressed()) {
                state |= 4;
            }
            if (this.buttonHandler.isRollover()) {
                state |= 2;
            }
            if (box.isFocusOwner()) {
                state |= 0x100;
            }
            return state;
        }
        int basicState = SeaGlassLookAndFeel.getComponentState(c);
        if (box.isEditable() && box.getEditor().getEditorComponent().isFocusOwner()) {
            basicState |= 0x100;
        }
        return basicState;
    }

    @Override
    protected ComboPopup createPopup() {
        SeaGlassComboPopup p = new SeaGlassComboPopup(this.comboBox);
        p.addPopupMenuListener(this.buttonHandler);
        return p;
    }

    protected ListCellRenderer createRenderer() {
        return new SynthComboBoxRenderer();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new SynthComboBoxEditor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SeaGlassLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle(this.comboBox);
        }
    }

    @Override
    protected JButton createArrowButton() {
        SeaGlassArrowButton button = new SeaGlassArrowButton(5);
        button.setName("ComboBox.arrowButton");
        button.setModel(this.buttonHandler);
        return button;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintComboBoxBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SeaGlassContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SeaGlassContext context, Graphics g) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintComboBoxBorder(context, g, x, y, w, h);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        boolean force;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        if (c instanceof UIResource) {
            c.setName("ComboBox.renderer");
        }
        boolean bl = force = this.forceOpaque && c instanceof JComponent;
        if (force) {
            ((JComponent)c).setOpaque(false);
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        if (this.padding != null) {
            x = bounds.x + this.padding.left;
            y = bounds.y + this.padding.top;
            w = bounds.width - (this.padding.left + this.padding.right);
            h = bounds.height - (this.padding.top + this.padding.bottom);
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, x, y, w, h, shouldValidate);
        if (force) {
            ((JComponent)c).setOpaque(true);
        }
    }

    private boolean shouldActLikeButton() {
        return this.buttonWhenNotEditable && !this.comboBox.isEditable();
    }

    @Override
    protected Dimension getDefaultSize() {
        SynthComboBoxRenderer r = new SynthComboBoxRenderer();
        Dimension d = this.getSizeForComponent(r.getListCellRendererComponent(this.listBox, " ", -1, false, false));
        return new Dimension(d.width, d.height);
    }

    @Override
    protected Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    private static class EditorFocusHandler
    implements FocusListener,
    PropertyChangeListener {
        private JComboBox comboBox;
        private ComboBoxEditor editor = null;
        private Component editorComponent = null;

        private EditorFocusHandler(JComboBox comboBox) {
            this.comboBox = comboBox;
            this.editor = comboBox.getEditor();
            if (this.editor != null) {
                this.editorComponent = this.editor.getEditorComponent();
                if (this.editorComponent != null) {
                    this.editorComponent.addFocusListener(this);
                }
            }
            comboBox.addPropertyChangeListener("editor", this);
        }

        public void unregister() {
            this.comboBox.removePropertyChangeListener(this);
            if (this.editorComponent != null) {
                this.editorComponent.removeFocusListener(this);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.comboBox.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.comboBox.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ComboBoxEditor newEditor = this.comboBox.getEditor();
            if (this.editor != newEditor) {
                if (this.editorComponent != null) {
                    this.editorComponent.removeFocusListener(this);
                }
                this.editor = newEditor;
                if (this.editor != null) {
                    this.editorComponent = this.editor.getEditorComponent();
                    if (this.editorComponent != null) {
                        this.editorComponent.addFocusListener(this);
                    }
                }
            }
        }
    }

    private final class ButtonHandler
    extends DefaultButtonModel
    implements MouseListener,
    PopupMenuListener {
        private boolean over;
        private boolean pressed;

        private ButtonHandler() {
        }

        private void updatePressed(boolean p) {
            boolean bl = this.pressed = p && this.isEnabled();
            if (SeaGlassComboBoxUI.this.shouldActLikeButton()) {
                SeaGlassComboBoxUI.this.comboBox.repaint();
            }
        }

        private void updateOver(boolean o) {
            boolean old = this.isRollover();
            this.over = o && this.isEnabled();
            boolean newo = this.isRollover();
            if (SeaGlassComboBoxUI.this.shouldActLikeButton() && old != newo) {
                SeaGlassComboBoxUI.this.comboBox.repaint();
            }
        }

        @Override
        public boolean isPressed() {
            boolean b = SeaGlassComboBoxUI.this.shouldActLikeButton() ? this.pressed : super.isPressed();
            return b || SeaGlassComboBoxUI.this.pressedWhenPopupVisible && SeaGlassComboBoxUI.this.comboBox.isPopupVisible();
        }

        @Override
        public boolean isArmed() {
            boolean b = SeaGlassComboBoxUI.this.shouldActLikeButton() || SeaGlassComboBoxUI.this.pressedWhenPopupVisible && SeaGlassComboBoxUI.this.comboBox.isPopupVisible();
            return b ? this.isPressed() : super.isArmed();
        }

        @Override
        public boolean isRollover() {
            return SeaGlassComboBoxUI.this.shouldActLikeButton() ? this.over : super.isRollover();
        }

        @Override
        public void setPressed(boolean b) {
            super.setPressed(b);
            this.updatePressed(b);
        }

        @Override
        public void setRollover(boolean b) {
            super.setRollover(b);
            this.updateOver(b);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.updateOver(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.updateOver(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.updatePressed(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.updatePressed(false);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            if (SeaGlassComboBoxUI.this.shouldActLikeButton() || SeaGlassComboBoxUI.this.pressedWhenPopupVisible) {
                SeaGlassComboBoxUI.this.comboBox.repaint();
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    }

    private static class SynthComboBoxEditor
    implements ComboBoxEditor,
    UIResource {
        protected JTextField editor = new JTextField("", 9);
        private Object oldValue;

        public SynthComboBoxEditor() {
            this.editor.setName("ComboBox.textField");
        }

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        @Override
        public void setItem(Object anObject) {
            String text;
            if (anObject != null) {
                text = anObject.toString();
                this.oldValue = anObject;
            } else {
                text = "";
            }
            if (!text.equals(this.editor.getText())) {
                this.editor.setText(text);
            }
        }

        @Override
        public Object getItem() {
            Object newValue = this.editor.getText();
            if (this.oldValue != null && !(this.oldValue instanceof String)) {
                if (newValue.equals(this.oldValue.toString())) {
                    return this.oldValue;
                }
                Class<?> cls = this.oldValue.getClass();
                try {
                    Method method = cls.getMethod("valueOf", String.class);
                    newValue = method.invoke(this.oldValue, this.editor.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return newValue;
        }

        @Override
        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.editor.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.editor.removeActionListener(l);
        }
    }

    private class SynthComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public SynthComboBoxRenderer() {
            this.setName("ComboBox.renderer");
            this.setText(" ");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            SeaGlassLookAndFeel.resetSelectedUI();
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (!SeaGlassComboBoxUI.this.useListColors) {
                    SeaGlassLookAndFeel.setSelectedUI((SeaGlassLabelUI)SeaGlassLookAndFeel.getUIOfType(this.getUI(), SeaGlassLabelUI.class), isSelected, cellHasFocus, list.isEnabled(), false);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else {
                String text;
                String string = text = value == null ? " " : value.toString();
                if ("".equals(text)) {
                    text = " ";
                }
                this.setText(text);
            }
            if (SeaGlassComboBoxUI.this.comboBox != null) {
                this.setEnabled(SeaGlassComboBoxUI.this.comboBox.isEnabled());
                this.setComponentOrientation(SeaGlassComboBoxUI.this.comboBox.getComponentOrientation());
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            SeaGlassLookAndFeel.resetSelectedUI();
        }
    }
}

