/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.state;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public abstract class State<T extends JComponent> {
    static final Map<String, StandardState> standardStates = new HashMap<String, StandardState>(7);
    public static final State Enabled = new StandardState(1);
    public static final State MouseOver = new StandardState(2);
    public static final State Pressed = new StandardState(4);
    public static final State Disabled = new StandardState(8);
    public static final State Focused = new StandardState(256);
    public static final State Selected = new StandardState(512);
    public static final State Default = new StandardState(1024);
    private String name;

    protected State(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isInState(T c, int s) {
        return this.isInState(c);
    }

    public abstract boolean isInState(T var1);

    public String getName() {
        return this.name;
    }

    public static boolean isStandardStateName(String name) {
        return standardStates.containsKey(name);
    }

    public static StandardState getStandardState(String name) {
        return standardStates.get(name);
    }

    public static final class StandardState
    extends State<JComponent> {
        private int state;

        private StandardState(int state) {
            super(StandardState.toString(state));
            this.state = state;
            standardStates.put(this.getName(), this);
        }

        public int getState() {
            return this.state;
        }

        @Override
        public boolean isInState(JComponent c, int s) {
            return (s & this.state) == this.state;
        }

        @Override
        public boolean isInState(JComponent c) {
            throw new AssertionError((Object)"This method should never be called");
        }

        private static String toString(int state) {
            StringBuffer buffer = new StringBuffer();
            if ((state & 0x400) == 1024) {
                buffer.append("Default");
            }
            if ((state & 8) == 8) {
                if (buffer.length() > 0) {
                    buffer.append("+");
                }
                buffer.append("Disabled");
            }
            if ((state & 1) == 1) {
                if (buffer.length() > 0) {
                    buffer.append("+");
                }
                buffer.append("Enabled");
            }
            if ((state & 0x100) == 256) {
                if (buffer.length() > 0) {
                    buffer.append("+");
                }
                buffer.append("Focused");
            }
            if ((state & 2) == 2) {
                if (buffer.length() > 0) {
                    buffer.append("+");
                }
                buffer.append("MouseOver");
            }
            if ((state & 4) == 4) {
                if (buffer.length() > 0) {
                    buffer.append("+");
                }
                buffer.append("Pressed");
            }
            if ((state & 0x200) == 512) {
                if (buffer.length() > 0) {
                    buffer.append("+");
                }
                buffer.append("Selected");
            }
            return buffer.toString();
        }
    }
}

