/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter.button;

import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.effect.Effect;
import com.seaglasslookandfeel.effect.SeaGlassDropShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.ButtonPainter;
import com.seaglasslookandfeel.painter.button.ButtonVariantPainter;
import com.seaglasslookandfeel.painter.button.TexturedButtonPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;

public class SegmentedButtonPainter
extends ButtonVariantPainter {
    private Effect dropShadow = new SeaGlassDropShadowEffect();
    private AbstractCommonColorsPainter.CommonControlState type;

    public SegmentedButtonPainter(ButtonPainter.Which state, AbstractRegionPainter.PaintContext ctx) {
        super(state, ctx);
        this.type = this.getButtonType(state);
    }

    @Override
    public void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Shape s;
        SegmentType segmentStatus = this.getSegmentType(c);
        int newHeight = this.getButtonHeight(c, height);
        int yOffset = (height - newHeight) / 2;
        height = newHeight;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = this.focusInsets.left;
        int y = this.focusInsets.top + yOffset;
        width -= this.focusInsets.left + this.focusInsets.right;
        height -= this.focusInsets.top + this.focusInsets.bottom;
        boolean useToolBarFocus = this.isInToolBar(c);
        if (this.focused) {
            s = this.createOuterFocus(segmentStatus, x, y, width, height);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarFocus));
            g.draw(s);
            s = this.createInnerFocus(segmentStatus, x, y, width, height);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarFocus));
            g.draw(s);
        }
        if (!this.isInToolBar(c) || this instanceof TexturedButtonPainter) {
            s = this.createBorder(segmentStatus, x, y, width, height);
            if (!this.focused) {
                this.dropShadow.fill(g, s);
            }
            g.setPaint(this.getCommonBorderPaint(s, this.type));
            g.fill(s);
            s = this.createInterior(segmentStatus, x, y, width, height);
            g.setPaint(this.getCommonInteriorPaint(s, this.type));
            g.fill(s);
        }
    }

    private int getButtonHeight(JComponent c, int height) {
        String scaleKey = SeaGlassStyle.getSizeVariant(c);
        int newHeight = 27;
        if ("natural".equals(scaleKey)) {
            return height;
        }
        if ("large".equals(scaleKey)) {
            newHeight = (int)((double)newHeight * 1.15);
        } else if ("small".equals(scaleKey)) {
            newHeight = (int)((double)newHeight * 0.857);
        } else if ("mini".equals(scaleKey)) {
            newHeight = (int)((double)newHeight * 0.714);
        } else if (height < 22) {
            newHeight = (int)((double)newHeight * 0.714);
        } else if (height < 26) {
            newHeight = (int)((double)newHeight * 0.857);
        } else if (height >= 30) {
            newHeight = (int)((double)newHeight * 1.15);
        }
        return newHeight;
    }

    protected AbstractCommonColorsPainter.CommonControlState getButtonType(ButtonPainter.Which state) {
        switch (state) {
            case BACKGROUND_DEFAULT: 
            case BACKGROUND_DEFAULT_FOCUSED: 
            case BACKGROUND_SELECTED: 
            case BACKGROUND_SELECTED_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.DEFAULT;
            }
            case BACKGROUND_PRESSED_DEFAULT: 
            case BACKGROUND_PRESSED_DEFAULT_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.DEFAULT_PRESSED;
            }
            case BACKGROUND_DISABLED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case BACKGROUND_ENABLED: 
            case BACKGROUND_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_PRESSED: 
            case BACKGROUND_PRESSED_FOCUSED: 
            case BACKGROUND_PRESSED_SELECTED: 
            case BACKGROUND_PRESSED_SELECTED_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED;
            }
            case BACKGROUND_DISABLED_SELECTED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED_SELECTED;
            }
        }
        return null;
    }

    protected SegmentType getSegmentType(JComponent c) {
        Object buttonType = c.getClientProperty("JButton.buttonType");
        SegmentType segmentType = SegmentType.NONE;
        if (buttonType != null && buttonType instanceof String && ((String)buttonType).startsWith("segmented")) {
            String position = (String)c.getClientProperty("JButton.segmentPosition");
            if ("first".equals(position)) {
                segmentType = SegmentType.FIRST;
            } else if ("middle".equals(position)) {
                segmentType = SegmentType.MIDDLE;
            } else if ("last".equals(position)) {
                segmentType = SegmentType.LAST;
            }
        }
        return segmentType;
    }

    protected Shape createOuterFocus(SegmentType segmentType, int x, int y, int w, int h) {
        switch (segmentType) {
            case FIRST: {
                return this.shapeGenerator.createRoundRectangle(x - 2, y - 2, w + 3, h + 3, ShapeGenerator.CornerSize.OUTER_FOCUS, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            }
            case MIDDLE: {
                return this.shapeGenerator.createRectangle(x - 2, y - 2, w + 3, h + 3);
            }
            case LAST: {
                return this.shapeGenerator.createRoundRectangle(x - 2, y - 2, w + 3, h + 3, ShapeGenerator.CornerSize.OUTER_FOCUS, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
            }
        }
        return this.shapeGenerator.createRoundRectangle(x - 2, y - 2, w + 3, h + 3, ShapeGenerator.CornerSize.OUTER_FOCUS);
    }

    protected Shape createInnerFocus(SegmentType segmentType, int x, int y, int w, int h) {
        switch (segmentType) {
            case FIRST: {
                return this.shapeGenerator.createRoundRectangle(x - 1, y - 1, w + 2, h + 1, ShapeGenerator.CornerSize.INNER_FOCUS, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            }
            case MIDDLE: {
                return this.shapeGenerator.createRectangle(x - 2, y - 1, w + 3, h + 1);
            }
            case LAST: {
                return this.shapeGenerator.createRoundRectangle(x - 2, y - 1, w + 2, h + 1, ShapeGenerator.CornerSize.INNER_FOCUS, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
            }
        }
        return this.shapeGenerator.createRoundRectangle(x - 1, y - 1, w + 1, h + 1, ShapeGenerator.CornerSize.INNER_FOCUS);
    }

    protected Shape createBorder(SegmentType segmentType, int x, int y, int w, int h) {
        switch (segmentType) {
            case FIRST: {
                return this.shapeGenerator.createRoundRectangle(x, y, w + 2, h, ShapeGenerator.CornerSize.BORDER, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            }
            case MIDDLE: {
                return this.shapeGenerator.createRectangle(x - 2, y, w + 4, h);
            }
            case LAST: {
                return this.shapeGenerator.createRoundRectangle(x - 2, y, w + 2, h, ShapeGenerator.CornerSize.BORDER, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
            }
        }
        return this.shapeGenerator.createRoundRectangle(x, y, w, h, ShapeGenerator.CornerSize.BORDER);
    }

    protected Shape createInterior(SegmentType segmentType, int x, int y, int w, int h) {
        switch (segmentType) {
            case FIRST: {
                return this.shapeGenerator.createRoundRectangle(x + 1, y + 1, w, h - 2, ShapeGenerator.CornerSize.INTERIOR, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            }
            case MIDDLE: {
                return this.shapeGenerator.createRectangle(x - 2, y + 1, w + 3, h - 2);
            }
            case LAST: {
                return this.shapeGenerator.createRoundRectangle(x - 2, y + 1, w + 1, h - 2, ShapeGenerator.CornerSize.INTERIOR, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
            }
        }
        return this.shapeGenerator.createRoundRectangle(x + 1, y + 1, w - 2, h - 2, ShapeGenerator.CornerSize.INTERIOR);
    }

    static enum SegmentType {
        NONE,
        FIRST,
        MIDDLE,
        LAST;

    }
}

