/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class TreePainter
extends AbstractRegionPainter {
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private Color selectedColor = this.decodeColor("seaGlassBlueGrey", 0.0f, -0.110526316f, 0.25490195f, 0);
    private Color enabledColor = this.decodeColor("seaGlassBlueGrey", -0.6111111f, -0.110526316f, -0.34509805f, 0);

    public TreePainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case COLLAPSEDICON_ENABLED: {
                this.paintCollapsedIconEnabled(g, width, height);
                break;
            }
            case COLLAPSEDICON_ENABLED_SELECTED: {
                this.paintCollapsedIconEnabledAndSelected(g, width, height);
                break;
            }
            case EXPANDEDICON_ENABLED: {
                this.paintExpandedIconEnabled(g, width, height);
                break;
            }
            case EXPANDEDICON_ENABLED_SELECTED: {
                this.paintExpandedIconEnabledAndSelected(g, width, height);
            }
        }
    }

    @Override
    protected final AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintCollapsedIconEnabled(Graphics2D g, int width, int height) {
        Shape s = this.decodeCollapsedPath(width, height);
        g.setPaint(this.enabledColor);
        g.fill(s);
    }

    private void paintCollapsedIconEnabledAndSelected(Graphics2D g, int width, int height) {
        Shape s = this.decodeCollapsedPath(width, height);
        g.setPaint(this.selectedColor);
        g.fill(s);
    }

    private void paintExpandedIconEnabled(Graphics2D g, int width, int height) {
        Shape s = this.decodeExpandedPath(width, height);
        g.setPaint(this.enabledColor);
        g.fill(s);
    }

    private void paintExpandedIconEnabledAndSelected(Graphics2D g, int width, int height) {
        Shape s = this.decodeExpandedPath(width, height);
        g.setPaint(this.selectedColor);
        g.fill(s);
    }

    private Shape decodeCollapsedPath(int width, int height) {
        return this.shapeGenerator.createArrowRight(0.0, 0.0, width, height);
    }

    private Shape decodeExpandedPath(int width, int height) {
        return this.shapeGenerator.createArrowDown(0.0, 0.0, width, height);
    }

    public static enum Which {
        COLLAPSEDICON_ENABLED,
        COLLAPSEDICON_ENABLED_SELECTED,
        EXPANDEDICON_ENABLED,
        EXPANDEDICON_ENABLED_SELECTED;

    }
}

