/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class TreeCellPainter
extends AbstractRegionPainter {
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private Color focusColor = this.decodeColor("seaGlassFocus", 0.0f, 0.0f, 0.0f, 0);
    private Color backgroundColor = this.decodeColor("seaGlassSelectionBackground", 0.0f, 0.0f, 0.0f, 0);

    public TreeCellPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_ENABLED_FOCUSED: {
                this.paintBackgroundEnabledAndFocused(g, width, height);
                break;
            }
            case BACKGROUND_ENABLED_SELECTED: {
                this.paintBackgroundEnabledAndSelected(g, width, height);
                break;
            }
            case BACKGROUND_SELECTED_FOCUSED: {
                this.paintBackgroundSelectedAndFocused(g, width, height);
            }
        }
    }

    @Override
    protected final AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintBackgroundEnabledAndFocused(Graphics2D g, int width, int height) {
        Shape s = this.decodeFocus(width, height);
        g.setPaint(this.focusColor);
        g.fill(s);
    }

    private void paintBackgroundEnabledAndSelected(Graphics2D g, int width, int height) {
        Shape s = this.decodeBackground(width, height);
        g.setPaint(this.backgroundColor);
        g.fill(s);
    }

    private void paintBackgroundSelectedAndFocused(Graphics2D g, int width, int height) {
        Shape s = this.decodeBackground(width, height);
        g.setPaint(this.backgroundColor);
        g.fill(s);
        s = this.decodeFocus(width, height);
        g.setPaint(this.focusColor);
        g.fill(s);
    }

    private Shape decodeFocus(int width, int height) {
        return this.shapeGenerator.createFillableFocusRectangle(0, 0, width, height);
    }

    private Shape decodeBackground(int width, int height) {
        return this.shapeGenerator.createRectangle(0, 0, width, height);
    }

    public static enum Which {
        BACKGROUND_ENABLED_FOCUSED,
        BACKGROUND_ENABLED_SELECTED,
        BACKGROUND_SELECTED_FOCUSED;

    }
}

