/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class TreeCellEditorPainter
extends AbstractRegionPainter {
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private Color outlineColor = this.decodeColor("seaGlassBlueGrey", 0.0f, -0.017358616f, -0.11372548f, 0);
    private Color focusColor = this.decodeColor("seaGlassFocus", 0.0f, 0.0f, 0.0f, 0);

    public TreeCellEditorPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_ENABLED: {
                this.paintBackgroundEnabled(g, width, height);
                break;
            }
            case BACKGROUND_ENABLED_FOCUSED: {
                this.paintBackgroundEnabledAndFocused(g, width, height);
            }
        }
    }

    @Override
    protected final AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintBackgroundEnabled(Graphics2D g, int width, int height) {
        Shape s = this.decodeOutline(width, height);
        g.setPaint(this.outlineColor);
        g.fill(s);
    }

    private void paintBackgroundEnabledAndFocused(Graphics2D g, int width, int height) {
        Shape s = this.decodeFocus(width, height);
        g.setPaint(this.focusColor);
        g.fill(s);
    }

    private Shape decodeOutline(int width, int height) {
        return this.shapeGenerator.createFillableFocusRectangle(0, 0, width, height);
    }

    private Shape decodeFocus(int width, int height) {
        return this.shapeGenerator.createFillableFocusRectangle(0, 0, width, height);
    }

    public static enum Which {
        BACKGROUND_ENABLED,
        BACKGROUND_ENABLED_FOCUSED;

    }
}

