/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public final class ToolBarToggleButtonPainter
extends AbstractRegionPainter {
    private Color toolbarToggleButtonBase = this.decodeColor("toolbarToggleButtonBase");
    private AbstractRegionPainter.TwoColors toolbarToggleButtonInner = new AbstractRegionPainter.TwoColors(this.toolbarToggleButtonBase, this.deriveColor(this.toolbarToggleButtonBase, 0.0f, 0.0f, 0.0f, 40));
    private AbstractRegionPainter.TwoColors toolbarToggleButtonInnerEdge = new AbstractRegionPainter.TwoColors(this.toolbarToggleButtonBase, this.deriveColor(this.toolbarToggleButtonBase, 0.0f, 0.0f, 0.0f, 240));
    private AbstractRegionPainter.TwoColors toolbarToggleButtonOuterEdge = new AbstractRegionPainter.TwoColors(this.deriveColor(this.toolbarToggleButtonBase, 0.0f, 0.0f, 0.0f, 16), this.deriveColor(this.toolbarToggleButtonBase, 0.0f, 0.0f, 0.0f, 64));
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    private boolean isSelected;

    public ToolBarToggleButtonPainter(Which state) {
        switch (state) {
            case BACKGROUND_SELECTED: 
            case BACKGROUND_SELECTED_FOCUSED: 
            case BACKGROUND_PRESSED_SELECTED: 
            case BACKGROUND_PRESSED_SELECTED_FOCUSED: 
            case BACKGROUND_DISABLED_SELECTED: {
                this.isSelected = true;
                break;
            }
            default: {
                this.isSelected = false;
            }
        }
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        if (this.isSelected) {
            Shape s = this.shapeGenerator.createRectangle(0, 0, 1, height);
            g.setPaint(this.getToolbarToggleButtonPaint(s, ToolbarToggleButtonType.INNER));
            g.fill(s);
            s = this.shapeGenerator.createRectangle(1, 0, 1, height);
            g.setPaint(this.getToolbarToggleButtonPaint(s, ToolbarToggleButtonType.INNER_EDGE));
            g.fill(s);
            s = this.shapeGenerator.createRectangle(width - 2, 0, 1, height);
            g.setPaint(this.getToolbarToggleButtonPaint(s, ToolbarToggleButtonType.INNER_EDGE));
            g.fill(s);
            s = this.shapeGenerator.createRectangle(0, 0, 1, height);
            g.setPaint(this.getToolbarToggleButtonPaint(s, ToolbarToggleButtonType.OUTER_EDGE));
            g.fill(s);
            s = this.shapeGenerator.createRectangle(width - 1, 0, 1, height);
            g.setPaint(this.getToolbarToggleButtonPaint(s, ToolbarToggleButtonType.OUTER_EDGE));
            g.fill(s);
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private AbstractRegionPainter.TwoColors getToolbarToggleButtonColors(ToolbarToggleButtonType type) {
        switch (type) {
            case INNER: {
                return this.toolbarToggleButtonInner;
            }
            case INNER_EDGE: {
                return this.toolbarToggleButtonInnerEdge;
            }
            case OUTER_EDGE: {
                return this.toolbarToggleButtonOuterEdge;
            }
        }
        return null;
    }

    public Paint getToolbarToggleButtonPaint(Shape s, ToolbarToggleButtonType type) {
        AbstractRegionPainter.TwoColors colors = this.getToolbarToggleButtonColors(type);
        return this.createToolbarToggleButtonGradient(s, colors);
    }

    private Paint createToolbarToggleButtonGradient(Shape s, AbstractRegionPainter.TwoColors colors) {
        Rectangle2D bounds = s.getBounds2D();
        float x = (float)bounds.getX();
        float y = (float)bounds.getY();
        float w = (float)bounds.getWidth();
        float h = (float)bounds.getHeight();
        return this.createGradient(0.5f * w + x, y, 0.5f * w + x, h + y, new float[]{0.0f, 0.35f, 0.65f, 1.0f}, new Color[]{colors.top, colors.bottom, colors.bottom, colors.top});
    }

    public static enum ToolbarToggleButtonType {
        INNER,
        INNER_EDGE,
        OUTER_EDGE;

    }

    public static enum Which {
        BACKGROUND_ENABLED,
        BACKGROUND_FOCUSED,
        BACKGROUND_PRESSED,
        BACKGROUND_PRESSED_FOCUSED,
        BACKGROUND_SELECTED,
        BACKGROUND_SELECTED_FOCUSED,
        BACKGROUND_PRESSED_SELECTED,
        BACKGROUND_PRESSED_SELECTED_FOCUSED,
        BACKGROUND_DISABLED_SELECTED;

    }
}

