/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import com.seaglasslookandfeel.util.PlatformUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public class ToolBarHandlePainter
extends AbstractCommonColorsPainter {
    private Color toolbarHandleMac = this.decodeColor("toolbarHandleMac");
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);

    public ToolBarHandlePainter(Which state) {
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        if (PlatformUtils.isMac()) {
            this.paintMacHandleIcon(g, width, height);
        } else {
            this.paintNonMacHandleIcon(g, width, height);
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintMacHandleIcon(Graphics2D g, int width, int height) {
        g.setPaint(this.toolbarHandleMac);
        g.drawLine(4, 2, 4, height - 3);
        g.drawLine(6, 2, 6, height - 3);
    }

    private void paintNonMacHandleIcon(Graphics2D g, int width, int height) {
        Shape s = this.decodeNonMacHandleBorder(width, height);
        g.setPaint(this.getCommonBorderPaint(s, AbstractCommonColorsPainter.CommonControlState.ENABLED));
        g.fill(s);
        s = this.decodeNonMacHandleInside(width, height);
        g.setPaint(this.getCommonInteriorPaint(s, AbstractCommonColorsPainter.CommonControlState.ENABLED));
        g.fill(s);
    }

    private Shape decodeNonMacHandleBorder(int width, int height) {
        return this.shapeGenerator.createRoundRectangle(4, 2, width - 4, height - 4, ShapeGenerator.CornerSize.ROUND_WIDTH);
    }

    private Shape decodeNonMacHandleInside(int width, int height) {
        return this.shapeGenerator.createRoundRectangle(5, 3, width - 6, height - 6, ShapeGenerator.CornerSize.ROUND_WIDTH);
    }

    public static enum Which {
        HANDLEICON_ENABLED;

    }
}

