/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.TitlePaneButtonPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Path2D;
import javax.swing.JComponent;

public final class TitlePaneMenuButtonPainter
extends TitlePaneButtonPainter {
    private ButtonColors enabled = new ButtonColors(white16, black66, white4c, black66, black33, white33, transparentColor, black99, white99);
    private ButtonColors hover = new ButtonColors(white68, black66, white8c, black66, black33, white46, white59, gray_10_e5, white);
    private ButtonColors pressed = new ButtonColors(gray_9b_82, black66, gray_a9_9e, black66, black33, white33, gray_e6_59, gray_0e_e5, gray_e6);
    private Path2D path = new Path2D.Double();
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public TitlePaneMenuButtonPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case ICON_ENABLED: 
            case ICON_DISABLED: 
            case ICON_ENABLED_WINDOWNOTFOCUSED: {
                this.paintEnabled(g, c, width, height);
                break;
            }
            case ICON_MOUSEOVER: 
            case ICON_MOUSEOVER_WINDOWNOTFOCUSED: {
                this.paintHover(g, c, width, height);
                break;
            }
            case ICON_PRESSED: 
            case ICON_PRESSED_WINDOWNOTFOCUSED: {
                this.paintPressed(g, c, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintEnabled(Graphics2D g, JComponent c, int width, int height) {
        this.paintMenu(g, c, width, height, this.enabled);
    }

    private void paintHover(Graphics2D g, JComponent c, int width, int height) {
        this.paintMenu(g, c, width, height, this.hover);
    }

    private void paintPressed(Graphics2D g, JComponent c, int width, int height) {
        this.paintMenu(g, c, width, height, this.pressed);
    }

    private void paintMenu(Graphics2D g, JComponent c, int width, int height, ButtonColors colors) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(colors.top);
        g.drawLine(0, 0, width - 2, 0);
        g.setColor(colors.leftOuter);
        g.drawLine(0, 0, 0, height - 4);
        g.setColor(colors.leftInner);
        g.drawLine(1, 1, 1, height - 4);
        g.drawLine(2, height - 3, 2, height - 3);
        Shape s = this.decodeInterior(width, height);
        g.setColor(colors.interior);
        g.fill(s);
        s = this.decodeEdge(width, height);
        g.setColor(colors.edge);
        g.draw(s);
        g.setColor(colors.edgeShade);
        g.drawLine(2, height - 2, 2, height - 2);
        g.drawLine(1, height - 3, 1, height - 3);
        g.drawLine(0, height - 4, 0, height - 4);
        s = this.decodeShadow(width, height);
        g.setColor(colors.shadow);
        g.draw(s);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        s = this.decodeMarkInterior(width, height);
        g.setColor(colors.markInterior);
        g.fill(s);
        s = this.decodeMarkBorder(width, height);
        g.setColor(colors.markBorder);
        g.draw(s);
    }

    private Shape decodeInterior(int width, int height) {
        this.path.reset();
        this.path.moveTo(1.0, 1.0);
        this.path.lineTo(width - 2, 1.0);
        this.path.lineTo(width - 2, height - 3);
        this.path.lineTo(width - 3, height - 2);
        this.path.lineTo(3.0, height - 2);
        this.path.lineTo(2.0, height - 3);
        this.path.closePath();
        return this.path;
    }

    private Shape decodeEdge(int width, int height) {
        this.path.reset();
        this.path.moveTo(width - 2, 0.0);
        this.path.lineTo(width - 2, height - 4);
        this.path.lineTo(width - 4, height - 2);
        this.path.lineTo(3.0, height - 2);
        return this.path;
    }

    private Shape decodeShadow(int width, int height) {
        this.path.reset();
        this.path.moveTo(width - 1, 0.0);
        this.path.lineTo(width - 1, height - 4);
        this.path.lineTo(width - 4, height - 1);
        this.path.lineTo(2.0, height - 1);
        this.path.lineTo(1.0, height - 2);
        return this.path;
    }

    private Shape decodeMarkBorder(int width, int height) {
        double left = (double)width / 2.0 - 4.0;
        double top = (double)height / 2.0 - 4.0;
        this.path.reset();
        this.path.moveTo(left + 0.0, top + 0.0);
        this.path.lineTo(left + 8.0, top);
        this.path.lineTo(left + 4.0, top + 6.0);
        this.path.closePath();
        return this.path;
    }

    private Shape decodeMarkInterior(int width, int height) {
        double left = (double)width / 2.0 - 4.0;
        double top = (double)height / 2.0 - 4.0;
        this.path.reset();
        this.path.moveTo(left + 1.0, top + 1.0);
        this.path.lineTo(left + 8.0, top + 1.0);
        this.path.lineTo(left + 4.0, top + 6.0);
        this.path.closePath();
        return this.path;
    }

    private static class ButtonColors {
        public Color top;
        public Color leftOuter;
        public Color leftInner;
        public Color edge;
        public Color edgeShade;
        public Color shadow;
        public Color interior;
        public Color markBorder;
        public Color markInterior;

        public ButtonColors(Color top, Color leftOuter, Color leftInner, Color edge, Color edgeShade, Color shadow, Color interior, Color markBorder, Color markInterior) {
            this.top = top;
            this.leftOuter = leftOuter;
            this.leftInner = leftInner;
            this.edge = edge;
            this.edgeShade = edgeShade;
            this.shadow = shadow;
            this.interior = interior;
            this.markBorder = markBorder;
            this.markInterior = markInterior;
        }
    }

    public static enum Which {
        ICON_ENABLED,
        ICON_DISABLED,
        ICON_MOUSEOVER,
        ICON_PRESSED,
        ICON_ENABLED_WINDOWNOTFOCUSED,
        ICON_MOUSEOVER_WINDOWNOTFOCUSED,
        ICON_PRESSED_WINDOWNOTFOCUSED;

    }
}

