/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.TitlePaneButtonPainter;
import com.seaglasslookandfeel.painter.titlepaneforegound.TitlePaneButtonForegroundPainter;
import com.seaglasslookandfeel.painter.titlepaneforegound.TitlePaneMaximizeButtonForegroundPainter;
import com.seaglasslookandfeel.painter.titlepaneforegound.TitlePaneRestoreButtonForegroundPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public final class TitlePaneMaximizeButtonPainter
extends TitlePaneButtonPainter {
    private ButtonColors enabled = new ButtonColors(white16, white4c, black66, white33, transparentColor);
    private ButtonColors hover = new ButtonColors(white68, white8c, black66, white33, white59);
    private ButtonColors pressed = new ButtonColors(gray_9b_82, gray_a9_9e, black66, white33, gray_e6_59);
    private TitlePaneMaximizeButtonForegroundPainter maximizePainter = new TitlePaneMaximizeButtonForegroundPainter();
    private TitlePaneButtonForegroundPainter restorePainter = new TitlePaneRestoreButtonForegroundPainter();
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public TitlePaneMaximizeButtonPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_DISABLED: 
            case BACKGROUND_ENABLED: 
            case BACKGROUND_ENABLED_WINDOWNOTFOCUSED: {
                this.paintBackgroundEnabled(g, c, width, height);
                this.paintMaximizeEnabled(g, c, width, height);
                break;
            }
            case BACKGROUND_MOUSEOVER: 
            case BACKGROUND_MOUSEOVER_WINDOWNOTFOCUSED: {
                this.paintBackgroundHover(g, c, width, height);
                this.paintMaximizeHover(g, c, width, height);
                break;
            }
            case BACKGROUND_PRESSED: 
            case BACKGROUND_PRESSED_WINDOWNOTFOCUSED: {
                this.paintBackgroundPressed(g, c, width, height);
                this.paintMaximizePressed(g, c, width, height);
                break;
            }
            case BACKGROUND_MAXIMIZED_DISABLED: 
            case BACKGROUND_MAXIMIZED_ENABLED: 
            case BACKGROUND_MAXIMIZED_ENABLED_WINDOWNOTFOCUSED: {
                this.paintBackgroundEnabled(g, c, width, height);
                this.paintRestoreEnabled(g, c, width, height);
                break;
            }
            case BACKGROUND_MAXIMIZED_MOUSEOVER: 
            case BACKGROUND_MAXIMIZED_MOUSEOVER_WINDOWNOTFOCUSED: {
                this.paintBackgroundHover(g, c, width, height);
                this.paintRestoreHover(g, c, width, height);
                break;
            }
            case BACKGROUND_MAXIMIZED_PRESSED: 
            case BACKGROUND_MAXIMIZED_PRESSED_WINDOWNOTFOCUSED: {
                this.paintBackgroundPressed(g, c, width, height);
                this.paintRestorePressed(g, c, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintBackgroundEnabled(Graphics2D g, JComponent c, int width, int height) {
        this.paintBackground(g, c, width, height, this.enabled);
    }

    private void paintBackgroundHover(Graphics2D g, JComponent c, int width, int height) {
        this.paintBackground(g, c, width, height, this.hover);
    }

    private void paintBackgroundPressed(Graphics2D g, JComponent c, int width, int height) {
        this.paintBackground(g, c, width, height, this.pressed);
    }

    private void paintMaximizeEnabled(Graphics2D g, JComponent c, int width, int height) {
        this.maximizePainter.paintEnabled(g, c, width, height);
    }

    private void paintMaximizeHover(Graphics2D g, JComponent c, int width, int height) {
        this.maximizePainter.paintHover(g, c, width, height);
    }

    private void paintMaximizePressed(Graphics2D g, JComponent c, int width, int height) {
        this.maximizePainter.paintPressed(g, c, width, height);
    }

    private void paintRestoreEnabled(Graphics2D g, JComponent c, int width, int height) {
        this.restorePainter.paintEnabled(g, c, width, height);
    }

    private void paintRestoreHover(Graphics2D g, JComponent c, int width, int height) {
        this.restorePainter.paintHover(g, c, width, height);
    }

    private void paintRestorePressed(Graphics2D g, JComponent c, int width, int height) {
        this.restorePainter.paintPressed(g, c, width, height);
    }

    private void paintBackground(Graphics2D g, JComponent c, int width, int height, ButtonColors colors) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(colors.top);
        g.drawLine(0, 0, width - 2, 0);
        g.setColor(colors.left);
        g.drawLine(0, 1, 0, height - 3);
        g.setColor(colors.edge);
        g.drawLine(width - 1, 0, width - 1, height - 2);
        g.drawLine(0, height - 2, width - 2, height - 2);
        g.setColor(colors.shadow);
        g.drawLine(0, height - 1, width - 1, height - 1);
        g.setColor(colors.interior);
        g.fillRect(1, 1, width - 1, height - 2);
    }

    private static class ButtonColors {
        public Color top;
        public Color left;
        public Color edge;
        public Color shadow;
        public Color interior;

        public ButtonColors(Color top, Color left, Color edge, Color shadow, Color interior) {
            this.top = top;
            this.left = left;
            this.edge = edge;
            this.shadow = shadow;
            this.interior = interior;
        }
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_MOUSEOVER,
        BACKGROUND_PRESSED,
        BACKGROUND_ENABLED_WINDOWNOTFOCUSED,
        BACKGROUND_MOUSEOVER_WINDOWNOTFOCUSED,
        BACKGROUND_PRESSED_WINDOWNOTFOCUSED,
        BACKGROUND_MAXIMIZED_DISABLED,
        BACKGROUND_MAXIMIZED_ENABLED,
        BACKGROUND_MAXIMIZED_MOUSEOVER,
        BACKGROUND_MAXIMIZED_PRESSED,
        BACKGROUND_MAXIMIZED_ENABLED_WINDOWNOTFOCUSED,
        BACKGROUND_MAXIMIZED_MOUSEOVER_WINDOWNOTFOCUSED,
        BACKGROUND_MAXIMIZED_PRESSED_WINDOWNOTFOCUSED;

    }
}

