/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.TitlePaneButtonPainter;
import com.seaglasslookandfeel.painter.titlepaneforegound.TitlePaneButtonForegroundPainter;
import com.seaglasslookandfeel.painter.titlepaneforegound.TitlePaneIconifyButtonForegroundPainter;
import com.seaglasslookandfeel.painter.titlepaneforegound.TitlePaneRestoreButtonForegroundPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public final class TitlePaneIconifyButtonPainter
extends TitlePaneButtonPainter {
    private ButtonColors enabled = new ButtonColors(white16, black66, white4c, black66, black33, white33, transparentColor);
    private ButtonColors hover = new ButtonColors(white68, black66, white8c, black66, black33, white46, white59);
    private ButtonColors pressed = new ButtonColors(gray_9b_82, black66, gray_a9_9e, black66, black33, white33, gray_e6_59);
    private TitlePaneIconifyButtonForegroundPainter iconifyPainter = new TitlePaneIconifyButtonForegroundPainter();
    private TitlePaneButtonForegroundPainter restorePainter = new TitlePaneRestoreButtonForegroundPainter();
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public TitlePaneIconifyButtonPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_ENABLED: 
            case BACKGROUND_DISABLED: 
            case BACKGROUND_ENABLED_WINDOWNOTFOCUSED: {
                this.paintBackgroundEnabled(g, c, width, height);
                this.paintMinimizeEnabled(g, c, width, height);
                break;
            }
            case BACKGROUND_MOUSEOVER: 
            case BACKGROUND_MOUSEOVER_WINDOWNOTFOCUSED: {
                this.paintBackgroundHover(g, c, width, height);
                this.paintMinimizeHover(g, c, width, height);
                break;
            }
            case BACKGROUND_PRESSED: 
            case BACKGROUND_PRESSED_WINDOWNOTFOCUSED: {
                this.paintBackgroundPressed(g, c, width, height);
                this.paintMinimizePressed(g, c, width, height);
                break;
            }
            case BACKGROUND_MINIMIZED_DISABLED: 
            case BACKGROUND_MINIMIZED_ENABLED: 
            case BACKGROUND_MINIMIZED_ENABLED_WINDOWNOTFOCUSED: {
                this.paintBackgroundEnabled(g, c, width, height);
                this.paintRestoreEnabled(g, c, width, height);
                break;
            }
            case BACKGROUND_MINIMIZED_MOUSEOVER: 
            case BACKGROUND_MINIMIZED_MOUSEOVER_WINDOWNOTFOCUSED: {
                this.paintBackgroundHover(g, c, width, height);
                this.paintRestoreHover(g, c, width, height);
                break;
            }
            case BACKGROUND_MINIMIZED_PRESSED: 
            case BACKGROUND_MINIMIZED_PRESSED_WINDOWNOTFOCUSED: {
                this.paintBackgroundPressed(g, c, width, height);
                this.paintRestorePressed(g, c, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintBackgroundEnabled(Graphics2D g, JComponent c, int width, int height) {
        this.paintBackground(g, c, width, height, this.enabled);
    }

    private void paintBackgroundHover(Graphics2D g, JComponent c, int width, int height) {
        this.paintBackground(g, c, width, height, this.hover);
    }

    private void paintBackgroundPressed(Graphics2D g, JComponent c, int width, int height) {
        this.paintBackground(g, c, width, height, this.pressed);
    }

    private void paintMinimizeEnabled(Graphics2D g, JComponent c, int width, int height) {
        this.iconifyPainter.paintEnabled(g, c, width, height);
    }

    private void paintMinimizeHover(Graphics2D g, JComponent c, int width, int height) {
        this.iconifyPainter.paintHover(g, c, width, height);
    }

    private void paintMinimizePressed(Graphics2D g, JComponent c, int width, int height) {
        this.iconifyPainter.paintPressed(g, c, width, height);
    }

    private void paintRestoreEnabled(Graphics2D g, JComponent c, int width, int height) {
        this.restorePainter.paintEnabled(g, c, width, height);
    }

    private void paintRestoreHover(Graphics2D g, JComponent c, int width, int height) {
        this.restorePainter.paintHover(g, c, width, height);
    }

    private void paintRestorePressed(Graphics2D g, JComponent c, int width, int height) {
        this.restorePainter.paintPressed(g, c, width, height);
    }

    private void paintBackground(Graphics2D g, JComponent c, int width, int height, ButtonColors colors) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(colors.top);
        g.drawLine(1, 0, width - 2, 0);
        g.setColor(colors.leftOuter);
        g.drawLine(0, 0, 0, height - 4);
        g.drawLine(1, height - 3, 1, height - 3);
        g.setColor(colors.leftInner);
        g.drawLine(1, 1, 1, height - 4);
        g.drawLine(2, height - 3, 2, height - 3);
        g.setColor(colors.edge);
        g.drawLine(width - 1, 0, width - 1, height - 2);
        g.drawLine(3, height - 2, width - 2, height - 2);
        g.setColor(colors.edgeShade);
        g.drawLine(2, height - 2, 2, height - 2);
        g.setColor(colors.shadow);
        g.drawLine(4, height - 1, width - 1, height - 1);
        g.setColor(colors.interior);
        g.fillRect(1, 1, width - 1, height - 3);
        g.drawLine(3, height - 3, width - 2, height - 3);
    }

    private static class ButtonColors {
        public Color top;
        public Color leftOuter;
        public Color leftInner;
        public Color edge;
        public Color edgeShade;
        public Color shadow;
        public Color interior;

        public ButtonColors(Color top, Color leftOuter, Color leftInner, Color edge, Color edgeShade, Color shadow, Color interior) {
            this.top = top;
            this.leftOuter = leftOuter;
            this.leftInner = leftInner;
            this.edge = edge;
            this.edgeShade = edgeShade;
            this.shadow = shadow;
            this.interior = interior;
        }
    }

    public static enum Which {
        BACKGROUND_ENABLED,
        BACKGROUND_DISABLED,
        BACKGROUND_MOUSEOVER,
        BACKGROUND_PRESSED,
        BACKGROUND_ENABLED_WINDOWNOTFOCUSED,
        BACKGROUND_MOUSEOVER_WINDOWNOTFOCUSED,
        BACKGROUND_PRESSED_WINDOWNOTFOCUSED,
        BACKGROUND_MINIMIZED_DISABLED,
        BACKGROUND_MINIMIZED_ENABLED,
        BACKGROUND_MINIMIZED_MOUSEOVER,
        BACKGROUND_MINIMIZED_PRESSED,
        BACKGROUND_MINIMIZED_ENABLED_WINDOWNOTFOCUSED,
        BACKGROUND_MINIMIZED_MOUSEOVER_WINDOWNOTFOCUSED,
        BACKGROUND_MINIMIZED_PRESSED_WINDOWNOTFOCUSED;

    }
}

