/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.TitlePaneButtonPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Path2D;
import javax.swing.JComponent;

public final class TitlePaneCloseButtonPainter
extends TitlePaneButtonPainter {
    private ButtonColors enabled = new ButtonColors(white16, white4c, black66, white33, transparentColor, transparentColor, black99, white99);
    private ButtonColors hover = new ButtonColors(closeButtonTopHover, closeButtonLeftHover, closeButtonEdgeHover, white33, closeButtonInteriorTopHover, closeButtonInteriorBottomHover, closeButtonMarkBorderHover, white);
    private ButtonColors pressed = new ButtonColors(closeButtonTopPressed, closeButtonLeftPressed, black66, white33, closeButtonInteriorTopPressed, closeButtonInteriorTopPressed, closeButtonMarkBorderPressed, closeButtonMarkInteriorPressed);
    private MyPath2D path = new MyPath2D();
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public TitlePaneCloseButtonPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_DISABLED: 
            case BACKGROUND_ENABLED: 
            case BACKGROUND_ENABLED_WINDOWNOTFOCUSED: {
                this.paintCloseEnabled(g, c, width, height);
                break;
            }
            case BACKGROUND_MOUSEOVER: {
                this.paintCloseHover(g, c, width, height);
                break;
            }
            case BACKGROUND_PRESSED: 
            case BACKGROUND_PRESSED_WINDOWNOTFOCUSED: {
                this.paintClosePressed(g, c, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintCloseEnabled(Graphics2D g, JComponent c, int width, int height) {
        this.paintClose(g, c, width, height, this.enabled);
    }

    private void paintCloseHover(Graphics2D g, JComponent c, int width, int height) {
        this.paintClose(g, c, width, height, this.hover);
    }

    private void paintClosePressed(Graphics2D g, JComponent c, int width, int height) {
        this.paintClose(g, c, width, height, this.pressed);
    }

    private void paintClose(Graphics2D g, JComponent c, int width, int height, ButtonColors colors) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape s = this.decodeInterior(width, height);
        g.setPaint(this.decodeCloseGradient(s, colors.interiorTop, colors.interiorBottom));
        g.fill(s);
        s = this.decodeEdge(width, height);
        g.setColor(colors.edge);
        g.draw(s);
        s = this.decodeShadow(width, height);
        g.setColor(colors.shadow);
        g.draw(s);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setColor(colors.top);
        g.drawLine(0, 0, width - 2, 0);
        g.setColor(colors.left);
        g.drawLine(0, 1, 0, height - 3);
        s = this.decodeMarkInterior(width, height);
        g.setColor(colors.markInterior);
        g.fill(s);
        s = this.decodeMarkBorder(width, height);
        g.setColor(colors.markBorder);
        g.draw(s);
    }

    private Paint decodeCloseGradient(Shape s, Color top, Color bottom) {
        Rectangle r = s.getBounds();
        int width = r.width;
        int height = r.height;
        return this.createGradient(r.x + width / 2, r.y, r.x + width / 2, r.y + height - 1, new float[]{0.0f, 1.0f}, new Color[]{top, bottom});
    }

    private Shape decodeInterior(int width, int height) {
        this.path.reset();
        this.path.moveTo(1.0, 1.0);
        this.path.lineTo(width - 2, 1.0);
        this.path.lineTo(width - 2, height - 3);
        this.path.lineTo(width - 3, height - 2);
        this.path.lineTo(1.0, height - 2);
        this.path.closePath();
        return this.path;
    }

    private Shape decodeEdge(int width, int height) {
        this.path.reset();
        this.path.moveTo(width - 2, 0.0);
        this.path.lineTo(width - 2, height - 4);
        this.path.lineTo(width - 4, height - 2);
        this.path.lineTo(0.0, height - 2);
        return this.path;
    }

    private Shape decodeShadow(int width, int height) {
        this.path.reset();
        this.path.moveTo(width - 1, 0.0);
        this.path.lineTo(width - 1, height - 4);
        this.path.lineTo(width - 4, height - 1);
        this.path.lineTo(0.0, height - 1);
        return this.path;
    }

    private Shape decodeMarkBorder(int width, int height) {
        int left = (width - 3) / 2 - 5;
        int top = (height - 2) / 2 - 5;
        this.path.reset();
        this.path.moveTo(left + 1, top + 0);
        this.path.lineTo(left + 3, top + 0);
        this.path.pointAt(left + 4, top + 1);
        this.path.pointAt(left + 5, top + 2);
        this.path.pointAt(left + 6, top + 1);
        this.path.moveTo(left + 7, top + 0);
        this.path.lineTo(left + 9, top + 0);
        this.path.pointAt(left + 10, top + 1);
        this.path.pointAt(left + 9, top + 2);
        this.path.pointAt(left + 8, top + 3);
        this.path.moveTo(left + 7, top + 4);
        this.path.lineTo(left + 7, top + 5);
        this.path.pointAt(left + 8, top + 6);
        this.path.pointAt(left + 9, top + 7);
        this.path.pointAt(left + 10, top + 8);
        this.path.moveTo(left + 9, top + 9);
        this.path.lineTo(left + 7, top + 9);
        this.path.pointAt(left + 6, top + 8);
        this.path.pointAt(left + 5, top + 7);
        this.path.pointAt(left + 4, top + 8);
        this.path.moveTo(left + 3, top + 9);
        this.path.lineTo(left + 1, top + 9);
        this.path.pointAt(left + 0, top + 8);
        this.path.pointAt(left + 1, top + 7);
        this.path.pointAt(left + 2, top + 6);
        this.path.moveTo(left + 3, top + 5);
        this.path.lineTo(left + 3, top + 4);
        this.path.pointAt(left + 2, top + 3);
        this.path.pointAt(left + 1, top + 2);
        this.path.pointAt(left + 0, top + 1);
        return this.path;
    }

    private Shape decodeMarkInterior(int width, int height) {
        int left = (width - 3) / 2 - 5;
        int top = (height - 2) / 2 - 5;
        this.path.reset();
        this.path.moveTo(left + 1, top + 1);
        this.path.lineTo(left + 4, top + 1);
        this.path.lineTo(left + 5, top + 3);
        this.path.lineTo(left + 7, top + 1);
        this.path.lineTo(left + 10, top + 1);
        this.path.lineTo(left + 7, top + 4);
        this.path.lineTo(left + 7, top + 5);
        this.path.lineTo(left + 10, top + 9);
        this.path.lineTo(left + 6, top + 8);
        this.path.lineTo(left + 5, top + 6);
        this.path.lineTo(left + 4, top + 9);
        this.path.lineTo(left + 0, top + 9);
        this.path.lineTo(left + 4, top + 5);
        this.path.lineTo(left + 4, top + 4);
        this.path.closePath();
        return this.path;
    }

    private static class ButtonColors {
        public Color top;
        public Color left;
        public Color edge;
        public Color shadow;
        public Color interiorTop;
        public Color interiorBottom;
        public Color markBorder;
        public Color markInterior;

        public ButtonColors(Color top, Color left, Color edge, Color shadow, Color interiorTop, Color interiorBottom, Color markBorder, Color markInterior) {
            this.top = top;
            this.left = left;
            this.edge = edge;
            this.shadow = shadow;
            this.interiorTop = interiorTop;
            this.interiorBottom = interiorBottom;
            this.markBorder = markBorder;
            this.markInterior = markInterior;
        }
    }

    private static class MyPath2D
    extends Path2D.Double {
        private static final long serialVersionUID = -3577694636085901945L;

        private MyPath2D() {
        }

        public void pointAt(int x, int y) {
            this.moveTo(x, y);
            this.lineTo(x, y);
        }
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_MOUSEOVER,
        BACKGROUND_PRESSED,
        BACKGROUND_ENABLED_WINDOWNOTFOCUSED,
        BACKGROUND_PRESSED_WINDOWNOTFOCUSED;

    }
}

