/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.SeaGlassInternalShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.plaf.ColorUIResource;

public final class TextComponentPainter
extends AbstractCommonColorsPainter {
    private Color defaultBackground = this.decodeColor("seaGlassLightBackground");
    private Color lineSeparatorEnabled = new ColorUIResource(15463932);
    private SeaGlassInternalShadowEffect internalShadow = new SeaGlassInternalShadowEffect();
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private AbstractCommonColorsPainter.CommonControlState type;
    private boolean focused;
    private Object[] componentColors;

    public TextComponentPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
        this.type = state == Which.BACKGROUND_DISABLED || state == Which.BACKGROUND_SOLID_DISABLED || state == Which.BORDER_DISABLED ? AbstractCommonColorsPainter.CommonControlState.DISABLED : AbstractCommonColorsPainter.CommonControlState.ENABLED;
        this.focused = state == Which.BORDER_FOCUSED;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        this.componentColors = extendedCacheKeys;
        int x = this.focusInsets.left;
        int y = this.focusInsets.top;
        width -= this.focusInsets.left + this.focusInsets.right;
        height -= this.focusInsets.top + this.focusInsets.bottom;
        switch (this.state) {
            case BACKGROUND_DISABLED: 
            case BACKGROUND_ENABLED: 
            case BACKGROUND_SELECTED: {
                this.paintBackground(g, c, x, y, width, height);
                break;
            }
            case BACKGROUND_SOLID_DISABLED: 
            case BACKGROUND_SOLID_ENABLED: {
                this.paintBackgroundSolid(g, c, x, y, width, height);
                break;
            }
            case BORDER_DISABLED: 
            case BORDER_ENABLED: 
            case BORDER_FOCUSED: {
                this.paintBorder(g, c, x, y, width, height);
            }
        }
    }

    @Override
    protected Object[] getExtendedCacheKeys(JComponent c) {
        Object[] extendedCacheKeys = null;
        if (this.state == Which.BACKGROUND_ENABLED) {
            extendedCacheKeys = new Object[]{this.getComponentColor(c, "background", this.defaultBackground, 0.0f, 0.0f, 0)};
        }
        return extendedCacheKeys;
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintBackground(Graphics2D g, JComponent c, int x, int y, int width, int height) {
        Color color = c.getBackground();
        if (this.state == Which.BACKGROUND_ENABLED) {
            color = (Color)this.componentColors[0];
        } else if (this.type == AbstractCommonColorsPainter.CommonControlState.DISABLED) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
        }
        Shape s = this.shapeGenerator.createRoundRectangle(x + 1, y + 1, width - 2, height - 2, ShapeGenerator.CornerSize.BORDER);
        g.setPaint(color);
        g.fill(s);
        if (this.isPaintLineSeperators(c)) {
            this.paintLineSeparator(g, c, width, height);
        }
    }

    private boolean isPaintLineSeperators(JComponent c) {
        Boolean overrideProperty;
        boolean paintLines = c instanceof JTextArea;
        String globalOverride = System.getProperty("SeaGlass.JTextArea.drawLineSeparator");
        if (globalOverride != null && globalOverride.length() > 0) {
            paintLines = Boolean.valueOf(globalOverride);
        }
        if ((overrideProperty = (Boolean)c.getClientProperty("SeaGlass.JTextArea.drawLineSeparator")) != null) {
            paintLines = overrideProperty;
        }
        return paintLines;
    }

    private void paintBackgroundSolid(Graphics2D g, JComponent c, int x, int y, int width, int height) {
        Color color = c.getBackground();
        if (this.type == AbstractCommonColorsPainter.CommonControlState.DISABLED) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
        }
        Shape s = this.shapeGenerator.createRoundRectangle(x - 2, y - 2, width + 4, height + 4, ShapeGenerator.CornerSize.BORDER);
        g.setPaint(color);
        g.fill(s);
        if (this.isPaintLineSeperators(c)) {
            this.paintLineSeparator(g, c, width, height);
        }
    }

    private void paintLineSeparator(Graphics2D g, JComponent c, int width, int height) {
        g.setPaint(this.lineSeparatorEnabled);
        int lineYIncrement = g.getFontMetrics(c.getFont()).getHeight();
        for (int lineY = lineYIncrement + c.getInsets().top - 1; lineY < height; lineY += lineYIncrement) {
            g.drawLine(c.getInsets().left, lineY, width - c.getInsets().right, lineY);
        }
    }

    private void paintBorder(Graphics2D g, JComponent c, int x, int y, int width, int height) {
        Shape s;
        boolean useToolBarColors = this.isInToolBar(c);
        if (this.focused) {
            s = this.shapeGenerator.createRoundRectangle(x - 2, y - 2, width + 3, height + 3, ShapeGenerator.CornerSize.OUTER_FOCUS);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarColors));
            g.draw(s);
            s = this.shapeGenerator.createRoundRectangle(x - 1, y - 1, width + 1, height + 1, ShapeGenerator.CornerSize.INNER_FOCUS);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarColors));
            g.draw(s);
        }
        if (this.type != AbstractCommonColorsPainter.CommonControlState.DISABLED) {
            s = this.shapeGenerator.createRoundRectangle(x + 1, x + 1, width - 2, height - 2, ShapeGenerator.CornerSize.BORDER);
            this.internalShadow.fill(g, s, false, true);
        }
        s = this.shapeGenerator.createRoundRectangle(x, y, width - 1, height - 1, ShapeGenerator.CornerSize.BORDER);
        g.setPaint(this.getTextBorderPaint(this.type, !this.focused && useToolBarColors));
        g.draw(s);
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_SOLID_DISABLED,
        BACKGROUND_SOLID_ENABLED,
        BACKGROUND_SELECTED,
        BORDER_DISABLED,
        BORDER_FOCUSED,
        BORDER_ENABLED;

    }
}

