/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;

public final class TableHeaderRendererPainter
extends AbstractCommonColorsPainter {
    private Color tableHeaderBorderEnabled = this.decodeColor("tableHeaderBorderEnabled");
    private Color tableHeaderInteriorBaseEnabled = this.decodeColor("tableHeaderInteriorBaseEnabled");
    private Color tableHeaderBorderDisabled = this.disable(this.tableHeaderBorderEnabled);
    private Color tableHeaderTopEnabled = this.deriveColor(this.tableHeaderInteriorBaseEnabled, -0.027778f, -0.220842f, 0.335294f, 0);
    private Color tableHeaderUpperMidEnabled = this.deriveColor(this.tableHeaderInteriorBaseEnabled, -0.020833f, 4.05E-4f, -0.011765f, 0);
    private Color tableHeaderLowerMidEnabled = this.deriveColor(this.tableHeaderInteriorBaseEnabled, 0.0f, -2.64E-4f, 0.007843f, 0);
    private Color tableHeaderBottomEnabled = this.deriveColor(this.tableHeaderInteriorBaseEnabled, -0.020833f, -0.201033f, 0.331373f, 0);
    private AbstractRegionPainter.FourColors tableHeaderEnabled = new AbstractRegionPainter.FourColors(this.tableHeaderTopEnabled, this.tableHeaderUpperMidEnabled, this.tableHeaderLowerMidEnabled, this.tableHeaderBottomEnabled);
    private AbstractRegionPainter.FourColors tableHeaderSorted = this.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.SELECTED);
    private AbstractRegionPainter.FourColors tableHeaderPressed = this.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.PRESSED);
    private AbstractRegionPainter.FourColors tableHeaderDisabled = this.disable(this.tableHeaderEnabled);
    private AbstractRegionPainter.FourColors tableHeaderDisabledSorted = this.disable(this.tableHeaderSorted);
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    private AbstractCommonColorsPainter.CommonControlState type;
    private boolean isSorted;

    public TableHeaderRendererPainter(Which state) {
        this.type = this.getButtonType(state);
        this.isSorted = state == Which.BACKGROUND_DISABLED_SORTED || state == Which.BACKGROUND_ENABLED_SORTED || state == Which.BACKGROUND_ENABLED_FOCUSED_SORTED;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Shape s = this.shapeGenerator.createRectangle(0, 0, width - 1, height - 1);
        g.setPaint(this.getTableHeaderInteriorPaint(s, this.type, this.isSorted));
        g.fill(s);
        g.setPaint(this.getTableHeaderBorderPaint(this.type));
        g.drawLine(0, height - 1, width, height - 1);
        g.drawLine(width - 1, 0, width - 1, height - 1);
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private AbstractCommonColorsPainter.CommonControlState getButtonType(Which state) {
        switch (state) {
            case BACKGROUND_DISABLED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case BACKGROUND_ENABLED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_ENABLED_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_PRESSED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED;
            }
            case BACKGROUND_ENABLED_SORTED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_ENABLED_FOCUSED_SORTED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_DISABLED_SORTED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
        }
        return null;
    }

    public Paint getTableHeaderBorderPaint(AbstractCommonColorsPainter.CommonControlState type) {
        return type == AbstractCommonColorsPainter.CommonControlState.DISABLED ? this.tableHeaderBorderDisabled : this.tableHeaderBorderEnabled;
    }

    public Paint getTableHeaderInteriorPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type, boolean isSorted) {
        return this.getCommonInteriorPaint(s, type);
    }

    private AbstractRegionPainter.FourColors getTableHeaderColors(AbstractCommonColorsPainter.CommonControlState type, boolean isSorted) {
        switch (type) {
            case DISABLED: {
                return isSorted ? this.tableHeaderDisabledSorted : this.tableHeaderDisabled;
            }
            case ENABLED: {
                return isSorted ? this.tableHeaderSorted : this.tableHeaderEnabled;
            }
            case PRESSED: {
                return this.tableHeaderPressed;
            }
        }
        return null;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_ENABLED_FOCUSED,
        BACKGROUND_PRESSED,
        BACKGROUND_ENABLED_SORTED,
        BACKGROUND_ENABLED_FOCUSED_SORTED,
        BACKGROUND_DISABLED_SORTED;

    }
}

