/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.Effect;
import com.seaglasslookandfeel.effect.SeaGlassDropShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;

public final class TabbedPaneTabPainter
extends AbstractCommonColorsPainter {
    private Effect dropShadow = new SeaGlassDropShadowEffect();
    private AbstractCommonColorsPainter.CommonControlState type;
    protected Which state;
    protected AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    protected boolean focused;

    public TabbedPaneTabPainter(Which state) {
        switch (state) {
            case BACKGROUND_SELECTED_FOCUSED: 
            case BACKGROUND_PRESSED_SELECTED_FOCUSED: {
                this.focused = true;
                break;
            }
            default: {
                this.focused = false;
            }
        }
        this.type = this.getButtonType(state);
    }

    @Override
    protected Object[] getExtendedCacheKeys(JComponent c) {
        Object[] extendedCacheKeys = new Object[]{};
        return extendedCacheKeys;
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Shape s;
        SegmentType segmentStatus = this.getSegmentType(c);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = this.focusInsets.left;
        int y = this.focusInsets.top;
        width -= this.focusInsets.left + this.focusInsets.right;
        height -= this.focusInsets.top + this.focusInsets.bottom;
        boolean useToolBarFocus = this.isInToolBar(c);
        if (this.focused) {
            s = this.createOuterFocus(segmentStatus, x, y, width, height);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarFocus));
            g.draw(s);
            s = this.createInnerFocus(segmentStatus, x, y, width, height);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarFocus));
            g.draw(s);
        }
        s = this.createBorder(segmentStatus, x, y, width, height);
        if (!this.focused) {
            this.dropShadow.fill(g, s);
        }
        g.setPaint(this.getCommonBorderPaint(s, this.type));
        g.fill(s);
        s = this.createInterior(segmentStatus, x, y, width, height);
        g.setPaint(this.getCommonInteriorPaint(s, this.type));
        g.fill(s);
    }

    protected AbstractCommonColorsPainter.CommonControlState getButtonType(Which state) {
        switch (state) {
            case BACKGROUND_SELECTED_FOCUSED: 
            case BACKGROUND_SELECTED: {
                return AbstractCommonColorsPainter.CommonControlState.DEFAULT;
            }
            case BACKGROUND_DISABLED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case BACKGROUND_ENABLED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_PRESSED_SELECTED_FOCUSED: 
            case BACKGROUND_PRESSED: 
            case BACKGROUND_PRESSED_SELECTED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED;
            }
            case BACKGROUND_DISABLED_SELECTED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED_SELECTED;
            }
        }
        return null;
    }

    protected SegmentType getSegmentType(JComponent c) {
        SegmentType segmentType = SegmentType.NONE;
        String position = (String)c.getClientProperty("JTabbedPane.Tab.segmentPosition");
        if ("first".equals(position)) {
            segmentType = SegmentType.FIRST;
        } else if ("middle".equals(position)) {
            segmentType = SegmentType.MIDDLE;
        } else if ("last".equals(position)) {
            segmentType = SegmentType.LAST;
        }
        return segmentType;
    }

    protected Shape createOuterFocus(SegmentType segmentType, int x, int y, int w, int h) {
        switch (segmentType) {
            case FIRST: {
                return this.shapeGenerator.createRoundRectangle(x - 2, y - 2, w + 3, h + 3, ShapeGenerator.CornerSize.OUTER_FOCUS, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            }
            case MIDDLE: {
                return this.shapeGenerator.createRectangle(x - 2, y - 2, w + 3, h + 3);
            }
            case LAST: {
                return this.shapeGenerator.createRoundRectangle(x - 2, y - 2, w + 3, h + 3, ShapeGenerator.CornerSize.OUTER_FOCUS, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
            }
        }
        return this.shapeGenerator.createRoundRectangle(x - 2, y - 2, w + 3, h + 3, ShapeGenerator.CornerSize.OUTER_FOCUS);
    }

    protected Shape createInnerFocus(SegmentType segmentType, int x, int y, int w, int h) {
        switch (segmentType) {
            case FIRST: {
                return this.shapeGenerator.createRoundRectangle(x - 1, y - 1, w + 2, h + 1, ShapeGenerator.CornerSize.INNER_FOCUS, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            }
            case MIDDLE: {
                return this.shapeGenerator.createRectangle(x - 2, y - 1, w + 3, h + 1);
            }
            case LAST: {
                return this.shapeGenerator.createRoundRectangle(x - 2, y - 1, w + 2, h + 1, ShapeGenerator.CornerSize.INNER_FOCUS, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
            }
        }
        return this.shapeGenerator.createRoundRectangle(x - 1, y - 1, w + 1, h + 1, ShapeGenerator.CornerSize.INNER_FOCUS);
    }

    protected Shape createBorder(SegmentType segmentType, int x, int y, int w, int h) {
        switch (segmentType) {
            case FIRST: {
                return this.shapeGenerator.createRoundRectangle(x, y, w + 2, h, ShapeGenerator.CornerSize.BORDER, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            }
            case MIDDLE: {
                return this.shapeGenerator.createRectangle(x - 2, y, w + 4, h);
            }
            case LAST: {
                return this.shapeGenerator.createRoundRectangle(x - 2, y, w + 2, h, ShapeGenerator.CornerSize.BORDER, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
            }
        }
        return this.shapeGenerator.createRoundRectangle(x, y, w, h, ShapeGenerator.CornerSize.BORDER);
    }

    protected Shape createInterior(SegmentType segmentType, int x, int y, int w, int h) {
        switch (segmentType) {
            case FIRST: {
                return this.shapeGenerator.createRoundRectangle(x + 1, y + 1, w, h - 2, ShapeGenerator.CornerSize.INTERIOR, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            }
            case MIDDLE: {
                return this.shapeGenerator.createRectangle(x - 2, y + 1, w + 3, h - 2);
            }
            case LAST: {
                return this.shapeGenerator.createRoundRectangle(x - 2, y + 1, w + 1, h - 2, ShapeGenerator.CornerSize.INTERIOR, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
            }
        }
        return this.shapeGenerator.createRoundRectangle(x + 1, y + 1, w - 2, h - 2, ShapeGenerator.CornerSize.INTERIOR);
    }

    static enum SegmentType {
        NONE,
        FIRST,
        MIDDLE,
        LAST;

    }

    public static enum Which {
        BACKGROUND_ENABLED,
        BACKGROUND_PRESSED,
        BACKGROUND_DISABLED,
        BACKGROUND_DISABLED_SELECTED,
        BACKGROUND_SELECTED,
        BACKGROUND_PRESSED_SELECTED,
        BACKGROUND_SELECTED_FOCUSED,
        BACKGROUND_PRESSED_SELECTED_FOCUSED;

    }
}

